/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.parameter.primitive;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import javax.annotation.Nullable;
import mods.thecomputerizer.musictriggers.api.data.parameter.primitive.ParameterNumber;

public class ParameterFloat
extends ParameterNumber<Float> {
    public ParameterFloat(float defaultValue) {
        super(Float.valueOf(defaultValue));
    }

    public ParameterFloat(ByteBuf buf) {
        super(buf);
    }

    @Override
    public ParameterFloat copy() {
        ParameterFloat copy = new ParameterFloat(((Float)this.defaultValue).floatValue());
        copy.value = this.value;
        return copy;
    }

    @Override
    public boolean isByte() {
        return false;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public boolean isInt() {
        return false;
    }

    @Override
    public boolean isLong() {
        return false;
    }

    @Override
    public boolean isShort() {
        return false;
    }

    @Override
    protected Float read(ByteBuf buf) {
        return Float.valueOf(buf.readFloat());
    }

    @Override
    public void setValue(@Nullable Object value) {
        if (Objects.isNull(value)) {
            this.value = Float.valueOf(0.0f);
        } else if (value instanceof Boolean) {
            this.value = Float.valueOf((Boolean)value != false ? 1.0f : 0.0f);
        } else if (value instanceof Number) {
            this.value = Float.valueOf(((Number)value).floatValue());
        } else {
            try {
                this.value = Float.valueOf(Float.parseFloat(value.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void write(ByteBuf buf, Float val) {
        buf.writeFloat(val.floatValue());
    }
}

