/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.parameter;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mods.thecomputerizer.musictriggers.api.data.parameter.Parameter;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;

public class ParameterList<E>
extends Parameter<List<E>> {
    protected final Class<E> type;

    public ParameterList(Class<E> type, List<E> defaults) {
        super(defaults);
        this.type = type;
    }

    public ParameterList(ByteBuf buf) {
        super(buf);
        this.type = ClassHelper.findClass((String)NetworkHelper.readString((ByteBuf)buf));
    }

    @Override
    public ParameterList<E> copy() {
        ParameterList<E> copy = new ParameterList<E>(this.type, (List)this.defaultValue);
        copy.value = this.value;
        return copy;
    }

    @Override
    public boolean isBool() {
        return false;
    }

    @Override
    public boolean isByte() {
        return false;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isInt() {
        return false;
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public boolean isLong() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isShort() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    protected List<E> read(ByteBuf buf) {
        return NetworkHelper.readList((ByteBuf)buf, () -> GenericUtils.parseGenericType((String)NetworkHelper.readString((ByteBuf)buf), this.type));
    }

    @Override
    public void setValue(@Nullable Object value) {
        if (Objects.isNull(value)) {
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        if (value instanceof List) {
            list.addAll((List)value);
        } else {
            list.add(value);
        }
        this.value = list;
    }

    @Override
    protected void write(ByteBuf buf, List<E> val) {
        NetworkHelper.writeString((ByteBuf)buf, (String)this.type.getName());
        NetworkHelper.writeList((ByteBuf)buf, val, e -> NetworkHelper.writeString((ByteBuf)buf, (String)e.toString()));
    }
}

