/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.nbt.mode;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.BaseTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.CompoundTagAPI;

public abstract class NBTMode {
    private final String name;
    protected String[] split;
    private Collection<NBTMode> potentialChildren;
    protected NBTMode child;

    protected NBTMode(String name) {
        this.name = name;
    }

    protected void findChild(NBTMode parent) {
        if (this.hasValidSplit()) {
            for (NBTMode mode : this.potentialChildren) {
                if (!mode.name.equals(this.split[0])) continue;
                this.setChild(mode);
                break;
            }
        }
        if (Objects.nonNull(this.child)) {
            this.findChild(this.child);
            this.split = this.child.split;
        }
    }

    public boolean checkMatch(ChannelAPI channel, BaseTagAPI<?> tag) {
        this.potentialChildren = this.initPotentialChildren();
        this.findChild(this);
        boolean ret = false;
        try {
            ret = this.hasValidSplit() && tag.isCompound() && this.checkMatchInner(channel, tag.asCompoundTag());
        }
        catch (NumberFormatException ex) {
            channel.logError("Tried to check numerical value of NBT data against a non numerical value in `{}`", this.split, ex);
        }
        catch (Exception ex) {
            channel.logError("Caught an unknown error when attempting to check NBT data for `{}`", this.split, ex);
        }
        this.split = null;
        this.child = null;
        return ret;
    }

    protected abstract boolean checkMatchChild(ChannelAPI var1, CompoundTagAPI<?> var2, boolean var3);

    protected abstract boolean checkMatchInner(ChannelAPI var1, CompoundTagAPI<?> var2);

    @Nullable
    protected CompoundTagAPI<?> getNextCompound(@Nullable CompoundTagAPI<?> tag) {
        BaseTagAPI<?> based = this.getNextTag(tag);
        return Objects.nonNull(based) && based.isCompound() ? based.asCompoundTag() : null;
    }

    @Nullable
    protected BaseTagAPI<?> getNextTag(@Nullable CompoundTagAPI<?> tag) {
        if (Objects.isNull(tag)) {
            return null;
        }
        String name = this.stepSplit();
        return Objects.nonNull(name) ? tag.getTag(name) : null;
    }

    @Nonnull
    public abstract Collection<Supplier<NBTMode>> getPotentialChildren();

    public boolean hasValidSplit() {
        return Objects.nonNull(this.split) && this.split.length > 0;
    }

    protected Collection<NBTMode> initPotentialChildren() {
        if (Objects.nonNull(this.potentialChildren)) {
            return this.potentialChildren;
        }
        HashSet<NBTMode> set = new HashSet<NBTMode>();
        for (Supplier<NBTMode> childSupplier : this.getPotentialChildren()) {
            NBTMode child = childSupplier.get();
            if (!Objects.nonNull(child)) continue;
            set.add(child);
        }
        return Collections.unmodifiableSet(set);
    }

    protected void setChild(NBTMode child) {
        child.split = Arrays.copyOfRange(this.split, 1, this.split.length);
        this.child = child;
    }

    @Nullable
    protected String stepSplit() {
        String next;
        String string = next = this.hasValidSplit() ? this.split[0] : null;
        if (Objects.nonNull(next)) {
            int count = this.split.length;
            this.setSplit(count == 1 ? new String[]{} : Arrays.copyOfRange(this.split, 1, count));
        }
        return next;
    }

    @Nullable
    protected BaseTagAPI<?> stepToTag(CompoundTagAPI<?> tag, int steps) {
        while (Objects.nonNull(tag) && steps > 1) {
            tag = this.getNextCompound(tag);
        }
        return this.getNextTag(tag);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setSplit(String[] split) {
        this.split = split;
    }
}

