/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.log;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mods.thecomputerizer.musictriggers.api.data.log.LogMessage;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.io.LogHelper;
import org.apache.logging.log4j.Level;

public class MTLogger {
    public static final LogHelper.ModLogger LOGGER = LogHelper.create((String)"musictriggers");
    private static final List<LogMessage> LOGGED_MESSAGES = new ArrayList<LogMessage>();
    private static int reloadIndex = 0;

    public static List<LogMessage> getGUISnapshot() {
        ArrayList<LogMessage> snapshot = new ArrayList<LogMessage>();
        for (int i = reloadIndex; i < LOGGED_MESSAGES.size(); ++i) {
            snapshot.add(LOGGED_MESSAGES.get(i));
        }
        return Collections.unmodifiableList(snapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(String type, String typeName, Level level, String msg, Object ... args) {
        LogHelper.ModLogger modLogger = LOGGER;
        synchronized (modLogger) {
            LOGGED_MESSAGES.add(new LogMessage(level, type + "[" + typeName + "]: " + msg, args).log(LOGGER));
        }
    }

    public static void logDebug(String type, String typeName, String msg, Object ... args) {
        MTLogger.log(type, typeName, Level.DEBUG, msg, args);
    }

    public static void logError(String type, String typeName, String msg, Object ... args) {
        MTLogger.log(type, typeName, Level.ERROR, msg, args);
    }

    public static void logFatal(String type, String typeName, String msg, Object ... args) {
        MTLogger.log(type, typeName, Level.FATAL, msg, args);
    }

    public static void logInfo(String type, String typeName, String msg, Object ... args) {
        MTLogger.log(type, typeName, Level.INFO, msg, args);
    }

    public static void logTrace(String type, String typeName, String msg, Object ... args) {
        if (TILDev.DEV) {
            MTLogger.log(type, typeName, Level.TRACE, msg, args);
        }
    }

    public static void logWarn(String type, String typeName, String msg, Object ... args) {
        MTLogger.log(type, typeName, Level.WARN, msg, args);
    }

    public static void onReloadQueued() {
        reloadIndex = LOGGED_MESSAGES.size();
    }
}

