/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.global;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import mods.thecomputerizer.musictriggers.api.client.gui.MTScreenInfo;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.DataLink;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.ParameterLink;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelEventHandler;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelEventRunner;
import mods.thecomputerizer.musictriggers.api.data.global.GlobalElement;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;

public abstract class GlobalEventRunner
extends GlobalElement
implements ChannelEventRunner,
ChannelEventHandler {
    protected ChannelEventRunner.EventInstance instance;

    protected GlobalEventRunner(String name) {
        super(name);
    }

    @Override
    public void activate() {
        if (this.checkRun("activate")) {
            this.run();
        }
    }

    @Override
    public boolean checkRun(String type) {
        return Objects.nonNull(this.instance) && this.instance.checkSide() && this.instance.canRun(type);
    }

    @Override
    public void deactivate() {
        if (this.checkRun("deactivate")) {
            this.run();
        }
    }

    protected abstract ChannelAPI getChannelReference();

    @Override
    public Collection<DataLink> getChildWrappers(MTScreenInfo parent) {
        if (Objects.isNull(this.instance)) {
            this.instance = new ChannelEventRunner.EventInstance(this.getChannelReference(), this);
        }
        ParameterLink link = this.instance.getLink();
        ((DataLink)link).setType(parent.next("event", link));
        return Collections.singletonList(link);
    }

    @Override
    public String getLogPrefix() {
        return super.getLogPrefix();
    }

    @Override
    public boolean parse(Toml table) {
        if (super.parse(table)) {
            if (table.hasTable("event")) {
                ChannelEventRunner.EventInstance instance = new ChannelEventRunner.EventInstance(this.getChannelReference(), this);
                if (instance.parse(table.getTable("event"))) {
                    this.instance = instance;
                } else {
                    this.logError("Failed to parse event instance", new Object[0]);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void play(boolean unpaused) {
        if (this.checkRun("play")) {
            this.run();
        }
    }

    @Override
    public void playable() {
        if (this.checkRun("playable")) {
            this.run();
        }
    }

    @Override
    public void playing(boolean unpaused) {
        if (this.checkRun("playing")) {
            this.run();
        }
    }

    @Override
    public void queue() {
        if (this.checkRun("queue")) {
            this.run();
        }
    }

    @Override
    public void run() {
        this.instance.resetTimer();
    }

    @Override
    public void stop() {
        if (this.checkRun("stop")) {
            this.run();
        }
    }

    @Override
    public void stopped() {
        if (this.checkRun("stopped")) {
            this.run();
        }
    }

    @Override
    public boolean tick() {
        return this.instance.tick();
    }

    @Override
    public void tickActive(boolean unpaused) {
        if (this.checkRun("tick_active")) {
            this.run();
        }
    }

    @Override
    public void tickPlayable(boolean unpaused) {
        if (this.checkRun("tick_playable")) {
            this.run();
        }
    }

    @Override
    public void unplayable() {
        if (this.checkRun("unplayable")) {
            this.run();
        }
    }
}

