/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.channel;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.MTRef;
import mods.thecomputerizer.musictriggers.api.client.MTClient;
import mods.thecomputerizer.musictriggers.api.client.MTDebugInfo;
import mods.thecomputerizer.musictriggers.api.client.channel.ChannelClient;
import mods.thecomputerizer.musictriggers.api.client.channel.ChannelClientSpecial;
import mods.thecomputerizer.musictriggers.api.client.channel.ChannelJukebox;
import mods.thecomputerizer.musictriggers.api.client.channel.ChannelPreview;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.WrapperLink;
import mods.thecomputerizer.musictriggers.api.config.ConfigVersionManager;
import mods.thecomputerizer.musictriggers.api.data.audio.AudioPool;
import mods.thecomputerizer.musictriggers.api.data.audio.AudioRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelEventHandler;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelInfo;
import mods.thecomputerizer.musictriggers.api.data.channel.LoadTracker;
import mods.thecomputerizer.musictriggers.api.data.global.Debug;
import mods.thecomputerizer.musictriggers.api.data.global.GlobalData;
import mods.thecomputerizer.musictriggers.api.data.global.Toggle;
import mods.thecomputerizer.musictriggers.api.data.jukebox.RecordElement;
import mods.thecomputerizer.musictriggers.api.data.log.LoggableAPI;
import mods.thecomputerizer.musictriggers.api.data.log.MTLogger;
import mods.thecomputerizer.musictriggers.api.data.nbt.NBTHelper;
import mods.thecomputerizer.musictriggers.api.data.nbt.NBTLoadable;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerAPI;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerContext;
import mods.thecomputerizer.musictriggers.api.network.MTNetwork;
import mods.thecomputerizer.musictriggers.api.network.MessageFinishedInit;
import mods.thecomputerizer.musictriggers.api.network.MessageInitChannels;
import mods.thecomputerizer.musictriggers.api.network.MessageReload;
import mods.thecomputerizer.musictriggers.api.network.MessageRequestChannels;
import mods.thecomputerizer.musictriggers.api.network.MessageTriggerStates;
import mods.thecomputerizer.musictriggers.api.server.ChannelServer;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.MediaContainerRegistry;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.bandcamp.BandcampAudioSourceManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.beam.BeamAudioSourceManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.getyarn.GetyarnAudioSourceManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.http.HttpAudioSourceManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudAudioSourceManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.twitch.TwitchStreamAudioSourceManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.vimeo.VimeoAudioSourceManager;
import mods.thecomputerizer.shadow.dev.lavalink.youtube.YoutubeAudioSourceManager;
import mods.thecomputerizer.shadow.dev.lavalink.youtube.clients.Music;
import mods.thecomputerizer.shadow.dev.lavalink.youtube.clients.Tv;
import mods.thecomputerizer.shadow.dev.lavalink.youtube.clients.TvHtml5Embedded;
import mods.thecomputerizer.shadow.dev.lavalink.youtube.clients.Web;
import mods.thecomputerizer.shadow.dev.lavalink.youtube.clients.WebEmbedded;
import mods.thecomputerizer.shadow.dev.lavalink.youtube.clients.skeleton.Client;
import mods.thecomputerizer.theimpossiblelibrary.api.client.ClientAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.MinecraftAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.sound.SoundHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.blockentity.BlockEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.PlayerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemStackAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.io.FileHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.MinecraftServerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.ServerHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.ShapeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.BaseTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.CompoundTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.TagHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.TomlParsingException;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.TomlWritingException;
import mods.thecomputerizer.theimpossiblelibrary.api.util.CustomTick;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;
import mods.thecomputerizer.theimpossiblelibrary.api.util.RandomHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;

public class ChannelHelper
implements NBTLoadable {
    private static final Map<String, ChannelHelper> PLAYER_MAP = new HashMap<String, ChannelHelper>();
    private static final GlobalData globalData = new GlobalData();
    private static final LoadTracker loader = new LoadTracker();
    private static MessageRequestChannels<?> pendingRequest;
    private final Map<String, ChannelAPI> channels = Collections.synchronizedMap(new HashMap());
    private final List<Toggle> toggles = new ArrayList<Toggle>();
    private final boolean client;
    private final MTDebugInfo debugInfo;
    private boolean syncable;
    private final String playerID;
    private MessageTriggerStates<?> stateMsg;
    private MessageTriggerStates<?> syncedStatesMsg;
    private Map<String, Collection<ChannelAPI>> commandIDCache;
    private int ticks;

    public static void closePlayerChannel(String playerID) {
        ChannelHelper helper = PLAYER_MAP.get(playerID);
        if (Objects.nonNull(helper)) {
            helper.save();
            helper.close();
            PLAYER_MAP.remove(playerID);
        }
        globalData.close();
    }

    public static String executeCommandTrigger(PlayerAPI<?, ?> player, String id) {
        String uuid = player.getUUID().toString();
        ChannelHelper helper = ChannelHelper.getServerHelper(uuid);
        return Objects.nonNull(helper) ? helper.executeCommandTriggers(id) : "Failed to find ChannelHelper for UUID " + uuid;
    }

    public static void flipDebugParameter(boolean client, String name) {
        if (client) {
            ChannelHelper helper = ChannelHelper.getClientHelper();
            if (Objects.nonNull(helper)) {
                helper.flipDebugParameter(name);
            }
        } else {
            for (ChannelHelper helper : PLAYER_MAP.values()) {
                if (helper.client) continue;
                helper.flipDebugParameter(name);
            }
        }
    }

    public static void generateDedicatedServerFiles() {
        try {
            ConfigVersionManager.queryRemap();
            globalData.parse(ChannelHelper.openToml("config/MusicTriggers/global", true, globalData));
        }
        catch (Exception ex) {
            throw new RuntimeException("Error parsing global data!", ex);
        }
    }

    public static List<String> getCommandIdentifiers(PlayerAPI<?, ?> player) {
        ChannelHelper helper = ChannelHelper.getServerHelper(player.getUUID().toString());
        return new ArrayList<String>(Objects.nonNull(helper) ? helper.getCommandIDCache() : new HashSet());
    }

    public static Debug getDebug() {
        return globalData.getDebug();
    }

    public static boolean getDebugBool(String name) {
        Debug debug = ChannelHelper.getDebug();
        return Objects.nonNull(debug) && debug.getParameterAsBoolean(name);
    }

    public static Number getDebugNumber(String name) {
        Debug debug = ChannelHelper.getDebug();
        return Objects.nonNull(debug) ? (Number)debug.getParameterAsNumber(name) : (Number)0;
    }

    public static String getDebugString(String name) {
        Debug debug = ChannelHelper.getDebug();
        if (Objects.isNull(debug)) {
            return "";
        }
        String ret = debug.getParameterAsString(name);
        return Objects.nonNull(ret) ? ret : "";
    }

    public static int getTickRate() {
        Debug debug = ChannelHelper.getGlobalData().getDebug();
        return Objects.nonNull(debug) ? debug.getParameterAsInt("tick_rate") : 20;
    }

    public static ChannelHelper getHelper(String uuid, boolean client) {
        return client ? ChannelHelper.getClientHelper(uuid) : ChannelHelper.getServerHelper(uuid);
    }

    public static ChannelHelper getClientHelper() {
        return PLAYER_MAP.get("CLIENT");
    }

    private static ChannelHelper getClientHelper(String uuid) {
        ChannelHelper helper = PLAYER_MAP.get("CLIENT");
        return Objects.nonNull(helper) && uuid.equals(String.valueOf(helper.getPlayerID())) ? helper : null;
    }

    private static ChannelHelper getServerHelper(String uuid) {
        if (!PLAYER_MAP.containsKey(uuid)) {
            PLAYER_MAP.put(uuid, new ChannelHelper(uuid, false));
        }
        return PLAYER_MAP.get(uuid);
    }

    public static List<? extends PlayerAPI<?, ?>> getPlayers(boolean client) {
        if (client) {
            PlayerAPI player;
            MinecraftAPI mc = (MinecraftAPI)TILRef.getClientSubAPI(ClientAPI::getMinecraft);
            if (Objects.nonNull(mc) && Objects.nonNull(player = mc.getPlayer())) {
                return Collections.singletonList(player);
            }
        } else {
            MinecraftServerAPI server = ServerHelper.getAPI();
            if (Objects.nonNull(server)) {
                return server.getPlayers();
            }
        }
        return new ArrayList();
    }

    public static void initClient() {
        ChannelHelper.logGlobalInfo("Initializing client channel data", new Object[0]);
        ChannelHelper.loadConfig("CLIENT", true);
    }

    public static void loadConfig(String playerID, boolean client) throws TomlWritingException {
        try {
            ConfigVersionManager.queryRemap();
            globalData.parse(ChannelHelper.openToml("config/MusicTriggers/global", true, globalData));
        }
        catch (Exception ex) {
            throw new RuntimeException("Error parsing global data!", ex);
        }
        ChannelHelper helper = new ChannelHelper(playerID, client);
        helper.loadFromFile(globalData.getGlobal());
        PLAYER_MAP.put(playerID, helper);
        loader.setClient(client);
        loader.setLoading(false);
        if (loader.isConnected() || !client) {
            ChannelHelper.logGlobalInfo("SENDING INIT MESSAGE", new Object[0]);
            if (client) {
                MTNetwork.sendToServer(helper.getInitMessage());
            } else {
                MTNetwork.sendToClient(helper.getInitMessage(), playerID);
            }
        }
    }

    public static MessageFinishedInit<?> loadMessage(MessageInitChannels<?> init) {
        ChannelHelper helper = globalData.loadFromInit(init);
        PLAYER_MAP.put(init.getUuid(), helper);
        helper.setSyncable(true);
        loader.setLoading(false);
        ChannelHelper.logGlobalInfo("SENDING FINISHED INIT MESSAGE", new Object[0]);
        return new MessageFinishedInit(helper, NBTHelper.readWorldData(helper));
    }

    public static void logGlobalDebug(String msg, Object ... args) {
        globalData.logDebug(msg, args);
    }

    public static void logGlobalError(String msg, Object ... args) {
        globalData.logError(msg, args);
    }

    public static void logGlobalFatal(String msg, Object ... args) {
        globalData.logFatal(msg, args);
    }

    public static void logGlobalInfo(String msg, Object ... args) {
        globalData.logInfo(msg, args);
    }

    public static void logGlobalWarn(String msg, Object ... args) {
        globalData.logWarn(msg, args);
    }

    public static void onClientConnected() {
        MTRef.logInfo("CLIENT CONNECTED", new Object[0]);
        loader.setConnected(true);
        ChannelHelper helper = ChannelHelper.getClientHelper();
        if (Objects.nonNull(helper)) {
            for (ChannelAPI channelAPI : helper.channels.values()) {
            }
            ChannelHelper.processPendingRequest(helper);
        } else {
            MTRef.logError("The client helper is missing on the client side??", new Object[0]);
        }
    }

    public static void onClientDisconnected() {
        MTRef.logInfo("CLIENT DISCONNECTED", new Object[0]);
        loader.setConnected(false);
        ChannelHelper helper = ChannelHelper.getClientHelper();
        if (Objects.nonNull(helper)) {
            helper.channels.values().forEach(channel -> channel.getData().getTriggerEventMap().keySet().forEach(TriggerAPI::onDisconnected));
            helper.setSyncable(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onReloadQueued(boolean client) {
        String contextSide = client ? "client" : "server";
        String loaderSide = loader.isClient() ? "client" : "server";
        loader.setLoading(true);
        loader.setClient(client);
        globalData.logInfo("Queued reload on the {} side for a {} loader", contextSide, loaderSide);
        Map<String, ChannelHelper> map = PLAYER_MAP;
        synchronized (map) {
            for (ChannelHelper helper : PLAYER_MAP.values()) {
                helper.close();
            }
            PLAYER_MAP.clear();
        }
        MTLogger.onReloadQueued();
    }

    public static void onResourcesLoaded() {
        for (ChannelHelper helper : PLAYER_MAP.values()) {
            if (!helper.client) continue;
            loader.setResourcesLoaded(true);
            helper.forEachChannel(ChannelAPI::onResourcesLoaded);
        }
    }

    @Nullable
    public static Toml openToml(String path, boolean writeDefaults, LoggableAPI logger) {
        String tomlPath = path + ".toml";
        try {
            File file = FileHelper.get((String)tomlPath, (boolean)false);
            Toml toml = Toml.readFile((File)file);
            String name = file.getName().substring(0, file.getName().length() - 5);
            if (Objects.nonNull(toml) && writeDefaults) {
                ConfigVersionManager.writeDefaults(toml, name, path);
            }
            return toml;
        }
        catch (IOException | TomlParsingException ex) {
            String msg = "Unable to read toml file at `{}`!";
            if (Objects.nonNull(logger)) {
                logger.logError(msg, tomlPath, ex);
            } else {
                ChannelHelper.logGlobalError(msg, tomlPath, ex);
            }
            return null;
        }
    }

    public static List<String> openTxt(String path, @Nullable LoggableAPI logger) {
        List lines;
        if (!path.endsWith(".txt")) {
            path = path + ".txt";
        }
        if ((lines = FileHelper.toLines((File)FileHelper.get((String)path, (boolean)false))).isEmpty()) {
            String msg = "No lines were read in from {}";
            if (Objects.nonNull(logger)) {
                logger.logWarn(msg, path);
            } else {
                ChannelHelper.logGlobalWarn(msg, path);
            }
        }
        return lines;
    }

    public static MessageAPI<?> processChannelsRequest(MessageRequestChannels<?> message) {
        ChannelHelper helper = ChannelHelper.getHelper(message.getUuid(), message.isClient());
        MTRef.logInfo("Is helper null? {}", Objects.isNull(helper));
        if (Objects.nonNull(helper)) {
            return helper.getInitMessage();
        }
        MTRef.logInfo("Adding pending message for client that is not ready to respond yet", new Object[0]);
        pendingRequest = message;
        return null;
    }

    private static void processPendingRequest(ChannelHelper helper) {
        if (Objects.nonNull(pendingRequest)) {
            if (Objects.isNull(helper.getPlayer())) {
                return;
            }
            if (helper.client != pendingRequest.isClient()) {
                String requestSide = pendingRequest.isClient() ? "CLIENT" : "SERVER";
                String helperSide = helper.client ? "CLIENT" : "SERVER";
                MTRef.logError("Tried to answer pending channels request on the wrong side! Expected {} but instead got {}", requestSide, helperSide);
            } else {
                MTRef.logInfo("Answering pending channels request", new Object[0]);
                MTNetwork.sendToServer(helper.getInitMessage());
            }
            pendingRequest = null;
        }
    }

    public static void reload(boolean clientConext) {
        ChannelHelper.logGlobalInfo("RELOADING", new Object[0]);
        try {
            if (loader.isClient()) {
                if (clientConext) {
                    ChannelHelper.loadConfig("CLIENT", true);
                } else {
                    MTNetwork.sendToServer(new MessageReload(0));
                }
            } else {
                for (PlayerAPI<?, ?> player : ChannelHelper.getPlayers(false)) {
                    String uuid = player.getUUID().toString();
                    if (clientConext) {
                        MTNetwork.sendToClient(new MessageReload(0), uuid);
                        continue;
                    }
                    ChannelHelper.loadConfig(uuid, false);
                }
            }
        }
        catch (TomlWritingException ex) {
            ChannelHelper.logGlobalFatal("Failed to reload config files!", new Object[]{ex});
        }
    }

    public static void registerRemoteSources(ChannelAPI channel, AudioPlayerManager manager) {
        ChannelHelper.registerYouTubeSource(channel, manager);
        ChannelHelper.registerRemoteSource(channel, manager, "SoundCloud", SoundCloudAudioSourceManager::createDefault);
        ChannelHelper.registerRemoteSource(channel, manager, "BandCamp", BandcampAudioSourceManager::new);
        ChannelHelper.registerRemoteSource(channel, manager, "Vimeo", VimeoAudioSourceManager::new);
        ChannelHelper.registerRemoteSource(channel, manager, "Twitch", TwitchStreamAudioSourceManager::new);
        ChannelHelper.registerRemoteSource(channel, manager, "Beam", BeamAudioSourceManager::new);
        ChannelHelper.registerRemoteSource(channel, manager, "Getyarn", GetyarnAudioSourceManager::new);
        ChannelHelper.registerRemoteSource(channel, manager, "HTTPAudio", () -> new HttpAudioSourceManager(MediaContainerRegistry.DEFAULT_REGISTRY));
    }

    private static void registerRemoteSource(ChannelAPI channel, AudioPlayerManager manager, String sourceName, Supplier<AudioSourceManager> supplier) {
        try {
            manager.registerSourceManager(supplier.get());
        }
        catch (Exception ex) {
            channel.logError("Failed to register remote source for `{}`!", sourceName, ex);
        }
    }

    private static void registerYouTubeSource(ChannelAPI channel, AudioPlayerManager manager) {
        Supplier<AudioSourceManager> supplier = () -> {
            Client[] clients = new Client[]{new Tv(), new TvHtml5Embedded(), new Music(), new Web(), new WebEmbedded()};
            return new YoutubeAudioSourceManager(clients);
        };
        ChannelHelper.registerRemoteSource(channel, manager, "YouTube", supplier);
    }

    public static void setDebugParameter(boolean client, String name, Object value) {
        if (client) {
            ChannelHelper helper = ChannelHelper.getClientHelper();
            if (Objects.nonNull(helper)) {
                helper.setDebugParameter(name, value);
            }
        } else {
            for (ChannelHelper helper : PLAYER_MAP.values()) {
                if (helper.client) continue;
                helper.setDebugParameter(name, value);
            }
        }
    }

    @IndirectCallers
    public static boolean stopVanillaMusicTicker() {
        if (loader.isLoading()) {
            return false;
        }
        ChannelHelper clientHelper = ChannelHelper.getClientHelper();
        return Objects.isNull(clientHelper) || clientHelper.canVanillaMusicPlay();
    }

    public static void tick(@Nullable CustomTick ticker) {
        if (!loader.isLoading() && Objects.nonNull(ticker) && ticker.isEquivalentTPS(ChannelHelper.getTickRate())) {
            for (ChannelHelper helper : PLAYER_MAP.values()) {
                helper.tickChannels();
            }
        }
    }

    @IndirectCallers
    public static void updateVolumeSources() {
        ChannelHelper clientHelper = ChannelHelper.getClientHelper();
        if (Objects.nonNull(clientHelper)) {
            clientHelper.queryCategoryVolume();
        }
    }

    public ChannelHelper(String playerID, boolean client) {
        this.client = client;
        this.playerID = playerID;
        this.debugInfo = client ? new MTDebugInfo(this) : null;
        loader.setClient(client);
    }

    private void cacheCommandIDs() {
        HashMap cache = new HashMap();
        for (ChannelAPI channel : this.channels.values()) {
            if (channel instanceof ChannelClientSpecial) continue;
            for (String id : channel.getCommandIds()) {
                if (!cache.containsKey(id)) {
                    cache.put(id, new ArrayList());
                }
                ((Collection)cache.get(id)).add(channel);
            }
        }
        this.commandIDCache = Collections.unmodifiableMap(cache);
    }

    public boolean canVanillaMusicPlay() {
        for (ChannelAPI channel : this.channels.values()) {
            if (!channel.shouldBlockMusicTicker()) continue;
            return false;
        }
        return true;
    }

    public boolean checkForJukebox() {
        PlayerAPI<?, ?> player = this.getPlayer();
        if (Objects.nonNull(player)) {
            Vector3 pos = player.getPosExact();
            Box box = ShapeHelper.box((Vector3)pos, (double)126.0);
            for (BlockEntityAPI entity : player.getWorld().getBlockEntitiesInBox(box)) {
                if (!entity.getRegistryName().getPath().contains("jukebox") || !entity.getState().getPropertyBool("has_record")) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.stateMsg = null;
        Map<String, ChannelAPI> map = this.channels;
        synchronized (map) {
            for (ChannelAPI channel : this.channels.values()) {
                channel.close();
            }
        }
        this.channels.clear();
        this.commandIDCache = null;
        for (Toggle toggle : this.toggles) {
            toggle.close();
        }
        this.toggles.clear();
    }

    @Nullable
    public ChannelAPI decodeChannel(ByteBuf buf) {
        return this.findChannel(globalData, NetworkHelper.readString((ByteBuf)buf));
    }

    private String executeCommandTriggers(String id) {
        Collection<ChannelAPI> channels;
        if (Objects.isNull(this.commandIDCache)) {
            this.cacheCommandIDs();
        }
        if (Objects.nonNull(channels = this.commandIDCache.get(id))) {
            channels.forEach(channel -> channel.executeCommandTrigger(id));
            return null;
        }
        return "No channels found for command trigger with identifier '" + id + "'";
    }

    @Nullable
    public ChannelAPI findChannel(LoggableAPI logger, String channelName) {
        ChannelAPI channel = this.channels.get(channelName);
        if (Objects.isNull(channel)) {
            logger.logError("Unable to find channel with name `{}`!", channelName);
        }
        return channel;
    }

    @Nullable
    public ChannelAPI findFirstUserChannel() {
        for (ChannelAPI channel : this.channels.values()) {
            if (channel.isClientChannel() != this.client || Misc.equalsAny((Object)channel.getName(), (Object[])new String[]{"jukebox", "preview"})) continue;
            return channel;
        }
        ChannelHelper.logGlobalWarn("Unable to find any user specified channels!", new Object[0]);
        return null;
    }

    public void flipDebugParameter(String name) {
        Debug debug = ChannelHelper.getDebug();
        if (Objects.nonNull(debug)) {
            debug.flipBooleanParameter(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachChannel(Consumer<ChannelAPI> consumer) {
        Map<String, ChannelAPI> map = this.channels;
        synchronized (map) {
            this.channels.values().forEach(consumer);
        }
    }

    public Set<String> getCommandIDCache() {
        if (Objects.nonNull(this.commandIDCache)) {
            return this.commandIDCache.keySet();
        }
        this.cacheCommandIDs();
        return this.commandIDCache.keySet();
    }

    public MessageInitChannels<?> getInitMessage() {
        Toml toggles = globalData.openToggles();
        return new MessageInitChannels(globalData.getGlobal(), toggles, this);
    }

    public ChannelJukebox getJukeboxChannel() {
        if (!this.client) {
            globalData.logError("Attempted to get jukebox channel on the server side! Things may break", new Object[0]);
            return null;
        }
        return (ChannelJukebox)this.channels.get("jukebox");
    }

    @Nullable
    public PlayerAPI<?, ?> getPlayer() {
        if (this.client) {
            MinecraftAPI mc = (MinecraftAPI)TILRef.getClientSubAPI(ClientAPI::getMinecraft);
            return Objects.nonNull(mc) ? mc.getPlayer() : null;
        }
        for (ChannelAPI channel : this.channels.values()) {
            PlayerAPI player = channel.getPlayerEntity();
            if (!Objects.nonNull(player)) continue;
            return channel.getPlayerEntity();
        }
        return null;
    }

    public String getPlayerID() {
        if (!this.client) {
            return this.playerID;
        }
        PlayerAPI<?, ?> player = this.getPlayer();
        if (Objects.isNull(player)) {
            ChannelHelper.logGlobalDebug("Tried to get the client player ID but the player was null", new Object[0]);
        }
        return Objects.nonNull(player) ? player.getUUID().toString() : null;
    }

    public ChannelPreview getPreviewChannel() {
        if (!this.client) {
            globalData.logError("Attempted to get preview channel on the server side! Things may break", new Object[0]);
            return null;
        }
        return (ChannelPreview)this.channels.get("preview");
    }

    public WrapperLink getTogglesLink() {
        return new WrapperLink(this.toggles);
    }

    @Override
    public boolean hasDataToSave() {
        for (ChannelAPI channel : this.channels.values()) {
            if (!channel.hasDataToSave()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initChannel(String name, Toml info) {
        Map<String, ChannelAPI> map = this.channels;
        synchronized (map) {
            if (this.channels.containsKey(name)) {
                globalData.logError("Channel with name `{}` already exists!", new Object[0]);
            } else {
                ChannelAPI channel;
                ChannelAPI channelAPI = channel = this.client ? new ChannelClient(this, info) : new ChannelServer(this, info);
                if (channel.isValid()) {
                    this.channels.put(name, channel);
                } else {
                    globalData.logError("Channel with name `{}` is invalid!", new Object[0]);
                }
            }
        }
    }

    private void initChannels(Toml toml) throws TomlWritingException {
        if (!toml.hasTable("channels")) {
            this.writeExampleChannel(toml);
        }
        Toml table = toml.getTable("channels");
        for (Toml info : table.getAllTables()) {
            if (Objects.nonNull(info)) {
                this.initChannel(info.getName(), info);
                continue;
            }
            globalData.logError("Channel `{}` does not have an info table! This should not be possible.", new Object[0]);
        }
    }

    public void loadFromFile(@Nullable Toml globalHolder) throws TomlWritingException {
        if (Objects.isNull(globalHolder)) {
            globalData.logFatal("Cannot initialize channel or toggle data from missing global config!", new Object[0]);
            return;
        }
        this.initChannels(globalHolder);
        this.parseData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromInit(MessageInitChannels<?> init) {
        Set<Map.Entry<String, MessageInitChannels.ChannelMessage>> channelMessages = init.getChannels().entrySet();
        for (Map.Entry<String, MessageInitChannels.ChannelMessage> entry : channelMessages) {
            String name = entry.getKey();
            Toml info = globalData.getGlobal().getTable("channels").getTable(name);
            ChannelAPI channel2 = this.client ? new ChannelClient(this, info) : new ChannelServer(this, info);
            Map<String, ChannelAPI> map = this.channels;
            synchronized (map) {
                this.channels.put(name, channel2);
            }
        }
        for (Map.Entry<String, MessageInitChannels.ChannelMessage> entry : channelMessages) {
            Map<String, ChannelAPI> map = this.channels;
            synchronized (map) {
                ChannelAPI channel3 = this.channels.get(entry.getKey());
                channel3.getData().load(entry.getValue());
            }
        }
        Map<String, ChannelAPI> map = this.channels;
        synchronized (map) {
            this.channels.values().forEach(channel -> channel.getData().setupLinkTargets());
        }
        globalData.parseToggles(this, init.getToggles());
        globalData.logInfo("Finished loading external channel data", new Object[0]);
        if (this.client) {
            globalData.logInfo("Attempting to load stored audio references", new Object[0]);
            this.debugInfo.initChannelElements();
            this.queryCategoryVolume();
        }
        this.forEachChannel(this::loadTracks);
    }

    public void loadTracks(ChannelAPI channel) {
        if (this.client) {
            channel.loadTracks(loader.areResourcesLoaded());
        } else {
            channel.getData().getAudio().forEach(ref -> ref.setItem(null));
        }
    }

    @Override
    public void onConnected(CompoundTagAPI<?> worldData) {
        ChannelHelper.logGlobalInfo("Connected on the {} side", this.client ? "CLIENT" : "SERVER");
        ChannelHelper.logGlobalInfo("onConnected world data for {} is {}", this.getPlayerID(), worldData);
        for (ChannelAPI channel : this.channels.values()) {
            if (!worldData.contains(channel.getName())) continue;
            channel.onConnected(worldData.getCompoundTag(channel.getName()));
        }
    }

    @Override
    public void onLoaded(CompoundTagAPI<?> globalData) {
    }

    public void parseData() {
        for (ChannelAPI channel : this.channels.values()) {
            channel.parseData();
        }
        for (ChannelAPI channel : this.channels.values()) {
            channel.getData().setupLinkTargets();
        }
        globalData.logInfo("Finished parsing channel data", new Object[0]);
        globalData.parseToggles(this);
        globalData.logInfo("Finished parsing toggles", new Object[0]);
        if (this.client) {
            this.channels.put("jukebox", MTClient.getJukeboxChannel(this));
            this.channels.put("preview", MTClient.getPreviewChannel(this));
            globalData.logInfo("Attempting to load stored audio references", new Object[0]);
            this.debugInfo.initChannelElements();
            this.queryCategoryVolume();
        }
        this.forEachChannel(this::loadTracks);
    }

    public void playToJukebox(BlockPosAPI<?> pos, String channelName, String audioRef) {
        ChannelAPI channel = this.channels.get(channelName);
        if (Objects.nonNull(channel)) {
            AudioRef playThis = null;
            for (AudioRef ref : channel.getData().getAudio()) {
                if (!ref.getName().equals(audioRef)) continue;
                playThis = ref;
            }
            if (Objects.nonNull(playThis)) {
                this.getJukeboxChannel().playReference(playThis, pos.getPosVec());
            } else {
                channel.logError("Unable to find audio with name {} to play for the jukebox channel!", audioRef);
            }
        } else {
            globalData.logError("Unable to find channel reference {}", channelName);
        }
    }

    public void queryCategoryVolume() {
        float masterVolume = SoundHelper.getCategoryVolume((String)"master");
        for (ChannelAPI channel : this.channels.values()) {
            channel.setMasterVolume(masterVolume);
            String category = channel.getInfo().getCategory();
            if (category.equalsIgnoreCase("master")) {
                channel.setCategoryVolume(1.0f);
                continue;
            }
            channel.setCategoryVolume(SoundHelper.getCategoryVolume((String)category));
        }
    }

    public void save() {
        NBTHelper.saveWorldData(this);
    }

    @Override
    public void saveGlobalTo(CompoundTagAPI<?> globalData) {
    }

    @Override
    public void saveWorldTo(CompoundTagAPI<?> worldData) {
        for (ChannelAPI channel : this.channels.values()) {
            if (!channel.hasDataToSave()) continue;
            CompoundTagAPI channelTag = TagHelper.makeCompoundTag();
            channel.saveWorldTo(channelTag);
            worldData.putTag(channel.getName(), (BaseTagAPI)channelTag);
        }
    }

    public void seek(String channelName, long seconds) {
        long ms = seconds * 1000L;
        if ("-".equals(channelName)) {
            this.forEachChannel(channel -> {
                if (Objects.nonNull(channel.getPlayer().getPlayingTrack())) {
                    channel.seek(ms);
                }
            });
        } else {
            ChannelAPI channel2 = this.channels.get(channelName);
            if (Objects.nonNull(channel2)) {
                channel2.seek(ms);
            } else {
                ChannelHelper.logGlobalError("Tried to seek to {} in nonexistant channel {}!", seconds, channelName);
            }
        }
    }

    public void setCategoryVolume(String category, float volume) {
        this.forEachChannel(channel -> {
            if (category.equals("master")) {
                channel.setMasterVolume(volume);
            } else if (category.equals(channel.getInfo().getCategory())) {
                channel.setCategoryVolume(volume);
            }
        });
    }

    public void setDebugParameter(String name, Object value) {
        Debug debug = ChannelHelper.getDebug();
        if (Objects.nonNull(debug)) {
            debug.setParameterValue(name, value);
        } else {
            ChannelHelper.logGlobalError("Cannot set debug value {} = {} because Debug does not exist??", name, value instanceof String ? "\"" + value + "\"" : value);
        }
    }

    public void setDiscTag(ItemStackAPI<?> stack, String channel, String trigger, String audio, boolean custom) {
        CompoundTagAPI tag = TagHelper.makeCompoundTag();
        tag.putString("channel", channel);
        tag.putString("triggerID", trigger);
        if (custom) {
            tag.putString("custom", audio);
        } else {
            tag.putString("audio", audio);
        }
        stack.setTag(tag);
    }

    public void setSyncable(boolean sync) {
        this.forEachChannel(channel -> {
            TriggerContext context = channel.getSelector().getContext();
            if (!this.syncable && sync) {
                context.initSync();
            } else if (this.syncable && !sync) {
                context.clearSync();
            }
        });
        this.syncable = sync;
    }

    public void stopJukeboxAt(BlockPosAPI<?> pos) {
        this.getJukeboxChannel().checkStop(pos.getPosVec());
    }

    protected void sync() {
        ChannelHelper.processPendingRequest(this);
        if (this.syncable) {
            if (Objects.nonNull(this.syncedStatesMsg)) {
                this.syncedStatesMsg.handle();
                this.syncedStatesMsg = null;
            }
            if (Objects.isNull(this.stateMsg)) {
                this.stateMsg = new MessageTriggerStates(this);
            }
            for (ChannelAPI channel : this.channels.values()) {
                channel.getSync().addSynced(this.stateMsg);
            }
            if (this.stateMsg.readyToSend() && MTNetwork.send(this.stateMsg, this, false)) {
                this.stateMsg = null;
            }
        }
    }

    public void tickChannels() {
        if (loader.isLoading()) {
            return;
        }
        boolean jukebox = this.client && this.checkForJukebox();
        boolean slow = this.ticks++ % ChannelHelper.getDebugNumber("slow_tick_factor").intValue() == 0;
        for (ChannelAPI channel : this.channels.values()) {
            boolean unpaused = channel.tick(jukebox, true);
            if (!slow) continue;
            channel.tickSlow(unpaused);
        }
        if (slow) {
            this.sync();
            this.ticks = 0;
        }
    }

    public Toml togglesAsToml() {
        Toml toml = Toml.getEmpty();
        for (Toggle toggle : this.toggles) {
            toml.addTable("toggle", toggle.toToml());
        }
        return toml;
    }

    public void tryHandleTriggerStateSync(MessageTriggerStates<?> syncedStatesMsg) {
        if (this.syncable) {
            syncedStatesMsg.handle();
        } else {
            this.syncedStatesMsg = syncedStatesMsg;
        }
    }

    private boolean writeBasicDisc(ItemStackAPI<?> stack) {
        HashMap<String, TriggerAPI> activeTriggers = new HashMap<String, TriggerAPI>();
        for (ChannelAPI channel : this.channels.values()) {
            TriggerAPI activeTrigger = channel.getActiveTrigger();
            if (!Objects.nonNull(activeTrigger)) continue;
            activeTriggers.put(channel.getName(), activeTrigger);
        }
        if (activeTriggers.isEmpty()) {
            return false;
        }
        Map.Entry selected = (Map.Entry)RandomHelper.getBasicRandomEntry(activeTriggers.entrySet());
        String songName = this.channels.get(selected.getKey()).getPlayingSongName();
        if (TextHelper.isBlank((String)songName)) {
            return false;
        }
        this.setDiscTag(stack, (String)selected.getKey(), ((TriggerAPI)selected.getValue()).getName(), songName, false);
        return true;
    }

    public void writeDisc(ItemStackAPI<?> stack, boolean special) {
        String discType;
        String string = discType = special ? "special music disc" : "music disc";
        if (special ? this.writeSpecialDisc(stack) : this.writeBasicDisc(stack)) {
            ChannelHelper.logGlobalDebug("Successfully recorded {}", discType);
        } else {
            ChannelHelper.logGlobalWarn("Failed to record {}", discType);
        }
    }

    private void writeExampleChannel(Toml toml) throws TomlWritingException {
        Toml table = toml.addTable("channels", false);
        ChannelInfo.writeExampleData(table.addTable("example", false));
    }

    private boolean writeSpecialDisc(ItemStackAPI<?> stack) {
        String songName;
        String triggerName;
        ChannelAPI channel2;
        HashMap<String, ArrayList<ChannelEventHandler>> specialHandlers = new HashMap<String, ArrayList<ChannelEventHandler>>();
        for (ChannelAPI channel2 : this.channels.values()) {
            ArrayList<ChannelEventHandler> triggers = new ArrayList<ChannelEventHandler>();
            channel2.getData().collectSpecialHandlers(triggers);
            if (triggers.isEmpty()) continue;
            specialHandlers.put(channel2.getName(), triggers);
        }
        if (specialHandlers.isEmpty()) {
            return false;
        }
        Map.Entry selected = (Map.Entry)RandomHelper.getBasicRandomEntry(specialHandlers.entrySet());
        channel2 = this.channels.get(selected.getKey());
        if (Objects.isNull(channel2)) {
            return false;
        }
        ChannelEventHandler handler = (ChannelEventHandler)RandomHelper.getBasicRandomEntry((Collection)((Collection)selected.getValue()));
        boolean custom = false;
        if (handler instanceof TriggerAPI) {
            TriggerAPI trigger = (TriggerAPI)handler;
            triggerName = trigger.getName();
            AudioPool pool = trigger.getAudioPool();
            if (Objects.isNull(pool)) {
                return false;
            }
            songName = ((AudioRef)RandomHelper.getBasicRandomEntry(pool.getFlattened())).getName();
        } else if (handler instanceof RecordElement) {
            triggerName = "generic";
            songName = ((RecordElement)handler).getKey();
            custom = true;
        } else {
            return false;
        }
        if (TextHelper.isBlank((String)songName) || TextHelper.isBlank((String)triggerName)) {
            return false;
        }
        this.setDiscTag(stack, channel2.getName(), triggerName, songName, custom);
        return true;
    }

    @Generated
    public static GlobalData getGlobalData() {
        return globalData;
    }

    @Generated
    public static LoadTracker getLoader() {
        return loader;
    }

    @Generated
    public Map<String, ChannelAPI> getChannels() {
        return this.channels;
    }

    @Generated
    public List<Toggle> getToggles() {
        return this.toggles;
    }

    @Generated
    public boolean isClient() {
        return this.client;
    }

    @Generated
    public MTDebugInfo getDebugInfo() {
        return this.debugInfo;
    }

    @Generated
    public boolean isSyncable() {
        return this.syncable;
    }
}

