/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.channel;

import java.util.Objects;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.data.MTDataRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.parameter.ParameterWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;

public interface ChannelEventRunner {
    public boolean checkRun(String var1);

    public String getLogPrefix();

    public boolean isClient();

    public boolean isServer();

    public void run();

    public boolean tick();

    public static class EventInstance
    extends ParameterWrapper {
        protected final ChannelEventRunner parent;
        protected ChannelAPI channel;
        private String event;
        private String song;
        private int interval;
        private int start;
        private int end;
        private int timer;

        public EventInstance(ChannelAPI channel, ChannelEventRunner parent) {
            super("event");
            this.channel = channel;
            this.parent = parent;
        }

        public boolean canRun(String event) {
            if (event.equalsIgnoreCase(this.event)) {
                if (this.parent.isServer()) {
                    return true;
                }
                if ("_".equals(this.song)) {
                    return true;
                }
                String song = this.channel.getPlayingSongName();
                return Objects.nonNull(song) && song.equals(this.song);
            }
            return false;
        }

        public boolean checkSide() {
            if (this.parent.isClient()) {
                return this.channel.isClientChannel();
            }
            if (this.parent.isServer()) {
                return !this.channel.isClientChannel();
            }
            this.logInfo("Wrong side", new Object[0]);
            return false;
        }

        @Override
        protected String getLogPrefix() {
            return this.parent.getLogPrefix() + " Event Handler: ";
        }

        @Override
        public MTDataRef.TableRef getReferenceData() {
            return MTDataRef.EVENT_RUNNER;
        }

        @Override
        public Class<? extends ParameterWrapper> getTypeClass() {
            return EventInstance.class;
        }

        @Override
        public boolean parse(Toml table) {
            if (super.parse(table)) {
                this.event = this.getParameterAsString("name");
                this.song = this.getParameterAsString("song");
                this.interval = this.getParameterAsInt("interval");
                this.start = this.getParameterAsInt("start");
                this.end = this.getParameterAsInt("end");
                return true;
            }
            return false;
        }

        public void resetTimer() {
            this.timer = 0;
        }

        public boolean tick() {
            ++this.timer;
            return !(this.timer > 0 && this.interval != 0 && this.timer % this.interval != 0 || this.timer < this.start || this.end > 0 && this.timer >= this.end);
        }

        @Generated
        public ChannelEventRunner getParent() {
            return this.parent;
        }

        @Generated
        public void setChannel(ChannelAPI channel) {
            this.channel = channel;
        }
    }
}

