/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.channel;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.client.TriggerContextClient;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.WrapperLink;
import mods.thecomputerizer.musictriggers.api.data.audio.AudioPool;
import mods.thecomputerizer.musictriggers.api.data.audio.AudioRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelData;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelElement;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelEventHandler;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelInfo;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelSync;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelSyncable;
import mods.thecomputerizer.musictriggers.api.data.jukebox.RecordElement;
import mods.thecomputerizer.musictriggers.api.data.log.LoggableAPI;
import mods.thecomputerizer.musictriggers.api.data.log.MTLogger;
import mods.thecomputerizer.musictriggers.api.data.nbt.NBTLoadable;
import mods.thecomputerizer.musictriggers.api.data.redirect.RedirectElement;
import mods.thecomputerizer.musictriggers.api.data.render.CardAPI;
import mods.thecomputerizer.musictriggers.api.data.render.ImageElement;
import mods.thecomputerizer.musictriggers.api.data.render.TitleElement;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerAPI;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerContext;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerHelper;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerSelector;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerCommand;
import mods.thecomputerizer.musictriggers.api.server.TriggerContextServer;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.PlayerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.BaseTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.CompoundTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.ListTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.TagHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;

public abstract class ChannelAPI
implements ChannelEventHandler,
ChannelSyncable,
LoggableAPI,
NBTLoadable {
    private final ChannelHelper helper;
    private final ChannelInfo info;
    private final ChannelData data;
    private final ChannelSync sync;
    private final TriggerSelector selector;
    private final String name;
    protected boolean enabled = true;
    private Map<String, TriggerCommand> commandTriggerCache;
    protected TriggerAPI.Link disabledBy;

    protected ChannelAPI(ChannelHelper helper, Toml table) {
        this.helper = helper;
        this.name = table.getName();
        this.info = new ChannelInfo(this, table);
        this.data = new ChannelData(this);
        this.sync = new ChannelSync(this);
        this.selector = new TriggerSelector(this, helper.isClient() ? new TriggerContextClient(this) : new TriggerContextServer(this));
        this.logInfo("Successfully registered", new Object[0]);
    }

    @Override
    public void activate() {
        this.handleActiveEvent(ChannelEventHandler::activate);
    }

    public boolean areTheseActive(Collection<TriggerAPI> triggers) {
        TriggerAPI trigger = this.getActiveTrigger();
        return Objects.nonNull(trigger) && trigger.matches(triggers);
    }

    private void cacheCommandTriggers() {
        HashMap<String, TriggerCommand> cache = new HashMap<String, TriggerCommand>();
        for (TriggerAPI trigger : this.data.getTriggers()) {
            String id;
            if (!(trigger instanceof TriggerCommand) || !TextHelper.isNotBlank((String)(id = trigger.getIdentifier())) || "not_set".equals(id)) continue;
            cache.put(id, (TriggerCommand)trigger);
        }
        this.commandTriggerCache = Collections.unmodifiableMap(cache);
    }

    public abstract boolean checkDeactivate(TriggerAPI var1, TriggerAPI var2);

    @Override
    public void close() {
        this.commandTriggerCache = null;
        this.data.close();
        this.sync.close();
        this.selector.close();
    }

    @Override
    public void deactivate() {
        TriggerAPI activeTrigger = this.getActiveTrigger();
        if (Objects.nonNull(activeTrigger)) {
            this.logDebug("Deactivated {}", activeTrigger);
        }
        this.handleActiveEvent(ChannelEventHandler::deactivate);
    }

    public void deactivateLink() {
        TriggerAPI trigger = this.getActiveTrigger();
        if (Objects.nonNull(trigger.getActiveLink())) {
            TriggerAPI.Link link = trigger.getActiveLink();
            link.setSnapshotInherit(this.getPlayingSongTime());
            link.unlink();
            trigger.setActiveLink(null);
        }
    }

    public void disable(TriggerAPI.Link link) {
        this.disabledBy = link;
        this.enabled = false;
    }

    public void enable() {
        this.enabled = true;
    }

    @Override
    public void encode(ByteBuf buf) {
        NetworkHelper.writeString((ByteBuf)buf, (String)this.getName());
    }

    public boolean equals(Object other) {
        if (other instanceof ChannelAPI) {
            ChannelAPI channel = (ChannelAPI)other;
            return this.isClientChannel() == channel.isClientChannel() && this.name.equals(channel.name);
        }
        return false;
    }

    void executeCommandTrigger(String id) {
        TriggerCommand trigger;
        if (Objects.isNull(this.commandTriggerCache)) {
            this.cacheCommandTriggers();
        }
        if (Objects.nonNull(trigger = this.commandTriggerCache.get(id))) {
            trigger.onCommandExecuted();
        }
    }

    public TriggerAPI getActiveTrigger() {
        return this.selector.getActiveTrigger();
    }

    public TriggerAPI getActiveNonFadingTrigger() {
        return this.selector.getActiveNonFadingTrigger();
    }

    public Set<String> getCommandIds() {
        if (Objects.isNull(this.commandTriggerCache)) {
            this.cacheCommandTriggers();
        }
        return this.commandTriggerCache.keySet();
    }

    public WrapperLink getCommandsLink() {
        return new WrapperLink(this.data.getCommands());
    }

    @Nullable
    public abstract String getFormattedSongTime();

    private String getLogPrefix() {
        return this.getLogType() + " | Channel";
    }

    public abstract String getLogType();

    public WrapperLink getMainLink() {
        ArrayList<ChannelElement> audio = new ArrayList<ChannelElement>();
        audio.add(this.data.getUniversals(AudioRef.class));
        audio.addAll(this.data.getAudio());
        ArrayList<ChannelElement> triggers = new ArrayList<ChannelElement>();
        triggers.add(this.data.getUniversals(TriggerAPI.class));
        triggers.addAll(this.data.getTriggers());
        return new WrapperLink(audio, triggers);
    }

    public Collection<TriggerAPI> getPlayableTriggers() {
        HashSet<TriggerAPI> triggers = new HashSet<TriggerAPI>();
        for (TriggerAPI trigger : this.data.getTriggers()) {
            TriggerAPI.State state = trigger.isSynced() ? this.getSelector().getContext().getSyncedState(trigger) : trigger.getState();
            if (!state.isPlayable()) continue;
            triggers.add(trigger);
        }
        return triggers;
    }

    public abstract AudioPlayer getPlayer();

    @Nullable
    public <P> PlayerAPI<P, ?> getPlayerEntity() {
        return this.selector.getContext().getPlayer();
    }

    @Nullable
    public abstract AudioPool getPlayingPool();

    @Nullable
    public abstract String getPlayingSongName();

    public abstract long getPlayingSongTime();

    public abstract long getPlayingSongTotalTime();

    public Set<String> getRecordLines() {
        HashSet<String> lines = new HashSet<String>();
        for (RecordElement record : this.data.getRecords()) {
            lines.add(record.getKey() + " = " + record.getValue());
        }
        return lines;
    }

    public WrapperLink getRecordsLink() {
        return new WrapperLink(this.data.getRecords());
    }

    public Set<String> getRedirectLines() {
        HashSet<String> lines = new HashSet<String>();
        for (RedirectElement redirect : this.data.getRedirects()) {
            lines.add(redirect.toString());
        }
        return lines;
    }

    public WrapperLink getRedirectLink() {
        return new WrapperLink(this.data.getRedirects());
    }

    public WrapperLink getRendersLink() {
        HashSet<ImageElement> images = new HashSet<ImageElement>();
        HashSet<TitleElement> titles = new HashSet<TitleElement>();
        for (CardAPI card : this.data.getCards()) {
            if (card instanceof ImageElement) {
                images.add((ImageElement)card);
                continue;
            }
            if (!(card instanceof TitleElement)) continue;
            titles.add((TitleElement)card);
        }
        return new WrapperLink(images, titles);
    }

    public void getSource(Map<String, Toml> map, String name, String path) {
        Toml toml = ChannelHelper.openToml("config/MusicTriggers/" + this.name + "/" + path, false, this);
        if (Objects.nonNull(toml)) {
            map.put(name, toml);
        }
    }

    public Map<String, Toml> getSourceMap() {
        HashMap<String, Toml> map = new HashMap<String, Toml>();
        this.getSource(map, "commands", this.info.getCommandsPath());
        this.getSource(map, "main", this.info.getMainPath());
        this.getSource(map, "renders", this.info.getRendersPath());
        return map;
    }

    public long getStartTime() {
        long startAt = 0L;
        if (Objects.nonNull(this.disabledBy)) {
            startAt = this.disabledBy.getSnapshotInherit();
            this.disabledBy.setSnapshotInherit(0L);
            this.disabledBy = null;
        } else {
            TriggerAPI.Link link;
            TriggerAPI trigger = this.getActiveTrigger();
            if (Objects.nonNull(trigger) && Objects.nonNull(link = trigger.getActiveLink())) {
                startAt = link.getSnapshotLink();
                link.setSnapshotLink(0L);
            }
        }
        return startAt;
    }

    protected void handleActiveEvent(Consumer<ChannelEventHandler> event) {
        this.data.getActiveEventHandlers().forEach(event);
    }

    protected void handlePlayableEvent(Consumer<ChannelEventHandler> event) {
        this.data.getPlayableEventHandlers().forEach(event);
    }

    @Override
    public boolean hasDataToSave() {
        for (TriggerAPI trigger : this.data.getTriggerEventMap().keySet()) {
            if (!trigger.hasDataToSave()) continue;
            return true;
        }
        return false;
    }

    public boolean implyTrigger(String name) {
        int index = name.indexOf(45);
        String id = index != -1 ? name.substring(index + 1) : "implied";
        name = index != -1 ? name.substring(0, index) : name;
        return this.data.implyTrigger(name, id);
    }

    public abstract boolean isClientChannel();

    public abstract boolean isValid();

    public abstract String loadLocalTrack(AudioRef var1, String var2);

    public abstract String loadRemoteTrack(AudioRef var1, String var2);

    public void loadTracks(boolean loadResources) {
        this.data.loadTracks(loadResources);
    }

    @Override
    public void logDebug(String msg, Object ... args) {
        MTLogger.logDebug(this.getLogPrefix(), this.getName(), msg, args);
    }

    @Override
    public void logError(String msg, Object ... args) {
        MTLogger.logError(this.getLogPrefix(), this.getName(), msg, args);
    }

    @Override
    public void logFatal(String msg, Object ... args) {
        MTLogger.logFatal(this.getLogPrefix(), this.getName(), msg, args);
    }

    @Override
    public void logInfo(String msg, Object ... args) {
        MTLogger.logInfo(this.getLogPrefix(), this.getName(), msg, args);
    }

    @Override
    public void logTrace(String msg, Object ... args) {
        MTLogger.logTrace("Channel", this.getName(), msg, args);
    }

    @Override
    public void logWarn(String msg, Object ... args) {
        MTLogger.logWarn(this.getLogPrefix(), this.getName(), msg, args);
    }

    @Override
    public void onConnected(CompoundTagAPI<?> worldData) {
        if (worldData.contains("triggers")) {
            for (BaseTagAPI based : worldData.getListTag("triggers")) {
                CompoundTagAPI triggerTag = based.asCompoundTag();
                TriggerAPI trigger = TriggerHelper.decodeTrigger(this, triggerTag);
                trigger.onConnected(triggerTag);
            }
        }
    }

    @Override
    public void onLoaded(CompoundTagAPI<?> globalData) {
    }

    public abstract void onResourcesLoaded();

    public abstract void onTrackStart(AudioTrack var1);

    public abstract void onTrackStop(AudioTrackEndReason var1);

    public void parseData() {
        this.data.parse();
    }

    @Override
    public void play(boolean unpaused) {
        this.handleActiveEvent(handler -> handler.play(unpaused));
    }

    @Override
    public void playable() {
    }

    @Override
    public void playing(boolean unpaused) {
        this.handleActiveEvent(handler -> handler.playing(unpaused));
    }

    @Override
    public void queue() {
        this.handleActiveEvent(ChannelEventHandler::queue);
    }

    @Override
    public void saveGlobalTo(CompoundTagAPI<?> globalData) {
    }

    @Override
    public void saveWorldTo(CompoundTagAPI<?> worldData) {
        ListTagAPI triggersTag = TagHelper.makeListTag();
        for (TriggerAPI trigger : this.data.getTriggerEventMap().keySet()) {
            if (!trigger.hasDataToSave()) continue;
            CompoundTagAPI triggerTag = TagHelper.makeCompoundTag();
            trigger.saveWorldTo(triggerTag);
            triggersTag.addTag((BaseTagAPI)triggerTag);
        }
        worldData.putTag("triggers", (BaseTagAPI)triggersTag);
    }

    public abstract void seek(long var1);

    public abstract void setCategoryVolume(float var1);

    public abstract void setMasterVolume(float var1);

    public abstract void setTrackVolume(float var1);

    public abstract boolean shouldBlockMusicTicker();

    public boolean showDebugSongInfo() {
        return ChannelHelper.getDebugBool("show_channel_info") && ChannelHelper.getDebugBool("show_song_info");
    }

    public boolean showDebugTriggerInfo() {
        return ChannelHelper.getDebugBool("show_channel_info") && ChannelHelper.getDebugBool("show_trigger_info");
    }

    @Override
    public void stop() {
        this.handleActiveEvent(ChannelEventHandler::stop);
    }

    @Override
    public void stopped() {
        this.logInfo("Stopped track", new Object[0]);
        this.handleActiveEvent(ChannelEventHandler::stopped);
    }

    public boolean tick(boolean jukebox, boolean unpaused) {
        this.tickActive(unpaused);
        this.tickPlayable(unpaused);
        return unpaused;
    }

    @Override
    public void tickActive(boolean unpaused) {
        this.handleActiveEvent(handler -> handler.tickActive(unpaused));
    }

    @Override
    public void tickPlayable(boolean unpaused) {
        this.handlePlayableEvent(handler -> handler.tickPlayable(unpaused));
    }

    public void tickSlow(boolean unpaused) {
        this.selector.select(unpaused);
        if (Objects.nonNull(this.commandTriggerCache)) {
            this.commandTriggerCache.values().forEach(TriggerCommand::decrement);
        }
    }

    public String toString() {
        return this.getLogPrefix() + "[" + this.name + "]";
    }

    @Override
    public void unplayable() {
    }

    public void updateSyncedState(Map<TriggerAPI, TriggerAPI.State> stateMap) {
        TriggerContext ctx = this.selector.getContext();
        stateMap.forEach(ctx::updateSyncedState);
    }

    @Generated
    public ChannelHelper getHelper() {
        return this.helper;
    }

    @Generated
    public ChannelInfo getInfo() {
        return this.info;
    }

    @Generated
    public ChannelData getData() {
        return this.data;
    }

    @Generated
    public ChannelSync getSync() {
        return this.sync;
    }

    @Generated
    public TriggerSelector getSelector() {
        return this.selector;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public Map<String, TriggerCommand> getCommandTriggerCache() {
        return this.commandTriggerCache;
    }

    @Generated
    public TriggerAPI.Link getDisabledBy() {
        return this.disabledBy;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

