/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.audio;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.client.gui.MTScreenInfo;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.DataLink;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.ParameterLink;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.WrapperLink;
import mods.thecomputerizer.musictriggers.api.data.MTDataRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelElement;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelSyncable;
import mods.thecomputerizer.musictriggers.api.data.parameter.ParameterWrapper;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerAPI;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerHelper;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioItem;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;
import mods.thecomputerizer.theimpossiblelibrary.api.util.RandomHelper;

public class AudioRef
extends ChannelElement
implements ChannelSyncable,
RandomHelper.WeightedEntry {
    private final List<TriggerAPI> triggers = new ArrayList<TriggerAPI>();
    protected final List<Loop> loops = new ArrayList<Loop>();
    private InterruptHandler interruptHandler;
    protected long inheritedTime;
    protected boolean file;
    protected String location;
    protected boolean loaded;
    protected boolean loading;
    protected boolean queued;
    protected boolean looping;

    public static AudioRef addToGui(MTScreenInfo info, String name, String location, boolean file) {
        AudioRef ref = new AudioRef(info.getChannel(), name);
        ref.location = location;
        ref.file = file;
        return ref;
    }

    public AudioRef(ChannelAPI channel, String name) {
        super(channel, name);
    }

    @Override
    public void close() {
        this.triggers.clear();
    }

    @Override
    public void deactivate() {
        this.queued = false;
    }

    @Override
    public void encode(ByteBuf buf) {
        NetworkHelper.writeString((ByteBuf)buf, (String)this.name);
        NetworkHelper.writeList((ByteBuf)buf, this.triggers, trigger -> trigger.encode(buf));
    }

    public boolean equals(Object other) {
        if (other instanceof AudioRef) {
            AudioRef ref = (AudioRef)other;
            return this.channel.equals(ref.channel) && this.name.equals(ref.name) && TriggerHelper.matchesAll(this.triggers, ref.triggers);
        }
        return false;
    }

    @Override
    public Collection<DataLink> getChildWrappers(MTScreenInfo parent) {
        if (Objects.isNull(this.interruptHandler)) {
            this.interruptHandler = new InterruptHandler(this.channel, Toml.getEmpty());
        }
        ParameterLink interrupt = this.interruptHandler.getLink();
        ((DataLink)interrupt).setType(parent.next("interrupt_handler", interrupt));
        WrapperLink loops = new WrapperLink(this.loops);
        loops.setType(parent.next("loops", loops));
        return Arrays.asList(interrupt, loops);
    }

    public int getPlayState() {
        return this.getParameterAsInt("play_once");
    }

    @Override
    public MTDataRef.TableRef getReferenceData() {
        return MTDataRef.AUDIO;
    }

    public double getSpeed() {
        return this.getParameterAsDouble("speed");
    }

    @Override
    protected String getSubTypeName() {
        return "Audio";
    }

    public Class<? extends ChannelElement> getTypeClass() {
        return AudioRef.class;
    }

    public float getVolume(boolean unpaused) {
        return this.getParameterAsFloat(unpaused ? "volume" : "volume_when_paused");
    }

    public int getWeight() {
        return this.getParameterAsInt("chance");
    }

    public boolean hasPlayedEnough(int count) {
        return count >= this.getParameterAsInt("play_x");
    }

    @Override
    public boolean isResource() {
        return false;
    }

    public void loadLocal(String location) {
    }

    public void loadRemote(String location) {
    }

    @Override
    public boolean parse(Toml table) {
        if (super.parse(table) && this.parseTriggers(this.channel, this.triggers)) {
            this.logDebug("Successfully parsed with triggers {}", this.triggers);
            this.interruptHandler = table.hasTable("interrupt_handler") ? new InterruptHandler(this.channel, table.getTable("interrupt_handler")) : new InterruptHandler(this.channel, Toml.getEmpty());
            if (table.hasTable("loop")) {
                for (Toml loopTable : table.getTableArray("loop")) {
                    Loop loop = new Loop(this.channel, loopTable);
                    if (!loop.valid) continue;
                    this.loops.add(loop);
                }
                this.logInfo("Registered loops: {}", this.loops);
            }
            return true;
        }
        this.logError("Failed to parse", new Object[0]);
        return false;
    }

    public void queryInterrupt(@Nullable TriggerAPI next, AudioPlayer player) {
    }

    public void removeTrigger(String name) {
        this.triggers.removeIf(trigger -> trigger.getNameWithID().equals(name));
    }

    public void setFade(int fade) {
    }

    public void setItem(AudioItem item) {
        this.loading = false;
        this.loaded = true;
    }

    public void setLoading() {
        this.loaded = false;
        this.loading = true;
    }

    public void setWeight(int i) {
    }

    public boolean shouldSavePosition() {
        return this.getParameterAsBoolean("resume_on_play");
    }

    public void start(TriggerAPI trigger, boolean unpaused) {
    }

    @Override
    protected Toml toTomlExtra(Toml toml) {
        toml = super.toTomlExtra(toml);
        if (Objects.nonNull(this.interruptHandler)) {
            toml.addTable("interrupt_handler", this.interruptHandler.toToml());
        }
        for (Loop loop : this.loops) {
            toml.addTable("loop", loop.toToml());
        }
        return toml;
    }

    @Generated
    public List<TriggerAPI> getTriggers() {
        return this.triggers;
    }

    @Generated
    public List<Loop> getLoops() {
        return this.loops;
    }

    @Generated
    public InterruptHandler getInterruptHandler() {
        return this.interruptHandler;
    }

    @Generated
    public long getInheritedTime() {
        return this.inheritedTime;
    }

    @Generated
    public boolean isFile() {
        return this.file;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public boolean isLoaded() {
        return this.loaded;
    }

    @Generated
    public boolean isLoading() {
        return this.loading;
    }

    @Generated
    public boolean isQueued() {
        return this.queued;
    }

    @Generated
    public boolean isLooping() {
        return this.looping;
    }

    public static class InterruptHandler
    extends ChannelElement {
        private final int priority;
        private final List<TriggerAPI> triggers;

        public InterruptHandler(ChannelAPI channel, Toml table) {
            super(channel, "interrupt_handler");
            int priority;
            ArrayList<TriggerAPI> triggers = new ArrayList<TriggerAPI>();
            int n = priority = ChannelHelper.getDebugBool("reverse_priority") ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            if (this.parse(table) && this.parseTriggers(this.channel, triggers, "trigger_whitelist")) {
                priority = this.getParameterAsInt("priority");
            }
            this.priority = priority;
            this.triggers = triggers;
        }

        public boolean isInterrputedBy(@Nullable TriggerAPI trigger) {
            if (Objects.isNull(trigger)) {
                return false;
            }
            if (this.triggers.isEmpty()) {
                return true;
            }
            int priority = trigger.getParameterAsInt("priority");
            return this.triggers.isEmpty() || (!ChannelHelper.getDebugBool("reverse_priority") ? priority >= this.priority : priority <= this.priority) || trigger.isContained(this.triggers);
        }

        @Override
        public boolean isResource() {
            return false;
        }

        @Override
        public void close() {
            this.triggers.clear();
        }

        @Override
        public MTDataRef.TableRef getReferenceData() {
            return MTDataRef.INTERRUPT_HANDLER;
        }

        public Class<? extends ChannelElement> getTypeClass() {
            return AudioRef.class;
        }

        @Override
        protected String getSubTypeName() {
            return "Interrupt_Handler";
        }
    }

    public static class Loop
    extends ChannelElement {
        final boolean valid;
        final long from;
        final long to;
        final int total;
        int count;

        public static Loop addToGui(MTScreenInfo info) {
            return new Loop(info.getChannel(), Toml.getEmpty());
        }

        protected Loop(ChannelAPI channel, Toml table) {
            this(channel, table, false);
        }

        Loop(ChannelAPI channel, Toml table, boolean silent) {
            super(channel, "loop_point");
            boolean valid = this.parse(table);
            this.from = this.getParameterAsLong("from");
            this.to = this.getParameterAsLong("to");
            this.total = this.getParameterAsInt("loop_count");
            if (this.from == this.to) {
                if (!silent) {
                    this.logError("Cannot define loops with equal from and to values! {} = {}", this.from, this.to);
                }
                valid = false;
            }
            this.valid = valid;
        }

        @Override
        public void close() {
        }

        @Override
        public String getName() {
            return String.format("(%1$d->%2$d)x%3$d", this.from, this.to, this.total);
        }

        @Override
        public MTDataRef.TableRef getReferenceData() {
            return MTDataRef.LOOP;
        }

        @Override
        protected String getSubTypeName() {
            return "Loop";
        }

        @Override
        public Class<? extends ParameterWrapper> getTypeClass() {
            return Loop.class;
        }

        @Override
        public boolean isResource() {
            return false;
        }

        public void reset() {
            this.count = 0;
        }

        public boolean run() {
            AudioTrack track = this.channel.getPlayer().getPlayingTrack();
            if (Objects.nonNull(track) && (this.total <= 0 || this.count < this.total) && this.channel.getPlayingSongTime() >= this.from) {
                this.logInfo("Running", new Object[0]);
                track.setPosition(this.to);
                ++this.count;
                return true;
            }
            return false;
        }

        @Generated
        public boolean isValid() {
            return this.valid;
        }

        @Generated
        public long getFrom() {
            return this.from;
        }

        @Generated
        public long getTo() {
            return this.to;
        }

        @Generated
        public int getTotal() {
            return this.total;
        }

        @Generated
        public int getCount() {
            return this.count;
        }
    }
}

