/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.audio;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import mods.thecomputerizer.musictriggers.api.client.audio.AudioContainer;
import mods.thecomputerizer.musictriggers.api.data.audio.AudioPool;
import mods.thecomputerizer.musictriggers.api.data.audio.AudioRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelEventHandler;
import mods.thecomputerizer.musictriggers.api.data.parameter.UniversalParameters;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerAPI;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;

public class AudioHelper {
    public static AudioRef decodeAudio(ChannelAPI channel, ByteBuf buf) {
        String name = NetworkHelper.readString((ByteBuf)buf);
        if ("pool".equals(name)) {
            Set audio = NetworkHelper.readSet((ByteBuf)buf, () -> AudioHelper.decodeAudio(channel, buf));
            for (Collection<ChannelEventHandler> handlers : channel.getData().getTriggerEventMap().values()) {
                for (ChannelEventHandler handler : handlers) {
                    AudioPool pool;
                    if (!(handler instanceof AudioPool) || !(pool = (AudioPool)handler).equivalent(channel, audio)) continue;
                    return pool;
                }
            }
            return null;
        }
        return AudioHelper.decodeAudioElement(channel, buf, name);
    }

    public static AudioRef decodeAudioElement(ChannelAPI channel, ByteBuf buf, String name) {
        List triggers = NetworkHelper.readList((ByteBuf)buf, () -> TriggerHelper.decodeTrigger(channel, buf));
        return AudioHelper.findAudio(channel, name, triggers);
    }

    public static AudioRef findAudio(ChannelAPI channel, String name, Collection<TriggerAPI> triggers) {
        for (AudioRef audio : channel.getData().getAudio()) {
            if (!audio.getName().equals(name) || !TriggerHelper.matchesAll(audio.getTriggers(), triggers)) continue;
            return audio;
        }
        return null;
    }

    public static void parseAudio(ChannelAPI channel, Collection<AudioRef> audio, @Nullable Toml table) {
        if (Objects.isNull(table)) {
            return;
        }
        UniversalParameters universal = channel.getData().getUniversals(AudioRef.class);
        for (Toml songsTable : table.getAllTables()) {
            String name = songsTable.getName();
            if (name.equals("universal")) {
                if (Objects.isNull(universal) || !universal.parse(songsTable)) {
                    channel.logError("Failed to parse universal songs", new Object[0]);
                    continue;
                }
                channel.logInfo("Intialized universal songs data", new Object[0]);
                continue;
            }
            AudioRef ref = channel.isClientChannel() ? new AudioContainer(channel, name) : new AudioRef(channel, name);
            if (!ref.parse(songsTable)) continue;
            audio.add(ref);
        }
    }
}

