/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.data.global.Debug;
import mods.thecomputerizer.musictriggers.api.data.log.LoggableAPI;
import mods.thecomputerizer.musictriggers.api.data.parameter.Parameter;
import mods.thecomputerizer.musictriggers.api.data.parameter.ParameterHelper;
import mods.thecomputerizer.musictriggers.api.data.parameter.ParameterList;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ArrayHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.io.FileHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.TomlWritingException;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Sorting;

public final class MTDataRef {
    public static final TableRef EVENT_RUNNER = new TableRef("event", Arrays.asList(MTDataRef.buildParameter("end", Integer.MAX_VALUE), MTDataRef.buildParameter("interval", 0), MTDataRef.buildString("name", "activate", "deactivate", "play", "playable", "playing", "queue", "stop", "stopped", "tick_active", "tick_playable", "unplayable"), MTDataRef.buildParameter("song", "_"), MTDataRef.buildParameter("start", 0)), new TableRef[0]);
    public static final TableRef CHANNEL_INFO = new TableRef("channel", Arrays.asList(MTDataRef.buildParameter("commands", "commands"), MTDataRef.buildParameter("explicitly_overrides", false), MTDataRef.buildParameter("has_paused_music", false), MTDataRef.buildParameter("jukebox", "jukebox"), MTDataRef.buildParameter("local_folder", "config/MusicTriggers/songs"), MTDataRef.buildParameter("main", "main"), MTDataRef.buildParameter("overrides_music", true), MTDataRef.buildParameter("paused_by_jukebox", true), MTDataRef.buildParameter("pauses_overrides", false), MTDataRef.buildParameter("redirect", "redirect"), MTDataRef.buildParameter("renders", "renders"), MTDataRef.buildParameter("sound_category", "music")), new TableRef[0]);
    public static final TableRef COMMAND = new TableRef("command", Arrays.asList(MTDataRef.buildParameter("literal", "literally"), MTDataRef.buildParameter("triggers", new ArrayList())), new TableRef[]{EVENT_RUNNER});
    public static final TableRef DEBUG = new TableRef("debug", Arrays.asList(MTDataRef.buildParameter("allow_timestamps", false), MTDataRef.buildParameter("block_sound_effects", false), MTDataRef.buildParameter("blocked_sound_categories", Collections.singletonList("minecraft;music")), MTDataRef.buildParameter("client_only", false), MTDataRef.buildParameter("enable_debug_info", false), MTDataRef.buildParameter("enable_discs", true), MTDataRef.buildInt("encoding_quality", 10, ArrayHelper.intRange((int)1, (int)10)), MTDataRef.buildParameter("gui_fuzz", true), MTDataRef.buildParameter("independent_audio_pools", true), MTDataRef.buildParameter("interrupted_sound_categories", Collections.singletonList("music")), MTDataRef.buildParameter("pause_unless_focused", true), MTDataRef.buildParameter("play_normal_music", false), MTDataRef.buildString("resampling_quality", "HIGH", "LOW", "MEDIUM"), MTDataRef.buildParameter("reverse_priority", false), MTDataRef.buildParameter("show_channel_info", true), MTDataRef.buildParameter("show_position_info", true), MTDataRef.buildParameter("show_song_info", true), MTDataRef.buildParameter("show_status_info", true), MTDataRef.buildParameter("show_target_info", true), MTDataRef.buildParameter("show_trigger_info", true), MTDataRef.buildParameter("slow_tick_factor", Float.valueOf(5.0f)), MTDataRef.buildParameter("tick_rate", 20), MTDataRef.buildParameter("write_default_values", Arrays.asList("channel", "from", "image", "interrupt_handler", "main", "songs", "title", "toggle", "triggers", "universal_audio", "universal_triggers"))), new TableRef[0]);
    public static final TableRef FROM = new TableRef("from", Arrays.asList(MTDataRef.buildParameter("channel", "not_set"), MTDataRef.buildParameter("triggers", new ArrayList())), new TableRef[]{EVENT_RUNNER});
    public static final TableRef INTERRUPT_HANDLER = new TableRef("interrupt_handler", Arrays.asList(MTDataRef.buildParameter("priority", Integer.MAX_VALUE), MTDataRef.buildParameter("trigger_whitelist", new ArrayList())), new TableRef[0]);
    public static final TableRef LINK = new TableRef("link", Arrays.asList(MTDataRef.buildParameter("inherit_time", true), MTDataRef.buildParameter("linked_triggers", new ArrayList()), MTDataRef.buildParameter("required_triggers", new ArrayList()), MTDataRef.buildParameter("resume_after_link", true), MTDataRef.buildParameter("target_channel", "not_set")), new TableRef[0]);
    public static final TableRef LOOP = new TableRef("loop", Arrays.asList(MTDataRef.buildParameter("from", 0), MTDataRef.buildParameter("loop_count", 0), MTDataRef.buildParameter("to", 0)), new TableRef[]{EVENT_RUNNER});
    public static final TableRef TO = new TableRef("to", Arrays.asList(MTDataRef.buildParameter("channel", "not_set"), MTDataRef.buildString("condition", "switch", "false", "true"), MTDataRef.buildParameter("triggers", new ArrayList())), new TableRef[]{EVENT_RUNNER});
    public static final TableRef UNIVERSAL_AUDIO = new TableRef("universal_audio", Arrays.asList(MTDataRef.buildParameter("pitch", 1.0), MTDataRef.buildInt("play_once", 0, ArrayHelper.intRange((int)0, (int)5)), MTDataRef.buildParameter("speed", 1.0), MTDataRef.buildParameter("volume", Float.valueOf(1.0f))), new TableRef[]{EVENT_RUNNER, INTERRUPT_HANDLER});
    public static final TableRef UNIVERSAL_TRIGGERS = new TableRef("universal_triggers", Arrays.asList(MTDataRef.buildParameter("active_cooldown", "0"), MTDataRef.buildParameter("fade_in", "0"), MTDataRef.buildParameter("fade_out", "0"), MTDataRef.buildParameter("persistence", "0"), MTDataRef.buildParameter("ticks_before_active", "0"), MTDataRef.buildParameter("ticks_before_audio", "0"), MTDataRef.buildParameter("ticks_between_audio", "0")), new TableRef[0]);
    public static final TableRef AUDIO = new TableRef("audio", Arrays.asList(MTDataRef.buildParameter("chance", 100), MTDataRef.buildParameter("location", "_"), MTDataRef.buildParameter("pitch", 1.0), MTDataRef.buildInt("play_once", 0, ArrayHelper.intRange((int)0, (int)5)), MTDataRef.buildParameter("play_x", 1), MTDataRef.buildParameter("resume_on_play", false), MTDataRef.buildParameter("rotation_speed", 0.0), MTDataRef.buildParameter("speed", 1.0), MTDataRef.buildParameter("start_at", 0), MTDataRef.buildParameter("triggers", new ArrayList()), MTDataRef.buildParameter("volume", Float.valueOf(1.0f)), MTDataRef.buildParameter("volume_when_paused", Float.valueOf(0.25f))), new TableRef[]{INTERRUPT_HANDLER, LOOP});
    public static final TableRef IMAGE_CARD = MTDataRef.buildRenderCard("image", MTDataRef.buildParameter("animated", false), MTDataRef.buildParameter("fps", 20), MTDataRef.buildParameter("name", "_"));
    public static final TableRef TITLE_CARD = MTDataRef.buildRenderCard("title", MTDataRef.buildString("subtitle_color", "white", MTDataRef.colors()), MTDataRef.buildParameter("subtitle_scale", Float.valueOf(0.75f)), MTDataRef.buildParameter("subtitles", new ArrayList()), MTDataRef.buildString("title_color", "red", MTDataRef.colors()), MTDataRef.buildParameter("titles", new ArrayList()));
    public static final TableRef TOGGLE = new TableRef("toggle", Collections.singleton(MTDataRef.buildParameter("play_once", false)), new TableRef[]{FROM, TO});
    public static final Set<TableRef> TRIGGERS = MTDataRef.buildTables(MTDataRef.buildTrigger("acidrain", false, new ParameterRef[0]), MTDataRef.buildTrigger("advancement", true, MTDataRef.buildString("display_matcher", "exact", MTDataRef.matcher()), MTDataRef.buildParameter("display_name", Collections.singletonList("any")), MTDataRef.buildString("resource_matcher", "partial", MTDataRef.matcher()), MTDataRef.buildParameter("resource_name", Collections.singletonList("any"))), MTDataRef.buildTrigger("adventure", false, new ParameterRef[0]), MTDataRef.buildTrigger("biome", true, MTDataRef.buildParameter("biome_rainfall", Float.valueOf(-3.4028235E38f)), MTDataRef.buildParameter("biome_tag", Collections.singletonList("any")), MTDataRef.buildParameter("biome_tag_matcher", "exact"), MTDataRef.buildParameter("biome_temperature", Float.valueOf(-3.4028235E38f)), MTDataRef.buildString("display_matcher", "exact", MTDataRef.matcher()), MTDataRef.buildParameter("display_name", Collections.singletonList("any")), MTDataRef.buildString("rain_type", "any", "none", "rain", "snow"), MTDataRef.buildParameter("rainfall_greater_than", true), MTDataRef.buildString("resource_matcher", "partial", MTDataRef.matcher()), MTDataRef.buildParameter("resource_name", Collections.singletonList("any")), MTDataRef.buildParameter("temperature_greater_than", true)), MTDataRef.buildTrigger("blizzard", false, new ParameterRef[0]), MTDataRef.buildTrigger("blockentity", true, MTDataRef.buildParameter("detection_range", 16), MTDataRef.buildParameter("detection_y_ratio", Float.valueOf(0.5f)), MTDataRef.buildString("display_matcher", "exact", MTDataRef.matcher()), MTDataRef.buildParameter("display_name", Collections.singletonList("any")), MTDataRef.buildString("resource_matcher", "partial", MTDataRef.matcher()), MTDataRef.buildParameter("resource_name", Collections.singletonList("any"))), MTDataRef.buildTrigger("bloodmoon", false, new ParameterRef[0]), MTDataRef.buildTrigger("cloudy", false, new ParameterRef[0]), MTDataRef.buildTrigger("command", true, new ParameterRef[0]), MTDataRef.buildTrigger("creative", false, new ParameterRef[0]), MTDataRef.buildTrigger("dead", false, new ParameterRef[0]), MTDataRef.buildTrigger("difficulty", true, MTDataRef.buildInt("level", 0, ArrayHelper.intRange((int)0, (int)4))), MTDataRef.buildTrigger("dimension", true, MTDataRef.buildString("display_matcher", "exact", MTDataRef.matcher()), MTDataRef.buildParameter("display_name", Collections.singletonList("any")), MTDataRef.buildString("resource_matcher", "partial", MTDataRef.matcher()), MTDataRef.buildParameter("resource_name", Collections.singletonList("any"))), MTDataRef.buildTrigger("drowning", false, MTDataRef.buildParameter("level", 100)), MTDataRef.buildTrigger("effect", true, MTDataRef.buildString("display_matcher", "exact", MTDataRef.matcher()), MTDataRef.buildParameter("display_name", Collections.singletonList("any")), MTDataRef.buildString("resource_matcher", "partial", MTDataRef.matcher()), MTDataRef.buildParameter("resource_name", Collections.singletonList("any"))), MTDataRef.buildTrigger("elytra", false, new ParameterRef[0]), MTDataRef.buildTrigger("fishing", false, new ParameterRef[0]), MTDataRef.buildTrigger("gamestage", true, MTDataRef.buildString("display_matcher", "exact", MTDataRef.matcher()), MTDataRef.buildParameter("display_name", Collections.singletonList("any")), MTDataRef.buildParameter("is_whitelist", true), MTDataRef.buildString("resource_matcher", "partial", MTDataRef.matcher()), MTDataRef.buildParameter("resource_name", Collections.singletonList("any"))), MTDataRef.buildTrigger("generic", false, new ParameterRef[0]), MTDataRef.buildTrigger("gui", true, MTDataRef.buildString("display_matcher", "exact", MTDataRef.matcher()), MTDataRef.buildParameter("display_name", Collections.singletonList("any")), MTDataRef.buildString("resource_matcher", "partial", MTDataRef.matcher()), MTDataRef.buildParameter("resource_name", Collections.singletonList("any"))), MTDataRef.buildTrigger("harvestmoon", false, new ParameterRef[0]), MTDataRef.buildTrigger("height", true, MTDataRef.buildParameter("check_above_level", false), MTDataRef.buildParameter("check_for_sky", true), MTDataRef.buildParameter("level", 0)), MTDataRef.buildTrigger("home", false, MTDataRef.buildParameter("detection_range", 16), MTDataRef.buildParameter("detection_y_ratio", Float.valueOf(0.5f))), MTDataRef.buildTrigger("huricane", false, MTDataRef.buildParameter("detection_range", 16)), MTDataRef.buildTrigger("inventory", true, MTDataRef.buildParameter("items", Collections.singletonList("empty")), MTDataRef.buildParameter("slots", Collections.singletonList("any"))), MTDataRef.buildTrigger("light", true, MTDataRef.buildInt("level", 7, ArrayHelper.intRange((int)0, (int)15)), MTDataRef.buildParameter("light_type", "any")), MTDataRef.buildTrigger("lightrain", false, new ParameterRef[0]), MTDataRef.buildTrigger("loading", false, new ParameterRef[0]), MTDataRef.buildTrigger("lowhp", false, MTDataRef.buildParameter("max_health_percentage", Float.valueOf(30.0f)), MTDataRef.buildParameter("min_health_percentage", Float.valueOf(0.0f))), MTDataRef.buildTrigger("menu", false, new ParameterRef[0]), MTDataRef.buildTrigger("mob", true, MTDataRef.buildParameter("champion", Collections.singletonList("any")), MTDataRef.buildParameter("detection_range", 16), MTDataRef.buildParameter("detection_y_ratio", Float.valueOf(0.5f)), MTDataRef.buildString("display_matcher", "exact", MTDataRef.matcher()), MTDataRef.buildParameter("display_name", Collections.singletonList("any")), MTDataRef.buildParameter("horde_health_percentage", Float.valueOf(50.0f)), MTDataRef.buildParameter("horde_targeting_percentage", Float.valueOf(50.0f)), MTDataRef.buildParameter("infernal", Collections.singletonList("any")), MTDataRef.buildParameter("max_entities", Integer.MAX_VALUE), MTDataRef.buildParameter("max_health", Float.valueOf(100.0f)), MTDataRef.buildParameter("min_entities", 1), MTDataRef.buildParameter("min_health", Float.valueOf(0.0f)), MTDataRef.buildParameter("mob_nbt", Collections.singletonList("any")), MTDataRef.buildParameter("mob_targeting", true), MTDataRef.buildString("resource_matcher", "partial", MTDataRef.matcher()), MTDataRef.buildParameter("resource_name", Collections.singletonList("any")), MTDataRef.buildParameter("target_any_player", true), MTDataRef.buildParameter("victory_id", "not_set"), MTDataRef.buildParameter("victory_percentage", Float.valueOf(100.0f))), MTDataRef.buildTrigger("moon", true, MTDataRef.buildString("display_matcher", "exact", MTDataRef.matcher()), MTDataRef.buildParameter("display_name", Collections.singletonList("any")), MTDataRef.buildString("resource_matcher", "partial", MTDataRef.matcher()), MTDataRef.buildParameter("resource_name", Collections.singletonList("any"))), MTDataRef.buildTrigger("pet", false, MTDataRef.buildParameter("detection_range", 16), MTDataRef.buildParameter("detection_y_ratio", Float.valueOf(0.5f))), MTDataRef.buildTrigger("pvp", true, new ParameterRef[0]), MTDataRef.buildTrigger("raid", true, MTDataRef.buildParameter("raid_status", Collections.singletonList("any")), MTDataRef.buildInt("wave", 0, ArrayHelper.intRange((int)0, (int)8))), MTDataRef.buildTrigger("raining", false, new ParameterRef[0]), MTDataRef.buildTrigger("rainintensity", true, MTDataRef.buildParameter("level", Float.valueOf(50.0f))), MTDataRef.buildTrigger("riding", true, MTDataRef.buildString("display_matcher", "exact", MTDataRef.matcher()), MTDataRef.buildParameter("display_name", Collections.singletonList("any")), MTDataRef.buildString("resource_matcher", "partial", MTDataRef.matcher()), MTDataRef.buildParameter("resource_name", Collections.singletonList("any"))), MTDataRef.buildTrigger("sandstorm", false, MTDataRef.buildParameter("detection_range", 16)), MTDataRef.buildTrigger("season", true, MTDataRef.buildInt("season", 0, ArrayHelper.intRange((int)0, (int)3))), MTDataRef.buildTrigger("snowing", false, new ParameterRef[0]), MTDataRef.buildTrigger("spectator", false, new ParameterRef[0]), MTDataRef.buildTrigger("starshower", false, new ParameterRef[0]), MTDataRef.buildTrigger("statistic", true, MTDataRef.buildString("display_matcher", "exact", MTDataRef.matcher()), MTDataRef.buildParameter("display_name", Collections.singletonList("any")), MTDataRef.buildParameter("level", 0), MTDataRef.buildString("resource_matcher", "partial", MTDataRef.matcher()), MTDataRef.buildParameter("resource_name", Collections.singletonList("any"))), MTDataRef.buildTrigger("storming", false, new ParameterRef[0]), MTDataRef.buildTrigger("structure", true, MTDataRef.buildString("display_matcher", "exact", MTDataRef.matcher()), MTDataRef.buildParameter("display_name", Collections.singletonList("any")), MTDataRef.buildString("resource_matcher", "partial", MTDataRef.matcher()), MTDataRef.buildParameter("resource_name", Collections.singletonList("any"))), MTDataRef.buildTrigger("time", true, MTDataRef.buildParameter("end_hour", Float.valueOf(0.0f)), MTDataRef.buildParameter("highest_day_number", Integer.MAX_VALUE), MTDataRef.buildParameter("lowest_day_number", 0), MTDataRef.buildInt("moon_phase", 0, ArrayHelper.intRange((int)0, (int)8)), MTDataRef.buildParameter("start_hour", Float.valueOf(0.0f)), MTDataRef.buildParameter("time_bundle", "any")), MTDataRef.buildTrigger("tornado", true, MTDataRef.buildParameter("detection_range", 16), MTDataRef.buildInt("level", 0, ArrayHelper.intRange((int)0, (int)5))), MTDataRef.buildTrigger("underwater", false, new ParameterRef[0]), MTDataRef.buildTrigger("victory", true, MTDataRef.buildParameter("victory_timeout", 20)), MTDataRef.buildTrigger("zones", true, MTDataRef.buildParameter("zone_max_x", Integer.MAX_VALUE), MTDataRef.buildParameter("zone_max_y", Integer.MAX_VALUE), MTDataRef.buildParameter("zone_max_z", Integer.MAX_VALUE), MTDataRef.buildParameter("zone_min_x", Integer.MIN_VALUE), MTDataRef.buildParameter("zone_min_y", Integer.MIN_VALUE), MTDataRef.buildParameter("zone_min_z", Integer.MIN_VALUE)), UNIVERSAL_TRIGGERS);
    public static final TableRef COMMANDS = new TableRef("commands", new TableRef[]{COMMAND});
    public static final TableRef GLOBAL = new TableRef("global", Collections.singleton(MTDataRef.buildParameter("toggles_path", "toggles")), new TableRef[]{new TableRef("channels", new TableRef[]{CHANNEL_INFO}), DEBUG});
    public static final TableRef MAIN = new TableRef("main", new TableRef[]{new TableRef("songs", new TableRef[]{AUDIO, UNIVERSAL_AUDIO}), new TableRef("triggers", TRIGGERS)});
    public static final TableRef RENDERS = new TableRef("renders", new TableRef[]{IMAGE_CARD, TITLE_CARD});
    public static final TableRef TOGGLES = new TableRef("toggles", new TableRef[]{TOGGLE});
    public static final Map<String, TableRef> TABLE_MAP = MTDataRef.buildTableMap();

    private static void addTable(Map<String, TableRef> map, TableRef ref) {
        map.put(ref.name, ref);
    }

    private static ParameterRef<Boolean> buildBoolean(String name, boolean defaultValue) {
        ParameterRef<Boolean> parameter = MTDataRef.buildParameter(name, defaultValue);
        parameter.addPotentialValue(!defaultValue);
        return parameter;
    }

    private static ParameterRef<Float> buildFloat(String name, float defaultValue, float ... potentialValues) {
        ParameterRef<Float> parameter = MTDataRef.buildParameter(name, Float.valueOf(defaultValue));
        for (float value : potentialValues) {
            parameter.addPotentialValue(Float.valueOf(value));
        }
        if (potentialValues.length > 0) {
            parameter.addPotentialValue(Float.valueOf(defaultValue));
        }
        return parameter;
    }

    private static ParameterRef<Integer> buildInt(String name, int defaultValue, int ... potentialValues) {
        ParameterRef<Integer> parameter = MTDataRef.buildParameter(name, defaultValue);
        for (int value : potentialValues) {
            parameter.addPotentialValue(value);
        }
        if (potentialValues.length > 0) {
            parameter.addPotentialValue(defaultValue);
        }
        return parameter;
    }

    private static <T> ParameterRef<T> buildParameter(String name, T defaultValue) {
        return new ParameterRef(name, defaultValue);
    }

    private static TableRef buildRenderCard(String name, ParameterRef<?> ... extraParameters) {
        ArrayList<ParameterRef> parameters = new ArrayList<ParameterRef>(Arrays.asList(MTDataRef.buildParameter("fade_in", 20), MTDataRef.buildParameter("fade_out", 20), MTDataRef.buildString("horizontal_alignment", "center", "center", "left", "right"), MTDataRef.buildParameter("opacity", Float.valueOf(1.0f)), MTDataRef.buildParameter("play_once", false), MTDataRef.buildParameter("scale_x", Float.valueOf(1.0f)), MTDataRef.buildParameter("scale_y", Float.valueOf(1.0f)), MTDataRef.buildParameter("time", 100), MTDataRef.buildParameter("triggers", new ArrayList()), MTDataRef.buildString("vertical_alignment", "center", "center", "left", "right"), MTDataRef.buildParameter("x", -1), MTDataRef.buildParameter("y", -1)));
        parameters.addAll(Arrays.asList(extraParameters));
        return new TableRef(name, parameters, new TableRef[]{EVENT_RUNNER});
    }

    private static ParameterRef<String> buildString(String name, String defaultValue, String ... potentialValues) {
        ParameterRef<String> parameter = MTDataRef.buildParameter(name, defaultValue);
        for (String value : potentialValues) {
            parameter.addPotentialValue(value);
        }
        if (potentialValues.length > 0) {
            parameter.addPotentialValue(defaultValue);
        }
        return parameter;
    }

    private static Set<TableRef> buildTables(TableRef ... tables) {
        return Collections.unmodifiableSet(new HashSet<TableRef>(Arrays.asList(tables)));
    }

    private static Map<String, TableRef> buildTableMap() {
        HashMap<String, TableRef> map = new HashMap<String, TableRef>();
        for (TableRef ref : new TableRef[]{AUDIO, CHANNEL_INFO, COMMAND, COMMANDS, DEBUG, EVENT_RUNNER, FROM, GLOBAL, IMAGE_CARD, INTERRUPT_HANDLER, LINK, LOOP, MAIN, RENDERS, TITLE_CARD, TO, TOGGLE, TOGGLES, UNIVERSAL_AUDIO, UNIVERSAL_TRIGGERS}) {
            MTDataRef.addTable(map, ref);
        }
        for (TableRef ref : TRIGGERS) {
            MTDataRef.addTable(map, ref);
        }
        return Collections.unmodifiableMap(map);
    }

    private static TableRef buildTrigger(String name, boolean holder, ParameterRef<?> ... extraParameters) {
        ArrayList<ParameterRef> parameters = new ArrayList<ParameterRef>(Arrays.asList(MTDataRef.buildParameter("active_cooldown", 0), MTDataRef.buildParameter("fade_in", 0), MTDataRef.buildParameter("fade_out", 0), MTDataRef.buildParameter("max_tracks", 0), MTDataRef.buildParameter("not", false), MTDataRef.buildParameter("passive_persistence", true), MTDataRef.buildParameter("persistence", 0), MTDataRef.buildParameter("play_when_paused", false), MTDataRef.buildParameter("priority", MTDataRef.defaultPriority(name)), MTDataRef.buildParameter("start_as_disabled", false), MTDataRef.buildParameter("ticks_before_active", 0), MTDataRef.buildParameter("ticks_before_audio", 0), MTDataRef.buildParameter("ticks_between_audio", 0), MTDataRef.buildParameter("toggle_inactive_playable", false), MTDataRef.buildParameter("toggle_save_status", 0)));
        if (holder) {
            parameters.add(MTDataRef.buildParameter("identifier", "not_set"));
        }
        parameters.addAll(Arrays.asList(extraParameters));
        return new TableRef(name, parameters, new TableRef[]{LINK});
    }

    public static boolean canWriteDefaults(String type) {
        Debug debug = ChannelHelper.getGlobalData().getDebug();
        return type.equals("debug") || type.equals("global") || debug.getParameterAsList("write_default_values").contains(type);
    }

    private static String[] colors() {
        return new String[]{"aqua", "black", "blue", "dark_aqua", "dark_blue", "dark_gray", "dark_green", "dark_purple", "dark_red", "gold", "gray", "green", "light_purple", "red", "white", "yellow"};
    }

    private static int defaultPriority(String trigger) {
        switch (trigger) {
            case "dimension": {
                return 100;
            }
            case "season": {
                return 200;
            }
            case "statistic": {
                return 300;
            }
            case "pet": {
                return 400;
            }
            case "cloudy": {
                return 500;
            }
            case "biome": {
                return 600;
            }
            case "fishing": {
                return 700;
            }
            case "time": {
                return 800;
            }
            case "light": {
                return 900;
            }
            case "lightrain": {
                return 1000;
            }
            case "home": {
                return 1100;
            }
            case "elytra": {
                return 1200;
            }
            case "effect": {
                return 1300;
            }
            case "inventory": {
                return 1400;
            }
            case "riding": {
                return 1500;
            }
            case "acidrain": {
                return 1600;
            }
            case "starshower": {
                return 1700;
            }
            case "raining": {
                return 1800;
            }
            case "rainintensity": {
                return 1900;
            }
            case "snowing": {
                return 2000;
            }
            case "harvestmoon": {
                return 2100;
            }
            case "bluemoon": {
                return 2200;
            }
            case "moon": {
                return 2300;
            }
            case "storming": {
                return 2400;
            }
            case "bloodmoon": {
                return 2500;
            }
            case "blizzard": {
                return 2600;
            }
            case "hurricane": {
                return 2700;
            }
            case "sandstorm": {
                return 2800;
            }
            case "height": {
                return 2900;
            }
            case "tornado": {
                return 3000;
            }
            case "underwater": {
                return 3100;
            }
            case "structure": {
                return 3200;
            }
            case "zones": {
                return 3300;
            }
            case "blockentity": {
                return 3400;
            }
            case "advancement": {
                return 3500;
            }
            case "command": {
                return 3600;
            }
            case "gui": {
                return 3700;
            }
            case "mob": {
                return 3800;
            }
            case "pvp": {
                return 3900;
            }
            case "lowhp": {
                return 4000;
            }
            case "raid": {
                return 4100;
            }
            case "victory": {
                return 4200;
            }
            case "drowning": {
                return 4300;
            }
            case "dead": {
                return 4400;
            }
        }
        return 0;
    }

    @Nullable
    public static TableRef findTriggerRef(String trigger) {
        for (TableRef ref : TRIGGERS) {
            if (!ref.name.equals(trigger)) continue;
            return ref;
        }
        return null;
    }

    private static String[] matcher() {
        return new String[]{"exact", "partial", "regex"};
    }

    public static void writeToFile(Toml toml, String path) {
        ArrayList lines = new ArrayList();
        toml.write(lines, 0, true);
        if (path.contains("null")) {
            try {
                throw new RuntimeException("File path contains 'null'");
            }
            catch (Throwable t) {
                ChannelHelper.logGlobalWarn("Tried to write file path '{}.toml'", path, t);
            }
        } else {
            FileHelper.writeLines((String)(path + ".toml"), lines, (boolean)false);
        }
    }

    public static final class TableRef {
        private final String name;
        private final Set<ParameterRef<?>> parameters;
        private final Set<TableRef> children;
        private final Sorting[] sorters;
        private TableRef parent;

        private TableRef(String name, TableRef ... children) {
            this(name, new HashSet<TableRef>(Arrays.asList(children)));
        }

        private TableRef(String name, Set<TableRef> children) {
            this(name, Collections.emptySet(), children);
        }

        private TableRef(String name, Collection<ParameterRef<?>> parameters, TableRef ... children) {
            this(name, parameters, new HashSet<TableRef>(Arrays.asList(children)));
        }

        private TableRef(String name, Collection<ParameterRef<?>> parameters, Set<TableRef> children) {
            this.name = name;
            this.parameters = Collections.unmodifiableSet(new HashSet(parameters));
            this.children = Collections.unmodifiableSet(children);
            this.sorters = new Sorting[]{Sorting.ALPHABETICAL};
            for (TableRef child : this.children) {
                child.parent = this;
            }
        }

        public boolean addMissingDefaults(Toml table, LoggableAPI logger) {
            if (!MTDataRef.canWriteDefaults(this.name)) {
                return false;
            }
            table.setSorters(this.sorters);
            boolean added = false;
            for (ParameterRef<?> parameter : this.parameters) {
                if (table.hasEntry(((ParameterRef)parameter).name)) continue;
                table.addEntry(((ParameterRef)parameter).name, ((ParameterRef)parameter).defaultValue);
                added = true;
            }
            switch (this.name) {
                case "channels": {
                    List tables = table.getAllTables();
                    if (tables.isEmpty()) {
                        try {
                            if (!CHANNEL_INFO.addMissingDefaults(table.addTable("example", false), logger)) break;
                            added = true;
                        }
                        catch (TomlWritingException ex) {
                            logger.logError("Unable to generate example channel!", new Object[]{ex});
                        }
                        break;
                    }
                    for (Toml t : tables) {
                        if (!CHANNEL_INFO.addMissingDefaults(t, logger)) continue;
                        added = true;
                    }
                    break;
                }
                case "songs": {
                    for (Toml t : table.getAllTables()) {
                        if (!(t.getName().equals("universal") ? UNIVERSAL_AUDIO : AUDIO).addMissingDefaults(t, logger)) continue;
                        added = true;
                    }
                    break;
                }
                default: {
                    for (TableRef child : this.children) {
                        if (!MTDataRef.canWriteDefaults(child.name)) continue;
                        try {
                            Toml childTable;
                            String name;
                            String string = name = child.name.equals("universal_triggers") ? "universal" : child.name;
                            if (!table.hasTable(name)) {
                                childTable = table.addTable(name, true);
                                added = true;
                            } else {
                                childTable = table.getTable(name);
                            }
                            if (!child.addMissingDefaults(childTable, logger)) continue;
                            added = true;
                        }
                        catch (TomlWritingException ex) {
                            logger.logError("Failed to add missing default children", new Object[]{ex});
                        }
                    }
                }
            }
            return added;
        }

        @Nullable
        public TableRef findChild(String name) {
            if (Objects.isNull(name)) {
                return null;
            }
            for (TableRef ref : this.children) {
                if (!name.equals(ref.name)) continue;
                return ref;
            }
            return null;
        }

        @Nullable
        public ParameterRef<?> findParameter(String name) {
            for (ParameterRef<?> ref : this.parameters) {
                if (!((ParameterRef)ref).name.equals(name)) continue;
                return ref;
            }
            return null;
        }

        public Toml findToml(ChannelHelper helper) {
            switch (this.name) {
                case "debug": {
                    return ChannelHelper.getGlobalData().getDebug().toToml();
                }
                case "toggles": {
                    return helper.togglesAsToml();
                }
            }
            return Toml.getEmpty();
        }

        public boolean hasParent() {
            return Objects.nonNull(this.parent);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Set<ParameterRef<?>> getParameters() {
            return this.parameters;
        }

        @Generated
        public Set<TableRef> getChildren() {
            return this.children;
        }

        @Generated
        public Sorting[] getSorters() {
            return this.sorters;
        }

        @Generated
        public TableRef getParent() {
            return this.parent;
        }
    }

    public static final class ParameterRef<T> {
        private final String name;
        private final T defaultValue;
        private final Collection<T> potentialValues;

        private ParameterRef(String name, T defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.potentialValues = new HashSet<T>();
        }

        void addPotentialValue(T value) {
            this.potentialValues.add(value);
        }

        public boolean hasPotentialValues() {
            return !this.potentialValues.isEmpty();
        }

        public boolean isValid(Object value) {
            if (this.potentialValues.isEmpty()) {
                return true;
            }
            for (T potential : this.potentialValues) {
                if (!GenericUtils.matches(potential, (Object)value)) continue;
                return true;
            }
            return false;
        }

        public Parameter<?> toParameter() {
            if (this.defaultValue instanceof List) {
                return new ParameterList<String>(String.class, new ArrayList((List)this.defaultValue));
            }
            return ParameterHelper.parameterize(this.defaultValue.getClass(), this.defaultValue);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public T getDefaultValue() {
            return this.defaultValue;
        }

        @Generated
        public Collection<T> getPotentialValues() {
            return this.potentialValues;
        }
    }
}

