/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.config;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mods.thecomputerizer.musictriggers.api.config.ConfigVersion;
import mods.thecomputerizer.musictriggers.api.config.MTConfigV6;
import mods.thecomputerizer.musictriggers.api.config.MTConfigV7;
import mods.thecomputerizer.musictriggers.api.data.MTDataRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.data.global.GlobalData;
import mods.thecomputerizer.theimpossiblelibrary.api.io.FileHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;

public class ConfigVersionManager {
    private static final Set<ConfigVersion> VERSIONS = ConfigVersionManager.collectVersions();
    public static final ConfigVersion CURRENT = ConfigVersionManager.findCurrent();

    private static Set<ConfigVersion> collectVersions() {
        return Collections.unmodifiableSet(new HashSet<ConfigVersion>(Arrays.asList(MTConfigV7.LATEST, MTConfigV6.V6_3_1, MTConfigV7.V7_0_0_BETA_1, MTConfigV7.V7_0_0_BETA_3, MTConfigV7.V7_0_0_BETA_4, MTConfigV7.V7_0_0_BETA_10, MTConfigV7.V7_0_0)));
    }

    private static ConfigVersion findCurrent() {
        return ConfigVersionManager.findVersion("7.0.4");
    }

    public static ConfigVersion findLatestQualified(int release, int major, int minor) {
        ConfigVersion closest = null;
        int build = 0;
        for (ConfigVersion config : VERSIONS) {
            ConfigVersion.Version version = config.version;
            if (version.getRelease() != release || version.getMajor() != major || version.getMinor() != minor) continue;
            ConfigVersion.Qualifier qualifier = version.getQualifier();
            if (Objects.isNull(qualifier)) {
                return config;
            }
            if (qualifier.getBuild() <= build) continue;
            closest = config;
            build = qualifier.getBuild();
        }
        if (Objects.isNull(closest)) {
            ChannelHelper.logGlobalError("Unable to find latest build for {}.{}.{}! Substituting with current version {}", release, major, minor, CURRENT);
            closest = CURRENT;
        }
        return closest;
    }

    public static ConfigVersion findVersion(String versionStr) {
        ConfigVersion.Version version = ConfigVersionManager.parseVersion(versionStr);
        ConfigVersion found = null;
        HashSet<ConfigVersion> similarVersions = new HashSet<ConfigVersion>();
        for (ConfigVersion config : VERSIONS) {
            if (config.version.equals(version)) {
                found = config;
                break;
            }
            if (!config.similar(version)) continue;
            similarVersions.add(config);
        }
        GlobalData global = ChannelHelper.getGlobalData();
        if (Objects.isNull(found)) {
            global.logInfo("Unable to find matching config mappings to version {}. Searching for a similar version...", version);
            for (ConfigVersion config : similarVersions) {
                int build = version.getQualifier().getBuild();
                int foundBuild = Objects.nonNull(found) ? found.getVersion().getQualifier().getBuild() : 0;
                int closest = foundBuild > 0 && foundBuild <= build ? build - foundBuild : Integer.MAX_VALUE;
                if (!config.hasCloserQualiferThan(config, closest)) continue;
                found = config;
            }
            if (Objects.isNull(found)) {
                global.logError("Unable to find any config mappings similar to {}", version);
            }
        }
        return found;
    }

    private static ConfigVersion.Version parseVersion(String versionStr) {
        int minor;
        String[] numbers;
        String qualifierStr = null;
        int index = versionStr.indexOf(43);
        if (index > -1) {
            qualifierStr = versionStr.substring(index + 1);
            numbers = versionStr.substring(0, index).split("\\.");
        } else {
            numbers = versionStr.split("\\.");
        }
        int release = numbers.length > 0 ? Integer.parseInt(numbers[0]) : 0;
        int major = numbers.length > 1 ? Integer.parseInt(numbers[1]) : 0;
        int n = minor = numbers.length > 2 ? Integer.parseInt(numbers[2]) : 0;
        if (Objects.isNull(qualifierStr)) {
            return new ConfigVersion.Version(release, major, minor);
        }
        index = qualifierStr.indexOf(45);
        return new ConfigVersion.Version(release, major, minor, new ConfigVersion.Qualifier(index > -1 ? qualifierStr.substring(0, index) : qualifierStr, index > -1 ? Integer.parseInt(qualifierStr.substring(index + 1)) : 1));
    }

    public static void queryRemap() {
        ConfigVersion fileVersion;
        String versionPath = "config/MusicTriggers/version";
        File version = FileHelper.get((String)(versionPath + ".txt"), (boolean)false);
        List<String> versionLines = ChannelHelper.openTxt(versionPath, CURRENT);
        if (versionLines.isEmpty()) {
            CURRENT.logWarn("No version info present! Attempting to remap from 6.3.1", new Object[0]);
            fileVersion = MTConfigV6.V6_3_1;
        } else {
            fileVersion = ConfigVersionManager.findVersion(versionLines.get(0).trim());
        }
        if (Objects.isNull(fileVersion)) {
            CURRENT.logFatal("Unable to remap missing config version!", new Object[0]);
        } else {
            if (fileVersion != CURRENT) {
                ConfigVersionManager.writeBackup();
            }
            fileVersion.remap();
        }
        FileHelper.writeLine((File)version, (String)"7.0.4", (boolean)false);
    }

    private static void writeBackup() {
        File configDir = FileHelper.get((Path)Paths.get("config/MusicTriggers", new String[0]));
        if (!configDir.exists()) {
            return;
        }
        File backupDir = FileHelper.get((Path)Paths.get("config/MusicTriggersBackup", new String[0]));
        ConfigVersionManager.writeBackup(configDir, backupDir);
        CURRENT.logWarn("Backed up all .toml & .txt in {} to {} before remapping", configDir, backupDir);
    }

    private static void writeBackup(File srcDir, File backupDir) {
        File[] files = srcDir.listFiles();
        if (Objects.isNull(files)) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                ConfigVersionManager.writeBackup(file, FileHelper.get((Path)new File(backupDir, file.getName()).toPath(), (boolean)false));
                continue;
            }
            String fileName = file.getName();
            if (!TextHelper.endsWithAny((String)fileName, (String[])new String[]{".toml", ".txt"})) continue;
            List lines = FileHelper.toLines((File)file);
            if (lines.isEmpty()) {
                return;
            }
            boolean shouldWrite = false;
            for (String line : lines) {
                if (!TextHelper.isNotBlank((String)line)) continue;
                shouldWrite = true;
                break;
            }
            if (!shouldWrite) continue;
            File backup = FileHelper.get((File)backupDir, (String)fileName, (boolean)true);
            FileHelper.writeLines((File)backup, (List)lines, (boolean)false);
        }
    }

    public static void writeDefaults(Toml toml, String name, String path) {
        MTDataRef.TableRef ref = MTDataRef.TABLE_MAP.get(name);
        if (Objects.nonNull(ref) && ref.addMissingDefaults(toml, CURRENT)) {
            CURRENT.logInfo("Writing missing default {} values to {}", name, path);
            toml.clearComments();
            toml.addComments(CURRENT.getHeaderLines(name));
            MTDataRef.writeToFile(toml, path);
        }
    }
}

