/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.client.gui.parameters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.client.gui.MTGUIScreen;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.DataLink;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.DataList;
import mods.thecomputerizer.musictriggers.api.data.parameter.ParameterWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Widget;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;

public class SelectionLink
extends DataLink {
    private final boolean multi;
    private final Consumer<ParameterWrapper> singleSelect;
    private final Consumer<Collection<ParameterWrapper>> multiSelect;
    private final Set<SelectionElement> selected;
    private final Map<Function<SelectionElement, String>, Function<DataList, SelectionElement>> elementMakers;
    private final Map<Function<SelectionElement, String>, Function<DataList, SelectionElement>> otherElementMakers;

    public static SelectionLink singleSingle(Consumer<ParameterWrapper> singleSelect) {
        return new SelectionLink(false, false, singleSelect, null);
    }

    public static SelectionLink singleMulti(Consumer<Collection<ParameterWrapper>> multiSelect) {
        return new SelectionLink(false, true, null, multiSelect);
    }

    public static SelectionLink dualSingle(Consumer<ParameterWrapper> singleSelect) {
        return new SelectionLink(true, false, singleSelect, null);
    }

    public static SelectionLink dualMulti(Consumer<Collection<ParameterWrapper>> multiSelect) {
        return new SelectionLink(true, true, null, multiSelect);
    }

    SelectionLink(boolean dual, boolean multi, Consumer<ParameterWrapper> singleSelect, Consumer<Collection<ParameterWrapper>> multiSelect) {
        super(dual);
        this.multi = multi;
        this.singleSelect = singleSelect;
        this.multiSelect = multiSelect;
        this.selected = new HashSet<SelectionElement>();
        this.elementMakers = new HashMap<Function<SelectionElement, String>, Function<DataList, SelectionElement>>();
        this.otherElementMakers = new HashMap<Function<SelectionElement, String>, Function<DataList, SelectionElement>>();
    }

    private DataList addElements(MTGUIScreen screen, double x, double width, Map<Function<SelectionElement, String>, Function<DataList, SelectionElement>> makers, boolean left) {
        DataList list = new DataList(x, 0.0, width, 1.8, 0.05);
        HashMap<SelectionElement, Function<SelectionElement, String>> unsorted = new HashMap<SelectionElement, Function<SelectionElement, String>>();
        for (Map.Entry<Function<SelectionElement, String>, Function<DataList, SelectionElement>> entry : makers.entrySet()) {
            unsorted.put(entry.getValue().apply(list), entry.getKey());
        }
        ArrayList sorted = new ArrayList(unsorted.keySet());
        sorted.sort(Comparator.comparing(w -> (String)((Function)unsorted.get(w)).apply(w)));
        for (SelectionElement element : sorted) {
            list.addWidget(element.widget);
        }
        return list;
    }

    public void addOtherElementMaker(Function<SelectionElement, String> sorter, Function<DataList, SelectionElement> maker) {
        this.otherElementMakers.put(sorter, maker);
    }

    public void addElementMaker(Function<SelectionElement, String> sorter, Function<DataList, SelectionElement> maker) {
        this.elementMakers.put(sorter, maker);
    }

    void applySelected(MTGUIScreen screen) {
        HashSet<ParameterWrapper> wrappers = new HashSet<ParameterWrapper>();
        for (SelectionElement element : this.selected) {
            if (!this.multi) {
                if (Objects.nonNull(this.singleSelect)) {
                    this.singleSelect.accept(element.selectedSupplier.get());
                }
                MTGUIScreen.open(screen);
                return;
            }
            wrappers.add(element.selectedSupplier.get());
        }
        if (this.multi && Objects.nonNull(this.multiSelect)) {
            this.multiSelect.accept(wrappers);
        }
        MTGUIScreen.open(screen);
    }

    @Override
    public TextAPI<?> getDescription() {
        return MTGUIScreen.selectionDesc(this.type.getType(), new Object[0]);
    }

    @Override
    public TextAPI<?> getDisplayName() {
        return MTGUIScreen.selectionName(this.type.getType());
    }

    public DataList getList(MTGUIScreen screen) {
        return this.addElements(screen, this.dual ? -0.5 : 0.0, this.dual ? 1.0 : 2.0, this.elementMakers, true);
    }

    public DataList getOtherList(MTGUIScreen screen) {
        return this.dual ? this.addElements(screen, 0.5, 1.0, this.otherElementMakers, false) : null;
    }

    @Override
    public void populateToml(Toml toml) {
    }

    public void select(SelectionElement element, MTGUIScreen screen) {
        if (this.multi) {
            this.selected.add(element);
            element.selected = true;
        } else {
            for (SelectionElement e : this.selected) {
                e.selected = false;
            }
            this.selected.clear();
            this.selected.add(element);
            element.selected = true;
            this.applySelected(screen);
        }
    }

    public void unselect(SelectionElement element) {
        this.selected.remove(element);
        element.selected = false;
    }

    public static final class SelectionElement {
        final SelectionLink parent;
        final Supplier<ParameterWrapper> selectedSupplier;
        final Widget widget;
        boolean selected;

        public SelectionElement(SelectionLink parent, Function<SelectionElement, Widget> widgetMaker, Supplier<ParameterWrapper> selectedSupplier) {
            this.parent = parent;
            this.selectedSupplier = selectedSupplier;
            this.widget = widgetMaker.apply(this);
        }

        public void onLeftClick(MTGUIScreen screen) {
            if (!this.selected) {
                this.parent.select(this, screen);
            } else {
                this.parent.unselect(this);
            }
        }

        @Generated
        public boolean isSelected() {
            return this.selected;
        }
    }
}

