/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.client.gui.parameters;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.client.gui.MTGUIScreen;
import mods.thecomputerizer.musictriggers.api.client.gui.MTScreenInfo;
import mods.thecomputerizer.musictriggers.api.client.gui.ParameterScreen;
import mods.thecomputerizer.musictriggers.api.client.gui.WrapperScreen;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.CheckBox;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.DataLink;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.DataList;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.SpecialButton;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.TextBox;
import mods.thecomputerizer.musictriggers.api.data.MTDataRef;
import mods.thecomputerizer.musictriggers.api.data.audio.AudioRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelElement;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelEventRunner;
import mods.thecomputerizer.musictriggers.api.data.jukebox.RecordElement;
import mods.thecomputerizer.musictriggers.api.data.parameter.Parameter;
import mods.thecomputerizer.musictriggers.api.data.parameter.ParameterList;
import mods.thecomputerizer.musictriggers.api.data.parameter.ParameterString;
import mods.thecomputerizer.musictriggers.api.data.parameter.ParameterWrapper;
import mods.thecomputerizer.musictriggers.api.data.redirect.RedirectElement;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.ClientHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.MinecraftWindow;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.ScreenHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.BasicWidgetGroup;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.ShapeWidget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.TextWidget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Widget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.WidgetGroup;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.TextBuffer;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;

public class ParameterLink
extends DataLink {
    private final Set<ParameterElement> parameters = new HashSet<ParameterElement>();
    private final Set<DataLink> children = new HashSet<DataLink>();
    private ParameterWrapper wrapper;

    public ParameterLink(ParameterWrapper wrapper, Map<String, Parameter<?>> parameters) {
        super(false);
        ChannelElement record;
        this.wrapper = wrapper;
        MTDataRef.TableRef ref = wrapper.getReferenceData();
        for (Map.Entry<String, Parameter<?>> entry : parameters.entrySet()) {
            this.parameters.add(new ParameterElement(this, entry.getKey(), ref, entry.getValue()));
        }
        if (wrapper instanceof RecordElement) {
            record = (RecordElement)wrapper;
            this.parameters.add(new ParameterElement(this, "jukebox_key", null, new ParameterString(((RecordElement)record).getKey())));
            this.parameters.add(new ParameterElement(this, "jukebox_value", null, new ParameterString(((RecordElement)record).getValue())));
        } else if (wrapper instanceof RedirectElement) {
            record = (RedirectElement)wrapper;
            this.parameters.add(new ParameterElement(this, "redirect_key", null, new ParameterString(((RedirectElement)record).getKey())));
            this.parameters.add(new ParameterElement(this, "redirect_value", null, new ParameterString(((RedirectElement)record).getValue())));
        }
    }

    public void addChildren(MTGUIScreen screen, DataList list) {
        for (DataLink link : this.children) {
            list.addButton(link.getDisplayName(), b -> {
                link.type.setLink(link);
                MinecraftWindow window = ClientHelper.getWindow();
                int scale = ClientHelper.getGuiScale();
                MTGUIScreen.open(link instanceof ParameterLink ? new ParameterScreen(screen, link.type, window, scale) : new WrapperScreen(screen, link.type, window, scale));
            }, link.getDescription());
        }
    }

    public void distributeExternalChange(String name, Object value) {
        for (ParameterElement element : this.parameters) {
            if (!element.name.equals(name)) continue;
            element.modifiable.setValue(value);
            element.refreshWidget();
            return;
        }
    }

    @Override
    public TextAPI<?> getDescription() {
        return Objects.nonNull(this.type) ? MTGUIScreen.selectionDesc(this.type.getType(), new Object[0]) : null;
    }

    @Override
    public TextAPI<?> getDisplayName() {
        return Objects.nonNull(this.type) ? MTGUIScreen.selectionName(this.type.getType()) : null;
    }

    @Nullable
    public Object getModifiedValue(String name) {
        for (ParameterElement element : this.parameters) {
            if (!element.name.equals(name)) continue;
            return element.getValue();
        }
        return null;
    }

    @Override
    public void populateToml(Toml toml) {
        for (ParameterElement parameter : this.parameters) {
            Object value = parameter.getValue();
            MTDataRef.TableRef ref = this.wrapper.getReferenceData();
            if (Objects.nonNull(ref) && Misc.equalsAny((Object)ref.getName(), (Object[])new String[]{"channel", "debug"}) || "triggers".equals(parameter.name)) {
                toml.addEntry(parameter.name, value);
                continue;
            }
            if (Objects.isNull(parameter.ref)) {
                this.wrapper.logError("Null ParameterRef for ParameterElement! (name = {} | value = {}", parameter.name, parameter.getLiteralValue());
                continue;
            }
            if (GenericUtils.matches(parameter.ref.getDefaultValue(), (Object)value)) continue;
            toml.addEntry(parameter.name, value);
        }
        if (Objects.nonNull(this.type)) {
            this.type.populateNext(toml, true);
        } else {
            this.wrapper.logError("Cannot populate the next Toml instance with null screen type!", new RuntimeException());
        }
    }

    @Override
    public void setType(MTScreenInfo type) {
        if (Objects.isNull(type)) {
            this.wrapper.logError("Tried to set screen type for ParameterLink to null!", new RuntimeException());
            return;
        }
        this.type = type;
        if (this.children.isEmpty()) {
            this.children.addAll(this.wrapper.getChildWrappers(this.type));
        }
    }

    @Generated
    public Set<ParameterElement> getParameters() {
        return this.parameters;
    }

    @Generated
    public ParameterWrapper getWrapper() {
        return this.wrapper;
    }

    @Generated
    public Set<DataLink> getChildren() {
        return this.children;
    }

    @Generated
    public void setWrapper(ParameterWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public static final class ParameterElement {
        final ParameterLink parent;
        final String name;
        final MTDataRef.ParameterRef<?> ref;
        final Parameter<?> original;
        Parameter<?> modifiable;
        Widget widget;

        ParameterElement(ParameterLink parent, String name, @Nullable MTDataRef.TableRef ref, Parameter<?> parameter) {
            this.parent = parent;
            this.name = name;
            this.ref = Objects.nonNull(ref) ? ref.findParameter(name) : null;
            this.original = parameter;
            this.modifiable = parameter.copy();
        }

        public TextAPI<?> getDescription() {
            String name = this.name;
            if (name.equals("priority") && this.parent.wrapper instanceof AudioRef.InterruptHandler) {
                name = "interrupt_" + name;
            }
            if (this.parent.wrapper instanceof ChannelEventRunner.EventInstance) {
                name = "event_" + name;
            }
            return MTGUIScreen.parameterDesc(name);
        }

        public TextAPI<?> getHover() {
            return TextHelper.getLiteral((String)this.name);
        }

        public TextAPI<?> getDisplayName() {
            String name = this.name;
            if (name.equals("priority") && this.parent.wrapper instanceof AudioRef.InterruptHandler) {
                name = "interrupt_" + name;
            }
            if (this.parent.wrapper instanceof ChannelEventRunner.EventInstance) {
                name = "event_" + name;
            }
            return MTGUIScreen.parameterName(name);
        }

        public String getLiteralValue() {
            return String.valueOf(this.modifiable.getValue());
        }

        public Object getValue() {
            return this.modifiable.getValue();
        }

        void refreshWidget() {
            if (this.widget instanceof WidgetGroup) {
                for (Widget widget : ((WidgetGroup)this.widget).getWidgets()) {
                    if (widget instanceof CheckBox) {
                        ((CheckBox)widget).setSelected((Boolean)this.getValue());
                        continue;
                    }
                    if (widget instanceof DataList) {
                        DataList data = (DataList)widget;
                        Collection widgets = data.getWidgets();
                        List updated = (List)this.getValue();
                        Widget button = null;
                        for (Widget w : widgets) {
                            if (!(w instanceof SpecialButton)) continue;
                            button = w;
                            break;
                        }
                        widgets.clear();
                        for (Object value : updated) {
                            TextBuffer text = TextBuffer.literal((String)String.valueOf(value));
                            data.addWidget((Widget)new TextBox(this, text, 0.0, 0.0, widget.getWidth()));
                        }
                        if (!Objects.nonNull(button)) continue;
                        data.addWidget(button);
                        continue;
                    }
                    if (!(widget instanceof TextBox)) continue;
                    ((TextBox)widget).setText(this.getLiteralValue());
                }
            }
        }

        public void removeFromSelf(String value) {
            ParameterWrapper wrapper;
            if (this.modifiable.isList()) {
                ((List)((ParameterList)this.modifiable).getValue()).remove(value);
            }
            if ("triggers".equals(this.name) && (wrapper = this.parent.wrapper) instanceof AudioRef) {
                ((AudioRef)wrapper).removeTrigger(value);
            }
            this.parent.setModified(true);
        }

        public void save(Object value) {
            String previous = String.valueOf(this.modifiable.getValue());
            this.modifiable.setValue(value);
            this.parent.setModified(true);
            MTScreenInfo type = this.parent.type;
            if (this.parent.wrapper instanceof RecordElement) {
                type.distributeJukeboxChange(this.parent);
            } else if (this.parent.wrapper instanceof RedirectElement) {
                type.distributeRedirectChange(this.parent, previous);
            } else if (this.name.equals("identifier") && this.parent.wrapper instanceof TriggerAPI) {
                type.distributeIdentifierChange(this.parent, this.getLiteralValue(), previous);
            }
        }

        public Widget toWidget(ParameterScreen screen) {
            if (Objects.isNull(this.widget)) {
                BasicWidgetGroup group = BasicWidgetGroup.from((double)-0.5, (double)0.0, (double)0.95, (double)2.0, (Widget[])new Widget[0]);
                group.addWidget((Widget)TextWidget.from(this.getDisplayName(), (double)0.0, (double)0.75));
                group.addWidget((Widget)ShapeWidget.outlineFrom((double)0.95, (double)0.25, (double)0.0, (double)0.75));
                DataList list = new DataList(0.0, 0.25, 0.95, 0.75, 0.05);
                list.addWidget((Widget)TextWidget.from((TextBuffer)TextBuffer.getBuilder(this.getDescription()).setAlignment(TextBuffer.Alignment.TOP_CENTER).build()));
                group.addWidget((Widget)list);
                group.addWidget((Widget)ShapeWidget.outlineFrom((double)0.95, (double)0.75, (double)0.0, (double)0.25));
                this.valueModifierWidgets(screen, (WidgetGroup)group);
                this.widget = group;
            }
            if (!screen.getWidgets().contains(this.widget)) {
                screen.addWidget(this.widget);
            }
            return this.widget;
        }

        private void valueModifierWidgets(ParameterScreen screen, WidgetGroup group) {
            double x = 0.0;
            double y = -0.5;
            if (this.original.isBool()) {
                group.addWidget((Widget)new CheckBox(this, 0.25, x, y));
            } else if (this.original.isList()) {
                DataList list = new DataList(x, y, 0.95, 0.75, 0.05);
                for (Object element : (Collection)this.getValue()) {
                    TextBuffer text = TextBuffer.literal((String)String.valueOf(element));
                    list.addWidget((Widget)new TextBox(this, text, 0.0, 0.0, list.getWidth()));
                }
                SpecialButton add = list.makeSpecialButton(this.parent.type.getSpecialLang("gui", "button.add_entry.name"), b -> {
                    Collection widgets = list.getWidgets();
                    for (Widget w : widgets) {
                        if (!(w instanceof SpecialButton) || !((SpecialButton)w).isDeleting()) continue;
                        return;
                    }
                    widgets.remove(b);
                    TextBuffer text = TextBuffer.literal((String)"_");
                    list.addWidget((Widget)new TextBox(this, text, 0.0, 0.0, list.getWidth()));
                    widgets.add(b);
                    list.setWidgets(widgets);
                    this.parent.setModified(true);
                });
                add.getText().setColor(ColorHelper.GRAY.withAlpha(0.7f));
                add.setContextFunc(b -> {
                    SpecialButton specialButton = (SpecialButton)((Object)b);
                    boolean delete = specialButton.isDeleting();
                    b.getText().setColor(delete ? ColorHelper.GRAY.withAlpha(0.7f) : ColorHelper.RED);
                    TextAPI<?> text = this.parent.type.getSpecialLang("gui", "button." + (delete ? "add" : "remove") + "_entry.name");
                    b.setText(text);
                    b.setHoverText(h -> {
                        h.setColor(delete ? ColorHelper.AQUA : ColorHelper.DARK_RED);
                        h.setText(text);
                    });
                    specialButton.setDeleting(!delete);
                    ScreenHelper.playVanillaClickSound();
                });
                list.addWidget((Widget)add);
                group.addWidget((Widget)list);
            } else {
                group.addWidget((Widget)new TextBox(this, TextBuffer.literal((String)this.getLiteralValue()), x, y, 0.95));
            }
            group.addWidget((Widget)ShapeWidget.outlineFrom((double)0.95, (double)0.75, (double)x, (double)y));
        }

        @Generated
        public String getName() {
            return this.name;
        }
    }
}

