/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.client.gui.parameters;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.client.gui.MTGUIScreen;
import mods.thecomputerizer.musictriggers.api.client.gui.ParameterScreen;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.DataLink;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.DataList;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.BasicWidgetGroup;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.ShapeWidget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.TextWidget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Widget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.TextBuffer;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;

public class HelpLink
extends DataLink {
    static final Set<String> TYPES = Collections.unmodifiableSet(new HashSet<String>(HelpLink.buildTypes()));
    static HelpLink instance;
    private final Set<HelpElement> elements = TYPES.stream().map(HelpElement::new).collect(Collectors.toSet());

    static List<String> buildTypes() {
        return Arrays.asList("alpha_warning", "channel_interaction", "channels", "identifiers", "removing_triggers");
    }

    public static HelpLink getInstance() {
        if (Objects.isNull(instance)) {
            instance = new HelpLink();
        }
        return instance;
    }

    static String typeKeyDesc(String type) {
        return "parameter.musictriggers.help." + type + ".desc";
    }

    static String typeKeyName(String type) {
        return "parameter.musictriggers.help." + type + ".name";
    }

    private HelpLink() {
        super(false);
    }

    @Override
    public TextAPI<?> getDescription() {
        return Objects.nonNull(this.type) ? MTGUIScreen.selectionDesc(this.type.getType(), new Object[0]) : null;
    }

    @Override
    public TextAPI<?> getDisplayName() {
        return Objects.nonNull(this.type) ? MTGUIScreen.selectionName(this.type.getType()) : null;
    }

    @Override
    public void populateToml(Toml toml) {
    }

    @Generated
    public Set<HelpElement> getElements() {
        return this.elements;
    }

    public static final class HelpElement {
        final String name;
        Widget widget;

        HelpElement(String name) {
            this.name = name;
        }

        public TextAPI<?> getDescription() {
            return TextHelper.getTranslated((String)HelpLink.typeKeyDesc(this.name), (Object[])new Object[0]);
        }

        public TextAPI<?> getDisplayName() {
            return TextHelper.getTranslated((String)HelpLink.typeKeyName(this.name), (Object[])new Object[0]);
        }

        public TextAPI<?> getHover() {
            return TextHelper.getLiteral((String)this.name);
        }

        public Widget toWidget(ParameterScreen screen) {
            if (Objects.isNull(this.widget)) {
                BasicWidgetGroup group = BasicWidgetGroup.from((double)-0.5, (double)0.0, (double)0.95, (double)2.0, (Widget[])new Widget[0]);
                group.addWidget((Widget)TextWidget.from(this.getDisplayName(), (double)0.0, (double)0.75));
                group.addWidget((Widget)ShapeWidget.outlineFrom((double)0.95, (double)0.25, (double)0.0, (double)0.75));
                DataList list = new DataList(0.0, -0.125, 0.95, 1.5, 0.05);
                list.addWidget((Widget)TextWidget.from((TextBuffer)TextBuffer.getBuilder(this.getDescription()).setAlignment(TextBuffer.Alignment.TOP_CENTER).build()));
                group.addWidget((Widget)list);
                group.addWidget((Widget)ShapeWidget.outlineFrom((double)0.95, (double)1.5, (double)0.0, (double)-0.125));
                this.widget = group;
            }
            if (!screen.getWidgets().contains(this.widget)) {
                screen.addWidget(this.widget);
            }
            return this.widget;
        }

        @Generated
        public String getName() {
            return this.name;
        }
    }
}

