/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.client.gui.parameters;

import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.client.gui.MTGUIScreen;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.ParameterLink;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.ScreenHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Selectable;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.ShapeWidget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Widget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.WidgetGroup;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorCache;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.TextureWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.Facing;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Shape;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.ShapeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Square;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;

public class CheckBox
extends WidgetGroup
implements Selectable {
    public static final TextureWrapper CHECKED = CheckBox.checkboxTexture(true, false);
    public static final TextureWrapper CHECKED_HOVER = CheckBox.checkboxTexture(true, true);
    public static final TextureWrapper UNCHECKED = CheckBox.checkboxTexture(false, false);
    public static final TextureWrapper UNCHECKED_HOVER = CheckBox.checkboxTexture(false, true);
    private final ParameterLink.ParameterElement link;
    private final ShapeWidget checked;
    private final ShapeWidget checkedHover;
    private final ShapeWidget hoverBackground;
    private final ShapeWidget unchecked;
    private final ShapeWidget uncheckedHover;
    private boolean selected;
    private final double sideLength;

    private static TextureWrapper checkboxTexture(boolean checked, boolean hover) {
        String path = String.format("textures/gui/%1$sicon/%2$schecked.png", hover ? "hover/" : "", checked ? "" : "un");
        return TextureWrapper.of((String)"musictriggers", (String)path);
    }

    public CheckBox(ParameterLink.ParameterElement link, double sideLength, double x, double y) {
        this.link = link;
        this.selected = (Boolean)link.getValue();
        this.sideLength = sideLength;
        Square shape = ShapeHelper.square((Facing.Axis)Facing.Axis.Y, (double)sideLength, (double)RenderHelper.getCurrentHeightRatio());
        this.checked = ShapeWidget.from((Shape)shape, (TextureWrapper)CHECKED);
        this.checkedHover = ShapeWidget.from((Shape)shape, (TextureWrapper)CHECKED_HOVER);
        this.hoverBackground = ShapeWidget.from((Shape)shape.getScaled(1.05), (ColorCache)ColorHelper.WHITE.withAlpha(0.33333334f));
        this.unchecked = ShapeWidget.from((Shape)shape, (TextureWrapper)UNCHECKED);
        this.uncheckedHover = ShapeWidget.from((Shape)shape, (TextureWrapper)UNCHECKED_HOVER);
        this.addWidgets(new Widget[]{this.checked, this.checkedHover, this.hoverBackground, this.unchecked, this.uncheckedHover});
        this.setX(x);
        this.setY(y);
    }

    public CheckBox copy() {
        CheckBox copy = new CheckBox(this.link, this.sideLength, this.x, this.y);
        copy.copyGroup(this);
        return copy;
    }

    public void draw(RenderContext ctx, Vector3 center, double mouseX, double mouseY) {
        if (this.canDraw()) {
            if (this.selected) {
                if (this.isHovering(mouseX, mouseY)) {
                    this.hoverBackground.draw(ctx, center, mouseX, mouseY);
                    this.checkedHover.draw(ctx, center, mouseX, mouseY);
                } else {
                    this.checked.draw(ctx, center, mouseX, mouseY);
                }
            } else if (this.isHovering(mouseX, mouseY)) {
                this.hoverBackground.draw(ctx, center, mouseX, mouseY);
                this.uncheckedHover.draw(ctx, center, mouseX, mouseY);
            } else {
                this.unchecked.draw(ctx, center, mouseX, mouseY);
            }
        }
    }

    public boolean isHovering(double x, double y) {
        return this.checked.isInside(x, y, 0.0);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void drawSelected(RenderContext ctx, Vector3 center, double mouseX, double mouseY) {
        this.draw(ctx, center, mouseX, mouseY);
    }

    public boolean onLeftClick(double mouseX, double mouseY) {
        if (this.isHovering(mouseX, mouseY)) {
            this.selected = !this.selected;
            this.playLeftClickSound();
            if ("gui_fuzz".equals(this.link.name)) {
                MTGUIScreen.toggleFuzz(this.selected);
            }
            this.link.save(this.selected);
            return true;
        }
        return false;
    }

    public boolean onRightClick(double mouseX, double mouseY) {
        return false;
    }

    public void playLeftClickSound() {
        ScreenHelper.playVanillaClickSound();
    }

    public void playRightClickSound() {
    }

    @Generated
    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

