/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.client.gui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import mods.thecomputerizer.musictriggers.api.client.gui.MTGUIScreen;
import mods.thecomputerizer.musictriggers.api.client.gui.MTScreenInfo;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.DataLink;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.DataList;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.HelpLink;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.ParameterLink;
import mods.thecomputerizer.musictriggers.api.data.MTDataRef;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.MinecraftWindow;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.ScreenAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Button;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Widget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.WidgetHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.WidgetList;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;

public class ParameterScreen
extends MTGUIScreen {
    private Widget activeWidget;
    private Widget activeDropDown;

    public ParameterScreen(ScreenAPI parent, MTScreenInfo info, MinecraftWindow window, int guiScale) {
        super(parent, info, window, guiScale);
        this.addTextBackground(v -> {
            DataList list = new DataList(0.5, 0.0, 1.0, 1.8, 0.05);
            DataLink typeLink = this.typeInfo.getLink();
            if (typeLink instanceof ParameterLink) {
                this.addParameterLink(list, (ParameterLink)typeLink);
            } else if (typeLink instanceof HelpLink) {
                this.addHelpLink(list, (HelpLink)typeLink);
            }
            this.addWidget((Widget)list);
            this.autoAddTypeTexture(-list.getScrollBar().getWidth());
        });
    }

    private void addHelpLink(DataList list, HelpLink link) {
        ArrayList<HelpLink.HelpElement> elements = new ArrayList<HelpLink.HelpElement>(link.getElements());
        elements.sort(Comparator.comparing(e -> e.getDisplayName().toString()));
        for (HelpLink.HelpElement parameter : elements) {
            list.addButton(parameter.getDisplayName(), b -> {
                if (Objects.nonNull(this.activeWidget)) {
                    this.activeWidget.setVisible(false);
                }
                this.activeWidget = parameter.toWidget(this);
                this.activeWidget.setVisible(true);
            }, parameter.getHover());
        }
    }

    private void addParameterLink(DataList list, ParameterLink link) {
        link.addChildren(this, list);
        ArrayList<ParameterLink.ParameterElement> parameters = new ArrayList<ParameterLink.ParameterElement>(link.getParameters());
        parameters.sort(Comparator.comparing(e -> e.getDisplayName().toString()));
        for (ParameterLink.ParameterElement parameter : parameters) {
            list.addButton(parameter.getDisplayName(), b -> {
                if (Objects.nonNull(this.activeWidget)) {
                    this.activeWidget.setVisible(false);
                }
                this.activeWidget = parameter.toWidget(this);
                this.activeWidget.setVisible(true);
            }, parameter.getHover());
        }
    }

    public float defaultBackgroundDarkness() {
        return 0.6f;
    }

    public void draw(RenderContext ctx, Vector3 center, double mouseX, double mouseY) {
        RenderAPI renderer = ctx.getRenderer();
        renderer.translate(0.0, 0.0, -200.0);
        if (Objects.nonNull(this.parentScreen)) {
            this.parentScreen.draw(ctx, center, mouseX + 9999.0, mouseY + 9999.0);
        }
        renderer.translate(0.0, 0.0, 200.0);
        super.draw(ctx, center, mouseX, mouseY);
    }

    private WidgetList potentialValues(Button template, MTDataRef.ParameterRef<?> ref) {
        ArrayList<Button> potentials = new ArrayList<Button>();
        for (Object potentialValue : ref.getPotentialValues()) {
            Button potential = template.copy();
            potential.setText(String.valueOf(potentialValue));
            potential.setClickFunc(b -> this.saveActiveEntryAs(potentialValue));
            potentials.add(potential);
        }
        return WidgetHelper.dropDownFrom((Widget)template, (double)-0.9, potentials);
    }

    public void saveActiveEntryAs(Object value) {
    }

    public static enum ParameterType {
        BOOLEAN,
        DROPDOWN,
        LIST,
        NUMBER,
        STRING;

    }

    public static enum ParameterConstraints {
        CHARACTER_BLACKLIST,
        DECIMAL,
        INTEGER,
        NUMBER_RANGE,
        RELOAD_REQUIRED,
        RESTART_REQUIRED;

    }
}

