/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.client.gui;

import java.util.Objects;
import mods.thecomputerizer.musictriggers.api.client.gui.MTGUIScreen;
import mods.thecomputerizer.musictriggers.api.client.gui.MTScreenInfo;
import mods.thecomputerizer.musictriggers.api.data.log.LogMessage;
import mods.thecomputerizer.musictriggers.api.data.log.MTLogger;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.MinecraftWindow;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.ScreenAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.TextWidget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Widget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.WidgetList;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.TextBuffer;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;

public class LogVisualizer
extends MTGUIScreen {
    public LogVisualizer(ScreenAPI parent, MTScreenInfo typeInfo, MinecraftWindow window, int guiScale) {
        super(parent, typeInfo, window, guiScale);
        this.addTextBackground(v -> {
            ReverseList list = new ReverseList((Widget)TextWidget.literal((String)"message"));
            list.setSpacing(0.05);
            for (LogMessage message : MTLogger.getGUISnapshot()) {
                TextBuffer buffer = TextBuffer.literalBuilder((String)message.getDisplay()).setColor(message.getColor()).setAlignment(TextBuffer.Alignment.TOP_LEFT).setTranslateX(list.getScrollBar().getWidth() * 2.0).build();
                double textWidth = list.getWidth() * 0.95;
                TextWidget text = TextWidget.from((TextBuffer)buffer);
                text.setWidth(textWidth);
                list.addWidget((Widget)text);
            }
            this.addWidget((Widget)list);
            this.addTypeTexture(-list.getScrollBar().getWidth(), 0.0);
        });
    }

    public float defaultBackgroundDarkness() {
        return 0.6f;
    }

    public void draw(RenderContext ctx, Vector3 center, double mouseX, double mouseY) {
        RenderAPI renderer = ctx.getRenderer();
        renderer.translate(0.0, 0.0, -200.0);
        if (Objects.nonNull(this.parentScreen)) {
            this.parentScreen.draw(ctx, center, mouseX + 9999.0, mouseY + 9999.0);
        }
        renderer.translate(0.0, 0.0, 200.0);
        super.draw(ctx, center, mouseX, mouseY);
    }

    static class ReverseList
    extends WidgetList {
        public ReverseList(Widget template) {
            super(template, 0.0, 0.0, 2.0, 1.8);
        }

        protected void recalculatePositions() {
            super.recalculatePositions();
            double height = this.getHeight();
            double elementsHeight = this.getElementsHeight();
            if (elementsHeight > height) {
                this.scrollOffset = elementsHeight - height;
            }
            this.setScrollBarPos();
        }
    }
}

