/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.client.channel;

import java.util.Objects;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.client.audio.AudioContainer;
import mods.thecomputerizer.musictriggers.api.client.channel.ChannelClient;
import mods.thecomputerizer.musictriggers.api.data.audio.AudioRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;
import org.apache.logging.log4j.Level;

public abstract class ChannelClientSpecial
extends ChannelClient {
    protected Level logLevel;
    protected String playingName;
    protected Vector3 playingPos = VectorHelper.max3I();
    protected AudioTrack playingTrack;

    public ChannelClientSpecial(ChannelHelper helper, Toml info) {
        this(helper, info, Level.WARN);
    }

    public ChannelClientSpecial(ChannelHelper helper, Toml info, Level logLevel) {
        super(helper, info);
        this.logLevel = logLevel;
    }

    public abstract void checkStop(Vector3 var1);

    @Override
    public String getPlayingSongName() {
        return this.playingName;
    }

    public boolean isPlaying() {
        return Objects.nonNull(this.playingTrack);
    }

    @Override
    public void loadTracks(boolean ignored) {
    }

    @Override
    public void logDebug(String msg, Object ... args) {
        if (Objects.nonNull(this.logLevel) && this.logLevel.intLevel() >= Level.DEBUG.intLevel()) {
            super.logDebug(msg, args);
        }
    }

    @Override
    public void logError(String msg, Object ... args) {
        if (Objects.isNull(this.logLevel) || this.logLevel.intLevel() >= Level.ERROR.intLevel()) {
            super.logError(msg, args);
        }
    }

    @Override
    public void logFatal(String msg, Object ... args) {
        if (Objects.isNull(this.logLevel) || this.logLevel.intLevel() >= Level.FATAL.intLevel()) {
            super.logFatal(msg, args);
        }
    }

    @Override
    public void logInfo(String msg, Object ... args) {
        if (Objects.isNull(this.logLevel) || this.logLevel.intLevel() >= Level.INFO.intLevel()) {
            super.logInfo(msg, args);
        }
    }

    @Override
    public void logTrace(String msg, Object ... args) {
        if (Objects.nonNull(this.logLevel) && this.logLevel.intLevel() >= Level.TRACE.intLevel()) {
            super.logTrace(msg, args);
        }
    }

    @Override
    public void logWarn(String msg, Object ... args) {
        if (Objects.isNull(this.logLevel) || this.logLevel.intLevel() >= Level.WARN.intLevel()) {
            super.logWarn(msg, args);
        }
    }

    @Override
    public void parseData() {
    }

    public void playReference(AudioRef ref, Vector3 pos) {
        if (ref instanceof AudioContainer) {
            AudioContainer container = (AudioContainer)ref;
            AudioTrack track = container.getTrack();
            if (Objects.nonNull(track)) {
                this.playingName = container.getName();
                this.player.playTrack(track);
                this.playingTrack = track;
                this.playingPos = pos;
            } else {
                this.logError("Cannot play null track from {}!", container);
            }
        } else {
            this.logError("Cannot play track from non audio container!", new Object[0]);
        }
    }

    @Override
    public boolean showDebugTriggerInfo() {
        return false;
    }

    @Override
    public void stop() {
        this.player.stopTrack();
        this.playingTrack = null;
        this.playingName = null;
        this.playingPos = VectorHelper.max3I();
    }

    @Override
    public void tickActive(boolean unpaused) {
    }

    @Override
    public void tickPlayable(boolean unpaused) {
    }

    @Override
    public void tickSlow(boolean unpaused) {
    }

    @Generated
    public void setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
    }
}

