/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.client.channel;

import java.io.File;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import mods.thecomputerizer.musictriggers.api.client.MTClient;
import mods.thecomputerizer.musictriggers.api.client.MTClientEvents;
import mods.thecomputerizer.musictriggers.api.client.audio.TrackLoader;
import mods.thecomputerizer.musictriggers.api.client.audio.resource.ResourceAudioSourceManager;
import mods.thecomputerizer.musictriggers.api.data.audio.AudioPool;
import mods.thecomputerizer.musictriggers.api.data.audio.AudioRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelListener;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerAPI;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.format.StandardAudioDataFormats;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.AudioConfiguration;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.AudioSourceManagers;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import mods.thecomputerizer.theimpossiblelibrary.api.client.ClientHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;
import mods.thecomputerizer.theimpossiblelibrary.api.util.EnumHelper;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class ChannelClient
extends ChannelAPI {
    private final AudioPlayerManager manager = this.createManager();
    protected final AudioPlayer player = this.createPlayer();
    private final ChannelListener listener;
    private final TrackLoader trackLoader;
    private boolean registeredResourceAudio;
    private float categoryVolume;
    private float masterVolume;
    private float trackVolume;
    private boolean queued;
    private AudioPool playingPool;
    private boolean deactivating;

    public ChannelClient(ChannelHelper helper, Toml table) {
        super(helper, table);
        this.configure(this.finalizeManager());
        this.listener = new ChannelListener(this);
        this.trackLoader = new TrackLoader(this);
    }

    @Override
    public boolean checkDeactivate(TriggerAPI current, TriggerAPI next) {
        if (Objects.nonNull(current)) {
            if (current.matches(next)) {
                this.deactivating = false;
                return false;
            }
            if (Objects.isNull(this.playingPool) || Objects.isNull(this.player.getPlayingTrack()) && !this.playingPool.isQueued()) {
                return true;
            }
            if (!this.deactivating) {
                this.deactivateLink();
            }
            this.deactivating = true;
            this.playingPool.queryInterrupt(next, this.player);
            return false;
        }
        return true;
    }

    public boolean checkFocus() {
        return MTClient.isFocused() || !ChannelHelper.getDebugBool("pause_unless_focused");
    }

    public boolean checkJukebox(boolean jukebox) {
        return !jukebox || !this.getInfo().isPausedByJukebox();
    }

    public boolean checkPaused(boolean unpaused) {
        return unpaused || this.getInfo().hasPausedMusic();
    }

    @Override
    public void close() {
        super.close();
        this.listener.close();
        this.player.destroy();
        this.manager.shutdown();
        this.categoryVolume = 0.0f;
        this.trackVolume = 0.0f;
        this.queued = false;
        this.playingPool = null;
    }

    protected void configure(AudioConfiguration config) {
        String resamplingQuality = ChannelHelper.getDebugString("resampling_quality");
        config.setResamplingQuality((AudioConfiguration.ResamplingQuality)EnumHelper.getEnumOrDefault((String)resamplingQuality, AudioConfiguration.ResamplingQuality.class, (Enum)AudioConfiguration.ResamplingQuality.HIGH));
        config.setOpusEncodingQuality(ChannelHelper.getDebugNumber("encoding_quality").intValue());
        config.setOutputFormat(StandardAudioDataFormats.DISCORD_PCM_S16_BE);
    }

    protected AudioPlayerManager createManager() {
        DefaultAudioPlayerManager manager = new DefaultAudioPlayerManager();
        ChannelHelper.registerRemoteSources(this, manager);
        AudioSourceManagers.registerLocalSource(manager);
        manager.setFrameBufferDuration((int)TimeUnit.SECONDS.toMillis(15L));
        return manager;
    }

    protected AudioPlayer createPlayer() {
        AudioPlayer player = this.manager.createPlayer();
        player.setVolume(0);
        return player;
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.deactivating = false;
        this.playingPool = null;
    }

    @Override
    public void disable(TriggerAPI.Link link) {
        super.disable(link);
        if (Objects.nonNull(this.playingPool)) {
            this.stop();
        }
    }

    protected AudioConfiguration finalizeManager() {
        this.manager.setFrameBufferDuration(1000);
        this.manager.setPlayerCleanupThreshold(Long.MAX_VALUE);
        return this.manager.getConfiguration();
    }

    @Nullable
    private String findMatchingFile(File folder, String path) {
        if (Objects.isNull(folder) || TextHelper.isBlank((String)path)) {
            return null;
        }
        String[] matches = folder.list((dir, name) -> name.equals(path) || name.startsWith(path + "."));
        return Objects.nonNull(matches) && matches.length > 0 ? matches[0] : null;
    }

    @Override
    @Nullable
    public String getFormattedSongTime() {
        AudioTrack track = this.player.getPlayingTrack();
        if (Objects.isNull(track)) {
            return null;
        }
        String current = this.getFormattedTime(this.getPlayingSongTime());
        String duration = this.getFormattedTime(track.getDuration());
        return current + "/" + duration;
    }

    protected String getFormattedTime(long millis) {
        String format = millis >= 3600000L ? "HH:mm:ss:SSS" : (millis >= 60000L ? "mm:ss:SSS" : "ss:SSS");
        return DurationFormatUtils.formatDuration((long)millis, (String)format);
    }

    @Override
    public String getLogType() {
        return "CLIENT";
    }

    @Override
    public AudioPlayer getPlayer() {
        return this.player;
    }

    @Override
    @Nullable
    public AudioPool getPlayingPool() {
        return this.playingPool;
    }

    @Override
    @Nullable
    public String getPlayingSongName() {
        if (Objects.isNull(this.playingPool)) {
            return null;
        }
        AudioRef ref = this.playingPool;
        while (ref instanceof AudioPool) {
            ref = ((AudioPool)ref).getQueuedAudio();
        }
        return Objects.nonNull(ref) ? ref.getName() : null;
    }

    @Override
    public long getPlayingSongTime() {
        AudioTrack track = this.player.getPlayingTrack();
        double speed = Objects.nonNull(this.playingPool) ? this.playingPool.getSpeed() : 1.0;
        return Objects.nonNull(track) ? (long)((double)track.getPosition() * speed) : 0L;
    }

    @Override
    public long getPlayingSongTotalTime() {
        AudioTrack track = this.player.getPlayingTrack();
        return Objects.nonNull(track) ? track.getDuration() : 0L;
    }

    @Override
    public boolean isClientChannel() {
        return true;
    }

    @Override
    public boolean isValid() {
        return Objects.nonNull(this.trackLoader);
    }

    @Override
    public String loadLocalTrack(AudioRef ref, String location) {
        if (this.getInfo().canReadFiles()) {
            File folder = this.getInfo().getLocalFolder();
            String match = this.findMatchingFile(folder, location);
            this.trackLoader.loadLocal(this.manager, ref, folder, match);
            return Objects.nonNull(match) ? match : location;
        }
        this.logWarn("Unable to load track from file at `{}` for audio `{}` since the local folder does not exist!", location, ref.getName());
        return location;
    }

    @Override
    public String loadRemoteTrack(AudioRef ref, String location) {
        this.trackLoader.loadRemote(this.manager, ref, location);
        return location;
    }

    @Override
    public void onResourcesLoaded() {
        if (!this.registeredResourceAudio) {
            this.manager.registerSourceManager(new ResourceAudioSourceManager(this));
            this.registeredResourceAudio = true;
            this.logInfo("Successfully registered resource audio manager", new Object[0]);
            this.logInfo("Finding resource tracks that need loading", new Object[0]);
            this.getData().loadResourceTracks();
        }
    }

    @Override
    public void onTrackStart(AudioTrack track) {
    }

    @Override
    public void onTrackStop(AudioTrackEndReason endReason) {
        this.stopped();
    }

    @Override
    public void play(boolean unpaused) {
        TriggerAPI trigger = this.getActiveTrigger();
        if (trigger.canPlayAudio()) {
            super.play(unpaused);
            this.queued = false;
            AudioPool pool = trigger.getAudioPool();
            if (Objects.nonNull(pool)) {
                if (pool.hasQueue()) {
                    pool.start(trigger, unpaused);
                    this.playingPool = pool;
                } else {
                    pool.queue();
                }
            }
        }
    }

    @Override
    public void playing(boolean unpaused) {
        super.playing(unpaused);
    }

    @Override
    public void queue() {
        super.queue();
        this.queued = true;
    }

    @Override
    public void seek(long ms) {
        AudioTrack curTrack = this.player.getPlayingTrack();
        if (Objects.nonNull(curTrack)) {
            curTrack.setPosition(ms);
        }
    }

    @Override
    public void setCategoryVolume(float volume) {
        if (volume != this.categoryVolume) {
            this.logDebug("Setting category volume to {}%", Float.valueOf(volume * 100.0f));
            this.categoryVolume = volume;
            this.updateVolume();
        }
    }

    @Override
    public void setMasterVolume(float volume) {
        if (volume != this.masterVolume) {
            this.logDebug("Setting master volume to {}%", Float.valueOf(volume * 100.0f));
            this.masterVolume = volume;
            this.updateVolume();
        }
    }

    @Override
    public void setTrackVolume(float volume) {
        if (volume != this.trackVolume) {
            this.trackVolume = volume;
            this.updateVolume();
        }
    }

    @Override
    public boolean showDebugSongInfo() {
        return super.showDebugSongInfo() && Objects.nonNull(this.player.getPlayingTrack());
    }

    @Override
    public boolean shouldBlockMusicTicker() {
        return this.getInfo().isOverridesMusic() || Objects.nonNull(this.playingPool);
    }

    @Override
    public void stopped() {
        this.player.stopCurrentTrack();
        super.stopped();
        this.playingPool = null;
    }

    @Override
    public boolean tick(boolean jukebox, boolean unpaused) {
        if (this.listener.isBroken()) {
            MTClientEvents.handleError(ClientHelper.getMinecraft(), this.getName());
            return false;
        }
        if (this.enabled) {
            unpaused = MTClient.isUnpaused();
            if (this.checkPaused(unpaused) && this.checkFocus() && this.checkJukebox(jukebox)) {
                this.player.setPaused(false);
                unpaused = super.tick(jukebox, unpaused);
            } else {
                this.player.setPaused(true);
            }
            return unpaused || !this.getInfo().hasPausedMusic();
        }
        if (Objects.nonNull(this.playingPool)) {
            this.playing(unpaused);
        }
        return false;
    }

    @Override
    public void tickActive(boolean unpaused) {
        AudioPool activePool;
        super.tickActive(unpaused);
        TriggerAPI trigger = this.getActiveTrigger();
        if (Objects.nonNull(trigger) && Objects.nonNull(activePool = this.getData().getActivePool())) {
            if (Objects.nonNull(this.playingPool)) {
                this.playing(unpaused);
            } else if (!this.deactivating) {
                if (this.queued) {
                    this.play(unpaused);
                } else {
                    this.queue();
                }
            }
        }
    }

    @Override
    public void tickSlow(boolean unpaused) {
        if (this.checkPaused(unpaused)) {
            super.tickSlow(unpaused);
        }
    }

    private void updateVolume() {
        this.player.setVolume((int)(100.0f * this.masterVolume * this.categoryVolume * this.trackVolume));
    }
}

