/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.client.audio;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.format.AudioPlayerInputStream;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.format.StandardAudioDataFormats;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.AudioPlayer;

public class AudioOutput
extends Thread {
    protected final ChannelAPI channel;
    protected boolean runAudioLoop;
    private Runnable onRun;

    public AudioOutput(@Nonnull ChannelAPI channel) {
        super("Music Triggers Audio Output [" + channel.getName() + "]");
        this.channel = channel;
        this.runAudioLoop = true;
        this.onRun = () -> {
            AudioDataFormat format = StandardAudioDataFormats.DISCORD_PCM_S16_BE;
            if (this.runAudioLoop) {
                this.loopRunner(this.channel.getPlayer(), format, format.frameDuration());
            } else {
                try {
                    AudioOutput.sleep(250L);
                    this.runAudioLoop = true;
                }
                catch (InterruptedException ex) {
                    this.channel.logFatal("Unable to restart audio output!", ex);
                    this.onRun = null;
                }
            }
        };
    }

    public void close() {
        this.onRun = null;
    }

    private void loopRunner(AudioPlayer player, AudioDataFormat format, long frameDur) {
        try (AudioInputStream stream = AudioPlayerInputStream.createStream(player, format, frameDur, true);){
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, stream.getFormat());
            SourceDataLine output = (SourceDataLine)AudioSystem.getLine(info);
            int buffersize = format.chunkSampleCount * format.channelCount * 2;
            output.open(stream.getFormat(), buffersize * 5);
            output.start();
            byte[] buffer = new byte[buffersize];
            while (this.runAudioLoop) {
                if (!player.isPaused()) {
                    int chunkSize = stream.read(buffer);
                    if (chunkSize >= 0) {
                        output.write(buffer, 0, chunkSize);
                        continue;
                    }
                    String msg = "Audiostream ended for channel " + this.channel + "! This should not happen!";
                    throw new IllegalStateException(msg);
                }
                output.drain();
                AudioOutput.sleep(frameDur);
            }
        }
        catch (Exception ex) {
            this.channel.logError("An unkown error occured in the audio output thread!", ex);
        }
    }

    public void pauseAudioLoop() {
        this.runAudioLoop = false;
    }

    @Override
    public void run() {
        if (Objects.nonNull(this.onRun)) {
            this.onRun.run();
        }
    }

    public void unpauseAudioLoop() {
        this.runAudioLoop = true;
    }
}

