/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.client.audio;

import com.github.natanbc.lavadsp.rotation.RotationPcmAudioFilter;
import com.github.natanbc.lavadsp.timescale.TimescalePcmAudioFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mods.thecomputerizer.musictriggers.api.data.audio.AudioRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerAPI;
import mods.thecomputerizer.musictriggers.api.network.MTNetwork;
import mods.thecomputerizer.musictriggers.api.network.MessageCurrentSong;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.AudioFilter;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioItem;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;

public class AudioContainer
extends AudioRef {
    private int fade;
    private float fadeFactor;
    private AudioItem item;
    private int playlistIndex;
    private boolean previousPauseStatus;
    private long resumeTime;
    private TriggerAPI fadingTrigger;

    public AudioContainer(ChannelAPI channel, String name) {
        super(channel, name);
    }

    @Override
    public void activate() {
        if (this.fade == 0) {
            this.fadingTrigger = null;
        }
    }

    private void checkFade(int fade, boolean unpaused) {
        if (fade > 0) {
            this.setFade(-fade);
        }
        this.channel.setTrackVolume(this.getVolume(unpaused));
    }

    @Override
    public void close() {
        super.close();
        this.fade = 0;
        this.fadeFactor = 0.0f;
        this.item = null;
        this.playlistIndex = 0;
    }

    protected float getFade() {
        return (float)this.fade * this.fadeFactor;
    }

    @Nullable
    public AudioTrack getTrack() {
        if (this.item instanceof AudioTrack) {
            return ((AudioTrack)this.item).makeClone();
        }
        if (this.item instanceof AudioPlaylist) {
            AudioPlaylist playlist = (AudioPlaylist)this.item;
            if (Objects.nonNull(playlist.getSelectedTrack())) {
                return playlist.getSelectedTrack().makeClone();
            }
            List<AudioTrack> tracks = playlist.getTracks();
            if (Objects.nonNull(tracks) && !tracks.isEmpty()) {
                AudioTrack track = tracks.get(this.playlistIndex);
                ++this.playlistIndex;
                if (this.playlistIndex >= tracks.size()) {
                    this.playlistIndex = 0;
                }
                return track.makeClone();
            }
        }
        return null;
    }

    @Override
    public float getVolume(boolean unpaused) {
        return super.getVolume(unpaused) * (this.fade <= 0 ? 1.0f : (this.fadeFactor <= 0.0f ? 1.0f + this.getFade() : this.getFade()));
    }

    private void handlePaused(boolean unpaused) {
        if (this.previousPauseStatus != unpaused) {
            this.channel.setTrackVolume(this.getVolume(unpaused));
            this.previousPauseStatus = unpaused;
        }
    }

    @Override
    public void loadLocal(String location) {
        this.location = this.channel.loadLocalTrack(this, location);
        this.file = true;
    }

    @Override
    public void loadRemote(String location) {
        this.location = this.channel.loadRemoteTrack(this, location);
        this.file = false;
    }

    @Override
    public void playing(boolean unpaused) {
        if (this.queued) {
            if (this.loaded) {
                this.start(this.channel.getActiveTrigger(), unpaused);
            }
            return;
        }
        if (this.loading || !this.loaded) {
            return;
        }
        if (this.looping) {
            this.looping = false;
        } else {
            for (AudioRef.Loop loop : this.loops) {
                if (!loop.run()) continue;
                this.looping = true;
                break;
            }
        }
        if (this.fade > 0) {
            boolean out;
            boolean bl = out = this.fadeFactor > 0.0f;
            this.fade = this.fadeFactor == 0.0f ? 0 : --this.fade;
            if (out && Objects.nonNull(this.fadingTrigger) && this.fadingTrigger.equals(this.channel.getActiveNonFadingTrigger())) {
                int fade = this.fadingTrigger.getParameterAsInt("fade_in");
                this.setFade(-fade);
            } else if (this.fade == 0) {
                if (out) {
                    this.stopTrackImmediately();
                }
                this.fadeFactor = 0.0f;
            }
            this.channel.setTrackVolume(this.getVolume(unpaused));
        } else {
            this.handlePaused(unpaused);
        }
    }

    @Override
    public void queryInterrupt(@Nullable TriggerAPI next, AudioPlayer player) {
        if (this.fadeFactor > 0.0f) {
            return;
        }
        AudioRef.InterruptHandler handler = this.getInterruptHandler();
        if (Objects.isNull(handler) || handler.isInterrputedBy(next)) {
            this.channel.stop();
        }
    }

    @Override
    public void setFade(int fade) {
        if (fade != 0 && this.fadeFactor != 0.0f) {
            fade = (int)((float)fade * ((float)this.fade / (this.fadeFactor < 0.0f ? -1.0f / this.fadeFactor : 1.0f / this.fadeFactor)));
        }
        this.fadeFactor = 1.0f / (float)fade;
        if (this.fadeFactor == 0.0f) {
            this.fade = 0;
        } else {
            this.fade = Math.abs(fade);
            if (this.fade == 0) {
                this.fadeFactor = 0.0f;
            }
        }
    }

    private List<AudioFilter> setFilters(AudioTrack track, AudioDataFormat format, FloatPcmAudioFilter output) {
        ArrayList<AudioFilter> filters = new ArrayList<AudioFilter>();
        output = this.setTimescale(filters, output, format);
        output = this.setRotation(filters, output, format);
        Collections.reverse(filters);
        return filters;
    }

    @Override
    public void setItem(AudioItem item) {
        this.item = item;
        super.setItem(item);
    }

    private FloatPcmAudioFilter setRotation(List<AudioFilter> filters, FloatPcmAudioFilter output, AudioDataFormat format) {
        double rotationSpeed = this.getParameterAsDouble("rotation_speed");
        if (rotationSpeed != 0.0) {
            output = new RotationPcmAudioFilter(output, format.sampleRate).setRotationSpeed(rotationSpeed);
            filters.add(output);
        }
        return output;
    }

    private FloatPcmAudioFilter setTimescale(List<AudioFilter> filters, FloatPcmAudioFilter output, AudioDataFormat format) {
        boolean needsTimeScale = false;
        double pitch = this.getParameterAsDouble("pitch");
        double speed = this.getSpeed();
        if (pitch != 1.0 && pitch > 0.0) {
            needsTimeScale = true;
        }
        if (speed != 1.0 && speed > 0.0) {
            needsTimeScale = true;
        }
        if (needsTimeScale) {
            output = new TimescalePcmAudioFilter(output, format.channelCount, format.sampleRate).setPitch(pitch).setSpeed(speed);
            filters.add(output);
        }
        return output;
    }

    private void setPosition(AudioTrack track) {
        long position = this.channel.getStartTime();
        if (position == 0L) {
            position = this.resumeTime;
        }
        if (position == 0L) {
            position = this.getParameterAsLong("start_at");
        }
        if (position > 0L) {
            track.setPosition(position);
            this.logDebug("Set track position to {}", position);
        }
    }

    @Override
    public void start(TriggerAPI trigger, boolean unpaused) {
        if (!this.loaded || this.loading) {
            this.logInfo("Queued track will play once it is finished loading", new Object[0]);
            this.queued = true;
            return;
        }
        this.queued = false;
        AudioPlayer player = this.channel.getPlayer();
        if (Objects.isNull(player)) {
            this.logFatal("Cannot play track on missing audio player!", new Object[0]);
            return;
        }
        AudioTrack track = this.getTrack();
        if (Objects.isNull(track)) {
            return;
        }
        track.stop();
        this.checkFade(Objects.nonNull(trigger) && trigger.isFirstTrack() ? trigger.getParameterAsInt("fade_in") : 0, unpaused);
        this.setPosition(track);
        player.setFilterFactory(this::setFilters);
        player.playTrack(track);
        ChannelHelper helper = this.channel.getHelper();
        String channelName = this.getChannelName();
        if (!Misc.equalsAny((Object)channelName, (Object[])new String[]{"jukebox", "preview"}) && helper.isSyncable()) {
            MTNetwork.sendToServer(new MessageCurrentSong(helper, this.channel, this));
        }
    }

    @Override
    public void stop() {
        this.logDebug("Stopping track", new Object[0]);
        TriggerAPI trigger = this.channel.getActiveTrigger();
        if (Objects.nonNull(trigger)) {
            int fade = trigger.getParameterAsInt("fade_out");
            if (fade > 0) {
                this.setFade(fade);
                this.fadingTrigger = trigger;
            } else {
                this.stopTrackImmediately();
            }
        } else {
            this.stopTrackImmediately();
        }
    }

    @Override
    public void stopped() {
        this.loops.forEach(AudioRef.Loop::reset);
    }

    private void stopTrackImmediately() {
        TriggerAPI.Link link;
        TriggerAPI trigger;
        this.fadingTrigger = null;
        long time = this.channel.getPlayingSongTime();
        if (this.shouldSavePosition()) {
            long l = this.resumeTime = time + 50L < this.channel.getPlayingSongTotalTime() ? time : 0L;
        }
        if (Objects.nonNull(trigger = this.channel.getActiveTrigger()) && Objects.nonNull(link = trigger.getActiveLink())) {
            link.setSnapshotInherit(time);
        }
        this.channel.getPlayer().stopCurrentTrack();
        this.looping = false;
    }
}

