/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import mods.thecomputerizer.musictriggers.api.client.MTClientEvents;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.trigger.ResourceContext;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerContext;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerBiome;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerCommand;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerMob;
import mods.thecomputerizer.theimpossiblelibrary.api.client.ClientAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.MinecraftAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.blockentity.BlockEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.container.PlayerInventoryAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.PlayerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemStackAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.integration.BloodmoonAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.integration.ModAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.integration.ModHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.integration.Weather2API;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.util.RandomHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.DimensionAPI;

public class TriggerContextClient
extends TriggerContext {
    private MinecraftAPI<?> minecraft;
    private Object screen;

    public TriggerContextClient(ChannelAPI channel) {
        super(channel, "client_context");
    }

    @Override
    public void cache() {
        this.minecraft = (MinecraftAPI)TILRef.getClientSubAPI(ClientAPI::getMinecraft);
        this.player = Objects.nonNull(this.minecraft) ? this.minecraft.getPlayer() : null;
        this.world = Objects.nonNull(this.minecraft) ? this.minecraft.getWorld() : null;
        this.pos = this.hasPlayer() ? this.player.getPosRounded() : null;
        this.biome = this.hasBoth() ? this.world.getBiomeAt(this.pos) : null;
        try {
            this.screen = Objects.nonNull(this.minecraft) ? this.minecraft.getCurrentScreen() : null;
        }
        catch (Throwable t) {
            this.logFatal("Failed to cache the current screen", t);
            throw t;
        }
    }

    private boolean checkBiomeNameAndType(TriggerBiome trigger) {
        ResourceLocationAPI regName = this.biome.getRegistryName(this.world);
        if (Objects.isNull(regName)) {
            return false;
        }
        ResourceContext ctx = trigger.getResourceCtx();
        if (ctx.checkMatch(regName.toString(), regName.getPath())) {
            return true;
        }
        ctx = trigger.getTagCtx();
        for (String tag : this.biome.getTagNames(this.world)) {
            if (!ctx.checkMatch(tag, null)) continue;
            return true;
        }
        return false;
    }

    private boolean checkBiomeRain(TriggerBiome trigger) {
        String rainType = trigger.getParameterAsString("rain_type").toLowerCase();
        if (!this.biome.canRain(this.world, this.pos)) {
            return rainType.equals("any") || rainType.equals("none");
        }
        if (this.biome.canSnow(this.world, this.pos) && !rainType.equals("snow") && !rainType.equals("any")) {
            return false;
        }
        float rainfall = trigger.getParameterAsFloat("biome_rainfall");
        return trigger.getParameterAsBoolean("rainfall_greater_than") ? this.biome.getRainfall() >= rainfall : this.biome.getRainfall() <= rainfall;
    }

    private boolean checkBiomeExtras(TriggerBiome trigger) {
        if (this.checkBiomeRain(trigger)) {
            float temperature = trigger.getParameterAsFloat("biome_temperature");
            return trigger.getParameterAsBoolean("temperature_greater_than") ? this.biome.getTemperatureAt(this.pos) >= temperature : this.biome.getTemperatureAt(this.pos) <= temperature;
        }
        return false;
    }

    private <M extends ModAPI> boolean checkMod(Supplier<M> modSupplier, Function<M, Boolean> checker) {
        ModAPI mod = (ModAPI)modSupplier.get();
        return Objects.nonNull(mod) && checker.apply(mod) != false;
    }

    @Override
    public void close() {
        super.close();
        this.minecraft = null;
    }

    @Override
    public PlayerAPI<?, ?> getPlayer() {
        return Objects.nonNull(this.minecraft) ? this.minecraft.getPlayer() : null;
    }

    private Collection<ItemStackAPI<?>> getStacksFromSlotMatcher(String slotMatcher) {
        PlayerInventoryAPI inventory = this.player.getInventory();
        switch (slotMatcher.toLowerCase()) {
            case "mainhand": {
                return Collections.singleton(this.player.getMainHandStack());
            }
            case "offhand": {
                return Collections.singleton(this.player.getOffHandStack());
            }
            case "hotbar": {
                return inventory.getHotbarStacks();
            }
            case "armor": {
                return inventory.getArmorStacks();
            }
            case "any": {
                ArrayList stacks = new ArrayList();
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    ItemStackAPI stack = inventory.getStack(i);
                    if (!stack.isNotEmpty()) continue;
                    stacks.add(stack);
                }
                return stacks;
            }
        }
        int slot = RandomHelper.randomInt((String)"inventory_slot_number", (String)slotMatcher, (int)-1);
        return slot >= 0 ? Collections.singleton(inventory.getStack(slot)) : Collections.emptyList();
    }

    @Override
    public boolean isActiveAcidRain() {
        return this.hasWorld() && this.checkMod(ModHelper::betterWeather, mod -> mod.isAcidRaining(this.world));
    }

    @Override
    public boolean isActiveAdvancement(ResourceContext ctx) {
        return MTClientEvents.checkAdvancement(ctx);
    }

    @Override
    public boolean isActiveAdventure() {
        return this.hasPlayer() && this.player.isGamemodeAdventure();
    }

    @Override
    public boolean isActiveBiome(TriggerBiome trigger) {
        return Objects.nonNull(this.biome) && this.checkBiomeNameAndType(trigger) && this.checkBiomeExtras(trigger);
    }

    @Override
    public boolean isActiveBlizzard() {
        return this.hasWorld() && this.checkMod(ModHelper::betterWeather, mod -> mod.isBlizzard(this.world));
    }

    @Override
    public boolean isActiveBlockEntity(ResourceContext ctx, int range, float yRatio) {
        for (BlockEntityAPI<?, ?> block : this.getBlockEntitiesAround(this.getBox(range, yRatio))) {
            ResourceLocationAPI registryName = block.getRegistryName();
            if (!Objects.nonNull(registryName) || !ctx.checkMatch(registryName.toString(), null)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isActiveBloodMoon() {
        return this.hasWorld() && (this.checkMod(ModHelper::bloodmoon, BloodmoonAPI::isBloodMoon) || this.checkMod(ModHelper::nyx, mod -> mod.isBloodMoon(this.world)) || this.checkMod(ModHelper::enhancedCelestials, mod -> mod.isBloodMoon(this.world)));
    }

    @Override
    public boolean isActiveBlueMoon() {
        return this.hasWorld() && this.checkMod(ModHelper::enhancedCelestials, mod -> mod.isBlueMoon(this.world));
    }

    @Override
    public boolean isActiveCloudy() {
        return this.hasWorld() && this.checkMod(ModHelper::betterWeather, mod -> mod.isCloudy(this.world));
    }

    @Override
    public boolean isActiveCommand(TriggerCommand trigger) {
        return false;
    }

    @Override
    public boolean isActiveCreative() {
        return this.hasPlayer() && this.player.isGamemodeCreative();
    }

    @Override
    public boolean isActiveDead() {
        return this.hasPlayer() && !this.player.isAlive();
    }

    @Override
    public boolean isActiveDifficulty(int level) {
        return this.hasWorld() && this.world.getDifficultyOrdinal() == level;
    }

    @Override
    public boolean isActiveDimension(ResourceContext ctx) {
        if (!this.hasBoth()) {
            return false;
        }
        DimensionAPI dimension = this.player.getDimension();
        return ctx.checkMatch(dimension.getRegistryName().toString(), dimension.getName());
    }

    @Override
    public boolean isActiveDrowning(int level) {
        return this.hasPlayer() && this.player.getAir() < level;
    }

    @Override
    public boolean isActiveEffect(ResourceContext ctx) {
        return false;
    }

    @Override
    public boolean isActiveElytra() {
        return this.hasPlayer() && this.player.isFlying();
    }

    @Override
    public boolean isActiveStarShower() {
        return this.hasWorld() && this.checkMod(ModHelper::nyx, mod -> mod.isStarShower(this.world));
    }

    @Override
    public boolean isActiveFishing() {
        return this.hasPlayer() && this.player.isFishing();
    }

    @Override
    public boolean isActiveGamestage(ResourceContext ctx, boolean whitelist) {
        return this.hasPlayer() && this.checkMod(ModHelper::gameStages, mod -> {
            for (String stage : mod.getStages(this.player)) {
                if (!ctx.checkMatch(stage, null)) continue;
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean isActiveGeneric() {
        return true;
    }

    @Override
    public boolean isActiveGUI(ResourceContext ctx) {
        if (Objects.isNull(this.screen)) {
            return ctx.checkMatch(null, null);
        }
        Class<?> screenClass = this.screen.getClass();
        return ctx.checkMatch(screenClass.getName(), screenClass.getSimpleName());
    }

    @Override
    public boolean isActiveHarvestMoon() {
        return this.hasWorld() && (this.checkMod(ModHelper::nyx, mod -> mod.isHarvestMoon(this.world)) || this.checkMod(ModHelper::enhancedCelestials, mod -> mod.isHarvestMoon(this.world)));
    }

    @Override
    public boolean isActiveHeight(int level, boolean checkSky, boolean checkAbove) {
        BlockPosAPI pos;
        BlockPosAPI blockPosAPI = pos = this.hasBoth() ? this.player.getPosRounded() : null;
        if (Objects.nonNull(pos)) {
            if (checkAbove) {
                return pos.y() > level;
            }
            if (pos.y() < level) {
                if (this.world.isSkyVisible(pos)) {
                    return !checkSky;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isActiveHome(int range, float yRatio) {
        return false;
    }

    @Override
    public boolean isActiveHurricane(int range) {
        return Objects.nonNull(this.pos) && this.checkMod(ModHelper::weather2, mod -> Objects.nonNull(mod.getClosestHurricane(this.world, this.pos, (double)range)));
    }

    @Override
    public boolean isActiveInventory(List<String> items, List<String> slots) {
        if (items.isEmpty() || slots.isEmpty() || !this.hasPlayer()) {
            return false;
        }
        for (String slot : slots) {
            for (ItemStackAPI<?> stack : this.getStacksFromSlotMatcher(slot)) {
                for (String item : items) {
                    if (!this.isActiveItem(stack, item)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isActiveItem(ItemStackAPI<?> stack, String itemString) {
        String[] parts = itemString.split(":");
        if (parts.length == 0) {
            return false;
        }
        if (parts.length == 1) {
            return parts[0].equals("empty") && stack.isEmpty();
        }
        ResourceLocationAPI itemName = stack.getItem().getRegistryName();
        if (parts[0].equals(itemName.getNamespace()) && parts[1].equals(itemName.getPath())) {
            if (parts.length == 2) {
                return true;
            }
            if (stack.getCount() <= RandomHelper.randomInt((String)"parsed_item_count", (String)parts[2], (int)-1)) {
                return parts.length == 3 || this.checkNBT(stack.getTag(), itemString);
            }
        }
        return false;
    }

    @Override
    public boolean isActiveLight(int level, String type) {
        if (!this.hasBoth()) {
            return false;
        }
        switch (type.toLowerCase()) {
            case "block": {
                return this.world.getLightBlock(this.pos) <= level;
            }
            case "sky": {
                return this.world.getLightSky(this.pos) <= level;
            }
        }
        return this.world.getLightTotal(this.pos) <= level;
    }

    @Override
    public boolean isActiveLightRain() {
        return this.hasWorld() && this.checkMod(ModHelper::betterWeather, mod -> mod.isRaining(this.world));
    }

    @Override
    public boolean isActiveLoading() {
        return Objects.isNull(this.minecraft) || this.minecraft.isLoading();
    }

    @Override
    public boolean isActiveLowHP(float minPercent, float maxPercent) {
        if (!this.hasPlayer()) {
            return false;
        }
        float percent = this.player.getHealthPercent();
        return percent >= minPercent && percent < maxPercent;
    }

    @Override
    public boolean isActiveMenu() {
        return Objects.nonNull(this.minecraft) && this.minecraft.isFinishedLoading() && !this.hasBoth();
    }

    @Override
    public boolean isActiveMob(TriggerMob trigger) {
        return false;
    }

    @Override
    public boolean isActiveMoon(ResourceContext ctx) {
        return this.hasWorld() && this.checkMod(ModHelper::enhancedCelestials, mod -> mod.isMoon(this.world));
    }

    @Override
    public boolean isActivePet(int range, float yRatio) {
        for (EntityAPI<?, ?> entity : this.getEntitiesAround(this.getBox(range, yRatio))) {
            if (!entity.isOwnedBy((EntityAPI)this.player)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isActivePVP() {
        return false;
    }

    @Override
    public boolean isActiveRaid(List<?> statusChecks, int wave) {
        return false;
    }

    @Override
    public boolean isActiveRaining() {
        return this.hasWorld() && this.world.isRaining();
    }

    @Override
    public boolean isActiveRainIntensity(float level) {
        return this.hasWorld() && this.checkMod(ModHelper::dynamicSurroundings, mod -> mod.getRainStrength(this.world) > level);
    }

    @Override
    public boolean isActiveRiding(ResourceContext ctx) {
        if (!this.hasPlayer()) {
            return false;
        }
        EntityAPI entity = this.player.getVehicle();
        return Objects.nonNull(entity) && ctx.checkMatch(entity.getRegistryName().toString(), entity.getName());
    }

    @Override
    public boolean isActiveSandstorm(int range) {
        return Objects.nonNull(this.pos) && this.hasWorld() && this.checkMod(ModHelper::weather2, mod -> Objects.nonNull(mod.getClosestSandStorm(this.world, this.pos, (double)range)));
    }

    @Override
    public boolean isActiveSeason(int level) {
        return this.hasWorld() && this.checkMod(ModHelper::sereneSeasons, mod -> {
            switch (level) {
                case 0: {
                    return mod.isSpring(this.world);
                }
                case 1: {
                    return mod.isSummer(this.world);
                }
                case 2: {
                    return mod.isAutumn(this.world);
                }
                case 3: {
                    return mod.isWinter(this.world);
                }
            }
            return false;
        });
    }

    @Override
    public boolean isActiveSnowing() {
        return Objects.nonNull(this.pos) && Objects.nonNull(this.world) && this.world.isSnowingAt(this.pos);
    }

    @Override
    public boolean isActiveSpectator() {
        return this.hasPlayer() && this.player.isGamemodeSpectator();
    }

    @Override
    public boolean isActiveStatistic(ResourceContext ctx, int level) {
        return false;
    }

    @Override
    public boolean isActiveStorming() {
        return this.hasWorld() && this.world.isStorming();
    }

    @Override
    public boolean isActiveStructure(ResourceContext ctx) {
        return false;
    }

    @Override
    public boolean isActiveTime(String bundle, float startHour, float endHour, int startDay, int endDay, int moonPhase) {
        if (!this.hasWorld() || !this.isActiveTimeExtras(startDay, endDay, moonPhase)) {
            return false;
        }
        switch (bundle.toLowerCase()) {
            case "day": {
                return this.world.isDaytime();
            }
            case "night": {
                return this.world.isNighttime();
            }
            case "sunrise": {
                return this.world.isSunrise();
            }
            case "sunset": {
                return this.world.isSunset();
            }
        }
        if (startHour == endHour) {
            return true;
        }
        float time = (float)this.world.getTimeDay() / 1000.0f;
        return startHour < endHour ? time >= startHour && time < endHour : time >= startHour || time < endHour;
    }

    private boolean isActiveTimeExtras(int startDay, int endDay, int moonPhase) {
        int day = this.world.getDayNumber();
        return day >= startDay && day <= endDay && (moonPhase == 0 || moonPhase == this.world.getMoonPhase() + 1);
    }

    @Override
    public boolean isActiveTornado(int range, int level) {
        return Objects.nonNull(this.pos) && this.hasWorld() && this.checkMod(ModHelper::weather2, mod -> {
            Weather2API.WeatherData data = mod.getClosestTornado(this.world, this.pos, (double)range);
            return Objects.nonNull(data) && data.getLevel() >= level;
        });
    }

    @Override
    public boolean isActiveUnderwater() {
        return Objects.nonNull(this.pos) && this.hasWorld() && this.world.isUnderwater(this.pos);
    }

    @Override
    public boolean isActiveVictory(int timeout) {
        return false;
    }

    @Override
    public boolean isActiveZones(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return this.hasPlayer() && new Box((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).isInside(this.player.getPosRounded());
    }

    @Override
    public boolean isClient() {
        return true;
    }
}

