/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.lava.common.natives;

import java.util.concurrent.atomic.AtomicBoolean;
import mods.thecomputerizer.shadow.org.slf4j.Logger;
import mods.thecomputerizer.shadow.org.slf4j.LoggerFactory;

public abstract class NativeResourceHolder {
    private static final Logger log = LoggerFactory.getLogger(NativeResourceHolder.class);
    private final AtomicBoolean released = new AtomicBoolean();

    protected void checkNotReleased() {
        if (this.released.get()) {
            throw new IllegalStateException("Cannot use the decoder after closing it.");
        }
    }

    public void close() {
        this.closeInternal(false);
    }

    protected abstract void freeResources();

    private synchronized void closeInternal(boolean inFinalizer) {
        if (this.released.compareAndSet(false, true)) {
            if (inFinalizer) {
                log.warn("Should have been closed before finalization ({}).", (Object)this.getClass().getName());
            }
            this.freeResources();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.closeInternal(true);
    }
}

