/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.nativeloader.system;

import com.github.natanbc.nativeloader.system.OperatingSystemType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import mods.thecomputerizer.shadow.org.slf4j.Logger;
import mods.thecomputerizer.shadow.org.slf4j.LoggerFactory;

public enum DefaultOperatingSystemTypes implements OperatingSystemType
{
    LINUX("linux", "lib", ".so"),
    LINUX_MUSL("linux-musl", "lib", ".so"),
    WINDOWS("win", "", ".dll"),
    DARWIN("darwin", "lib", ".dylib"),
    SOLARIS("solaris", "lib", ".so"),
    FREEBSD("freebsd", "lib", ".so");

    private static final Logger log;
    private static volatile Boolean cachedMusl;
    private final String identifier;
    private final String libraryFilePrefix;
    private final String libraryFileSuffix;

    private DefaultOperatingSystemTypes(String identifier, String libraryFilePrefix, String libraryFileSuffix) {
        this.identifier = identifier;
        this.libraryFilePrefix = libraryFilePrefix;
        this.libraryFileSuffix = libraryFileSuffix;
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public String libraryFilePrefix() {
        return this.libraryFilePrefix;
    }

    @Override
    public String libraryFileSuffix() {
        return this.libraryFileSuffix;
    }

    public static OperatingSystemType detect() {
        String osFullName = System.getProperty("os.name");
        if (osFullName.startsWith("Windows")) {
            return WINDOWS;
        }
        if (osFullName.startsWith("Mac OS X")) {
            return DARWIN;
        }
        if (osFullName.startsWith("Solaris")) {
            return SOLARIS;
        }
        if (osFullName.toLowerCase().startsWith("linux")) {
            return DefaultOperatingSystemTypes.checkMusl() ? LINUX_MUSL : LINUX;
        }
        if (osFullName.startsWith("FreeBSD")) {
            return FREEBSD;
        }
        throw new IllegalArgumentException("Unknown operating system: " + osFullName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkMusl() {
        Boolean b = cachedMusl;
        if (b != null) return b;
        Class<DefaultOperatingSystemTypes> clazz = DefaultOperatingSystemTypes.class;
        synchronized (DefaultOperatingSystemTypes.class) {
            boolean check;
            try {
                Process p = new ProcessBuilder("ldd", "--version").start();
                log.debug("Exit code: {}", (Object)p.waitFor());
                String line = new BufferedReader(new InputStreamReader(p.getInputStream())).readLine();
                log.debug("First line of stdout: {}", (Object)line);
                if (line == null) {
                    line = new BufferedReader(new InputStreamReader(p.getErrorStream())).readLine();
                    log.debug("First line of stderr: {}", (Object)line);
                }
                check = line != null && line.toLowerCase().startsWith("musl");
            }
            catch (IOException | InterruptedException fail) {
                log.error("Failed to detect libc type, assuming glibc", fail);
                check = false;
            }
            log.debug("is musl: {}", (Object)check);
            b = cachedMusl = Boolean.valueOf(check);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return b;
        }
    }

    static {
        log = LoggerFactory.getLogger(DefaultOperatingSystemTypes.class);
    }
}

