/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.nativeloader;

import com.github.natanbc.nativeloader.system.SystemType;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@FunctionalInterface
public interface LibraryBinaryLoader {
    @Nullable
    public InputStream loadLibrary(@Nonnull SystemType var1, @Nonnull String var2) throws IOException;

    @Nonnull
    public static LibraryBinaryLoader fromResources() {
        return LibraryBinaryLoader.fromResources(LibraryBinaryLoader.class, "/natives/");
    }

    @Nonnull
    public static LibraryBinaryLoader fromResources(@Nonnull String root) {
        return LibraryBinaryLoader.fromResources(LibraryBinaryLoader.class, root);
    }

    @Nonnull
    public static LibraryBinaryLoader fromResources(@Nonnull Class<?> owner) {
        return LibraryBinaryLoader.fromResources(owner, "/natives/");
    }

    @Nonnull
    public static LibraryBinaryLoader fromResources(@Nonnull Class<?> owner, @Nonnull String root) {
        return (system, name) -> {
            String resourcePath = root + system.formatSystemName() + "/" + system.formatLibraryName(name);
            return owner.getResourceAsStream(resourcePath);
        };
    }

    @Nonnull
    public static LibraryBinaryLoader fromPath(@Nonnull Path path) {
        return (system, name) -> {
            String resourcePath = system.formatSystemName() + "/" + system.formatLibraryName(name);
            return new FileInputStream(path.resolve(resourcePath).normalize().toFile());
        };
    }
}

