/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.lavadsp.util;

import com.github.natanbc.lavadsp.util.ScalarFunctions;
import java.util.ArrayList;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.ShortPcmAudioFilter;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.SplitShortPcmAudioFilter;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.UniversalPcmAudioFilter;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.converter.ToFloatAudioFilter;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.converter.ToShortAudioFilter;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.converter.ToSplitShortAudioFilter;

public class VectorSupport {
    private static final FilterFunctions FUNCTIONS = VectorSupport.findImplementation();

    public static UniversalPcmAudioFilter makeUniversal(SplitShortPcmAudioFilter filter, int channelCount) {
        return FUNCTIONS.makeUniversal(filter, channelCount);
    }

    public static UniversalPcmAudioFilter makeUniversal(FloatPcmAudioFilter filter, int channelCount) {
        return FUNCTIONS.makeUniversal(filter, channelCount);
    }

    public static UniversalPcmAudioFilter makeUniversal(ShortPcmAudioFilter filter, int channelCount) {
        return FUNCTIONS.makeUniversal(filter, channelCount);
    }

    public static void channelMix(float[] left, float[] right, int offset, int length, float ltl, float ltr, float rtl, float rtr) {
        FUNCTIONS.channelMix(left, right, offset, length, ltl, ltr, rtl, rtr);
    }

    public static double rotation(float[] left, float[] right, int offset, int length, double x, double dI) {
        return FUNCTIONS.rotation(left, right, offset, length, x, dI);
    }

    public static float tremolo(float[] array, int offset, int length, int sampleRate, float frequency, float depth, float phase) {
        return FUNCTIONS.tremolo(array, offset, length, sampleRate, frequency, depth, phase);
    }

    public static void volume(float[] array, int offset, int length, float volume) {
        FUNCTIONS.volume(array, offset, length, volume);
    }

    private static FilterFunctions findImplementation() {
        ArrayList<String> names = new ArrayList<String>();
        if (System.getProperty("lavadsp.vectorimpl") != null) {
            names.add(System.getProperty("lavadsp.vectorimpl"));
        }
        names.add(ScalarFunctions.class.getName().replace("ScalarFunctions", "VectorFunctions"));
        for (String s : names) {
            FilterFunctions ff = VectorSupport.tryCreating(s);
            if (ff == null) continue;
            return ff;
        }
        return new ScalarFunctions();
    }

    private static FilterFunctions tryCreating(String className) {
        Class<?> klass;
        try {
            klass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        if (!FilterFunctions.class.isAssignableFrom(klass)) {
            throw new IllegalArgumentException("Class " + klass.getName() + " is not a subtype of FilterFunctions");
        }
        try {
            return klass.asSubclass(FilterFunctions.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    public static interface FilterFunctions {
        default public UniversalPcmAudioFilter makeUniversal(SplitShortPcmAudioFilter filter, int channelCount) {
            return new ToSplitShortAudioFilter(filter, channelCount);
        }

        default public UniversalPcmAudioFilter makeUniversal(FloatPcmAudioFilter filter, int channelCount) {
            return new ToFloatAudioFilter(filter, channelCount);
        }

        default public UniversalPcmAudioFilter makeUniversal(ShortPcmAudioFilter filter, int channelCount) {
            return new ToShortAudioFilter(filter, channelCount);
        }

        default public void channelMix(float[] left, float[] right, int offset, int length, float ltl, float ltr, float rtl, float rtr) {
            for (int i = 0; i < length; ++i) {
                float l = left[offset + i];
                float r = right[offset + i];
                left[offset + i] = Math.max(-1.0f, Math.min(1.0f, ltl * l + rtl * r));
                right[offset + i] = Math.max(-1.0f, Math.min(1.0f, ltr * l + rtr * r));
            }
        }

        default public double rotation(float[] left, float[] right, int offset, int length, double x, double dI) {
            for (int i = 0; i < length; ++i) {
                double sin = Math.sin(x);
                left[offset + i] = left[offset + i] * (float)(sin + 1.0) / 2.0f;
                right[offset + i] = right[offset + i] * (float)(-sin + 1.0) / 2.0f;
                x += dI;
            }
            return x;
        }

        default public float tremolo(float[] array, int offset, int length, int sampleRate, float frequency, float depth, float phase) {
            for (int i = 0; i < length; ++i) {
                float fOffset = 1.0f - depth;
                float modSignal = fOffset + depth * (float)Math.sin(phase);
                phase = (float)((double)phase + Math.PI * 2 / (double)sampleRate * (double)frequency);
                array[offset + i] = modSignal * array[offset + i];
            }
            return phase;
        }

        default public void volume(float[] array, int offset, int length, float volume) {
            float multiplier = volume <= 1.5f ? (float)(Math.tan(volume * 0.79f) * 10000.0) : 24612.0f * (volume * 100.0f) / 150.0f;
            for (int i = 0; i < length; ++i) {
                array[offset + i] = Math.max(-1.0f, Math.min(1.0f, array[offset + i] * multiplier / 10000.0f));
            }
        }
    }
}

