/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.lavadsp.util;

import com.github.natanbc.lavadsp.util.VectorSupport;
import java.util.ArrayList;
import java.util.List;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.AudioFilter;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.AudioFilterChain;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.ShortPcmAudioFilter;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.SplitShortPcmAudioFilter;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.UniversalPcmAudioFilter;

public class FilterChainBuilder {
    private final List<AudioFilter> filters = new ArrayList<AudioFilter>();

    public void addFirst(AudioFilter filter) {
        this.filters.add(filter);
    }

    public AudioFilter first() {
        return this.filters.get(this.filters.size() - 1);
    }

    public FloatPcmAudioFilter makeFirstFloat(int channelCount) {
        AudioFilter first = this.first();
        if (first instanceof FloatPcmAudioFilter) {
            return (FloatPcmAudioFilter)first;
        }
        return this.prependUniversalFilter(first, channelCount);
    }

    public UniversalPcmAudioFilter makeFirstUniversal(int channelCount) {
        AudioFilter first = this.first();
        if (first instanceof UniversalPcmAudioFilter) {
            return (UniversalPcmAudioFilter)first;
        }
        return this.prependUniversalFilter(first, channelCount);
    }

    public AudioFilterChain build(Object context, int channelCount) {
        UniversalPcmAudioFilter firstFilter = this.makeFirstUniversal(channelCount);
        return new AudioFilterChain(firstFilter, this.filters, context);
    }

    private UniversalPcmAudioFilter prependUniversalFilter(AudioFilter first, int channelCount) {
        UniversalPcmAudioFilter universalInput;
        if (first instanceof SplitShortPcmAudioFilter) {
            universalInput = VectorSupport.makeUniversal((SplitShortPcmAudioFilter)first, channelCount);
        } else if (first instanceof FloatPcmAudioFilter) {
            universalInput = VectorSupport.makeUniversal((FloatPcmAudioFilter)first, channelCount);
        } else if (first instanceof ShortPcmAudioFilter) {
            universalInput = VectorSupport.makeUniversal((ShortPcmAudioFilter)first, channelCount);
        } else {
            throw new RuntimeException("Filter must implement at least one data type.");
        }
        this.addFirst(universalInput);
        return universalInput;
    }
}

