/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.lavadsp.rotation;

import com.github.natanbc.lavadsp.util.DoubleToDoubleFunction;
import com.github.natanbc.lavadsp.util.VectorSupport;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;

public class RotationPcmAudioFilter
implements FloatPcmAudioFilter {
    private final FloatPcmAudioFilter downstream;
    private final int sampleRate;
    private double rotationHz;
    private double x;
    private double dI;

    public RotationPcmAudioFilter(FloatPcmAudioFilter downstream, int sampleRate) {
        this.downstream = downstream;
        this.sampleRate = sampleRate;
        this.setRotationSpeed(5.0);
    }

    public double getRotationHz() {
        return this.rotationHz;
    }

    public RotationPcmAudioFilter setRotationSpeed(double rotationHz) {
        this.rotationHz = rotationHz;
        double samplesPerCycle = (double)this.sampleRate / (rotationHz * 2.0 * Math.PI);
        this.dI = rotationHz == 0.0 ? 0.0 : 1.0 / samplesPerCycle;
        return this;
    }

    public RotationPcmAudioFilter updateRotationSpeed(DoubleToDoubleFunction function) {
        return this.setRotationSpeed(function.apply(this.rotationHz));
    }

    @Override
    public void process(float[][] input, int offset, int length) throws InterruptedException {
        if (input.length != 2) {
            this.downstream.process(input, offset, length);
            return;
        }
        float[] left = input[0];
        float[] right = input[1];
        this.x = VectorSupport.rotation(left, right, offset, length, this.x, this.dI);
        this.downstream.process(input, offset, length);
    }

    @Override
    public void seekPerformed(long requestedTime, long providedTime) {
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

