/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.lavadsp.natives;

import com.github.natanbc.lavadsp.natives.TimescaleLibrary;
import com.github.natanbc.nativeloader.NativeLibLoader;
import com.github.natanbc.nativeloader.feature.X86Feature;

public class TimescaleNativeLibLoader {
    private static final NativeLibLoader LOADER = NativeLibLoader.create(TimescaleNativeLibLoader.class, "timescale").withFeature(X86Feature.AVX2);
    private static volatile boolean loaded = false;
    private static volatile String soundTouchVersion;
    private static volatile int soundTouchVersionID;
    private static volatile boolean criticalNativesAvailable;

    public static void loadTimescaleLibrary() {
        if (loaded) {
            return;
        }
        LOADER.load();
        soundTouchVersion = TimescaleLibrary.soundTouchVersion();
        soundTouchVersionID = TimescaleLibrary.soundTouchVersionID();
        criticalNativesAvailable = TimescaleLibrary.criticalMethodsAvailable();
        loaded = true;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static String getSoundTouchVersion() {
        TimescaleNativeLibLoader.loadTimescaleLibrary();
        return soundTouchVersion;
    }

    public static int getSoundTouchVersionID() {
        TimescaleNativeLibLoader.loadTimescaleLibrary();
        return soundTouchVersionID;
    }

    public static boolean areCriticalNativesAvailable() {
        TimescaleNativeLibLoader.loadTimescaleLibrary();
        return criticalNativesAvailable;
    }
}

