/*
 * Decompiled with CFR 0.152.
 */
package co.basin.betterbosses.item;

import co.basin.betterbosses.Config;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.registries.ForgeRegistries;

public class LootBagItem
extends Item {
    public LootBagItem(Item.Properties properties) {
        super(properties);
    }

    public static void setBoss(ItemStack stack, LivingEntity livingEntity) {
        String encodeId = livingEntity.m_20078_();
        stack.m_41784_().m_128359_("mob", encodeId != null ? encodeId : "");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        CompoundTag nbt = itemStack.m_41784_();
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(nbt.m_128461_("mob")));
        if (entityType == null) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        if (!level.m_5776_()) {
            LivingEntity livingEntity = (LivingEntity)entityType.m_20615_(level);
            ServerLevel serverLevel = (ServerLevel)level;
            Inventory inventory = player.m_150109_();
            for (ItemStack lootStack : this.createLoot(player, livingEntity, serverLevel)) {
                inventory.m_150079_(lootStack);
            }
        }
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
    }

    private ObjectArrayList<ItemStack> createLoot(Player player, LivingEntity livingEntity, ServerLevel serverLevel) {
        if (livingEntity instanceof WitherBoss) {
            return ObjectArrayList.of((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42686_)});
        }
        ResourceLocation resourcelocation = livingEntity.m_5743_();
        LootTable loottable = serverLevel.m_7654_().m_278653_().m_278676_(resourcelocation);
        LootParams.Builder lootparams$builder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81455_, (Object)livingEntity).m_287286_(LootContextParams.f_81457_, (Object)serverLevel.m_269111_().m_269264_()).m_287286_(LootContextParams.f_81460_, (Object)player.m_20182_());
        return loottable.m_287214_(lootparams$builder.m_287235_(LootContextParamSets.f_81415_), livingEntity.m_287233_());
    }

    public Component m_7626_(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt == null) {
            return super.m_7626_(itemStack);
        }
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(nbt.m_128461_("mob")));
        if (entityType == null) {
            return super.m_7626_(itemStack);
        }
        return entityType.m_20676_().m_6881_().m_130946_(" ").m_7220_((Component)Component.m_237115_((String)this.m_5671_(itemStack)));
    }

    public int getColor(ItemStack itemStack, int tintIndex) {
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt == null) {
            return -1;
        }
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(nbt.m_128461_("mob")));
        Tuple<Integer, Integer> colors = Config.lootBagTints.get(entityType);
        if (colors == null) {
            return -1;
        }
        return (Integer)(tintIndex == 0 ? colors.m_14418_() : colors.m_14419_());
    }
}

