/*
 * Decompiled with CFR 0.152.
 */
package co.basin.betterbosses;

import co.basin.betterbosses.Config;
import co.basin.betterbosses.item.LootBagItem;
import co.basin.betterbosses.item.ModItems;
import com.mojang.logging.LogUtils;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="multiplayerbosses")
public class MultiplayerBosses {
    public static final String MODID = "multiplayerbosses";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String MULTIPLIER_TAG_KEY = "lhmulti";

    public MultiplayerBosses() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.ITEMS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Multiplayer Bosses Initiated");
    }

    @SubscribeEvent
    public void onLivingSpawn(EntityJoinLevelEvent event) {
        if (!Config.shouldScaleBossHealth) {
            return;
        }
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity2;
        if (!MultiplayerBosses.isBoss(livingEntity)) {
            return;
        }
        double playerCount = event.getLevel().m_6907_().size();
        if (Config.useProximityScaling) {
            Vec3 entityPosition = livingEntity.m_20182_();
            AABB range = new AABB(entityPosition.f_82479_ - (double)Config.proximityScalingRange, entityPosition.f_82480_ - (double)Config.proximityScalingRange, entityPosition.f_82481_ - (double)Config.proximityScalingRange, entityPosition.f_82479_ + (double)Config.proximityScalingRange, entityPosition.f_82480_ + (double)Config.proximityScalingRange, entityPosition.f_82481_ + (double)Config.proximityScalingRange);
            playerCount = event.getLevel().m_6249_((Entity)livingEntity, range, entity -> entity instanceof Player).stream().filter(entity -> entityPosition.m_82554_(entity.m_20182_()) <= (double)Config.proximityScalingRange).collect(Collectors.toSet()).size();
            livingEntity.getPersistentData().m_128405_(MULTIPLIER_TAG_KEY, (int)playerCount);
        }
        if (Config.flatHealthMultiplier > 0.0) {
            playerCount = Config.flatHealthMultiplier;
        }
        if (playerCount <= 1.0) {
            return;
        }
        double scalar = (playerCount - 1.0) * Config.multiplierPerPlayer;
        AttributeInstance maxHealthAttribute = livingEntity.m_21051_(Attributes.f_22276_);
        if (maxHealthAttribute == null) {
            LOGGER.error("{} has no max health attribute, skipping entity", (Object)event.getEntity().m_7755_());
            return;
        }
        AttributeModifier attributeModifier = new AttributeModifier("playerCountScalar", scalar, AttributeModifier.Operation.MULTIPLY_BASE);
        if (!maxHealthAttribute.m_22109_(attributeModifier)) {
            maxHealthAttribute.m_22125_(new AttributeModifier("playerCountScalar", scalar, AttributeModifier.Operation.MULTIPLY_BASE));
            livingEntity.m_21153_(livingEntity.m_21233_());
        }
    }

    @SubscribeEvent
    public void onLivingDrop(LivingDropsEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (!MultiplayerBosses.isBoss(event.getEntity())) {
            return;
        }
        if (!Config.shouldScaleBossDrops) {
            return;
        }
        MinecraftServer server = event.getEntity().m_20194_();
        if (server == null) {
            return;
        }
        int playerCount = server.m_7416_();
        if (Config.useProximityScaling) {
            playerCount = event.getEntity().getPersistentData().m_128451_(MULTIPLIER_TAG_KEY);
        }
        if (Config.flatDropsMultiplier > 0) {
            playerCount = Config.flatDropsMultiplier;
        }
        if (playerCount <= 1) {
            return;
        }
        event.setCanceled(true);
        ServerLevel serverLevel = (ServerLevel)event.getEntity().m_9236_();
        for (int i = 0; i < playerCount; ++i) {
            if (Config.shouldDropLootBags) {
                this.createLootBag(event.getEntity());
                continue;
            }
            MultiplayerBosses.createLoot(event.getEntity(), event.getSource(), serverLevel);
        }
    }

    private void createLootBag(LivingEntity livingEntity) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.LOOTBAG.get());
        LootBagItem.setBoss(stack, livingEntity);
        ItemEntity itementity = livingEntity.m_19983_(stack);
        if (itementity != null) {
            itementity.m_32064_();
        }
    }

    private static void createLoot(LivingEntity livingEntity, DamageSource damageSource, ServerLevel serverLevel) {
        if (livingEntity instanceof WitherBoss) {
            ItemEntity itementity = livingEntity.m_19998_((ItemLike)Items.f_42686_);
            if (itementity != null) {
                itementity.m_32064_();
            }
            return;
        }
        ResourceLocation resourcelocation = livingEntity.m_5743_();
        LootTable loottable = serverLevel.m_7654_().m_278653_().m_278676_(resourcelocation);
        loottable.m_287276_(MultiplayerBosses.createLootParameters(livingEntity, damageSource, serverLevel), livingEntity.m_287233_(), arg_0 -> ((LivingEntity)livingEntity).m_19983_(arg_0));
    }

    private static LootParams createLootParameters(LivingEntity livingEntity, DamageSource damageSource, ServerLevel serverLevel) {
        LootParams.Builder lootparams$builder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81455_, (Object)livingEntity).m_287286_(LootContextParams.f_81460_, (Object)livingEntity.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)damageSource).m_287289_(LootContextParams.f_81458_, (Object)damageSource.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)damageSource.m_7640_());
        return lootparams$builder.m_287235_(LootContextParamSets.f_81415_);
    }

    private static boolean isBoss(LivingEntity entity) {
        if (Config.shouldUseForgeTags && entity.m_19880_().contains("forge:bosses")) {
            return true;
        }
        return Config.bosses.contains(entity.m_6095_());
    }

    public static void logInfo(String info) {
        LOGGER.info(info);
    }
}

