/*
 * Decompiled with CFR 0.152.
 */
package com.github.darkpred.morehitboxes.mixin;

import com.github.darkpred.morehitboxes.api.MultiPart;
import com.github.darkpred.morehitboxes.api.MultiPartEntity;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraftforge.entity.PartEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Mob.class})
public abstract class MobMixin
extends LivingEntity {
    protected MobMixin(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
    }

    @Inject(method={"aiStep"}, at={@At(value="RETURN")})
    public void tickCustomParts(CallbackInfo ci) {
        Object object = this;
        if (object instanceof MultiPartEntity) {
            MultiPartEntity multiPartEntity = (MultiPartEntity)object;
            for (MultiPart multiPart : multiPartEntity.getEntityHitboxData().getCustomParts()) {
                multiPart.updatePosition();
            }
            multiPartEntity.getEntityHitboxData().getAnchorData().updatePositions();
        }
    }

    public PartEntity<?>[] getParts() {
        MobMixin mobMixin = this;
        if (mobMixin instanceof MultiPartEntity) {
            MultiPartEntity multiPartEntity = (MultiPartEntity)((Object)mobMixin);
            List parts = multiPartEntity.getEntityHitboxData().getCustomParts();
            PartEntity[] ret = new PartEntity[parts.size()];
            for (int i = 0; i < parts.size(); ++i) {
                ret[i] = (PartEntity)parts.get(i).getEntity();
            }
            return ret;
        }
        return super.getParts();
    }

    public boolean isMultipartEntity() {
        MobMixin mobMixin = this;
        if (mobMixin instanceof MultiPartEntity) {
            MultiPartEntity multiPartEntity = (MultiPartEntity)((Object)mobMixin);
            return multiPartEntity.getEntityHitboxData().hasCustomParts();
        }
        return super.isMultipartEntity();
    }
}

