/*
 * Decompiled with CFR 0.152.
 */
package com.github.darkpred.morehitboxes.internal;

import com.github.darkpred.morehitboxes.api.AnimationOverride;
import com.github.darkpred.morehitboxes.api.HitboxData;
import com.github.darkpred.morehitboxes.api.MultiPart;
import com.github.darkpred.morehitboxes.api.MultiPartEntity;
import com.google.auto.service.AutoService;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ForgeMultiPart<T extends Mob>
extends PartEntity<T>
implements MultiPart<T> {
    private final EntityDimensions size;
    private final Vec3 offset;
    private final String partName;
    @Nullable
    private AnimationOverride animationOverride;

    public ForgeMultiPart(T parent, HitboxData hitboxData) {
        super(parent);
        this.size = EntityDimensions.m_20395_((float)hitboxData.width(), (float)hitboxData.height());
        this.offset = hitboxData.pos();
        this.partName = hitboxData.name();
        this.f_19794_ = true;
        this.m_6210_();
    }

    @NotNull
    public InteractionResult m_6096_(@NotNull Player player, @NotNull InteractionHand hand) {
        return ((Mob)this.getParent()).m_6096_(player, hand);
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        return ((MultiPartEntity)((Mob)this.getParent())).partHurt(this, source, amount);
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        this.m_142467_(reason);
    }

    public boolean m_7306_(@NotNull Entity entity) {
        return this == entity || this.getParent() == entity;
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        if (this.animationOverride != null) {
            return this.size.m_20388_(((Mob)this.getParent()).m_6134_()).m_20390_(this.animationOverride.scaleW(), this.animationOverride.scaleH());
        }
        return this.size.m_20388_(((Mob)this.getParent()).m_6134_());
    }

    @NotNull
    public Entity m_20201_() {
        return ((Mob)this.getParent()).m_20201_();
    }

    public boolean m_142391_() {
        return false;
    }

    @Override
    public String getPartName() {
        return this.partName;
    }

    @Override
    public Entity getEntity() {
        return this;
    }

    @Override
    public Vec3 getOffset() {
        return this.offset;
    }

    @Override
    public void setOverride(AnimationOverride newOverride) {
        if (this.animationOverride != null && (this.animationOverride.scaleH() != newOverride.scaleH() || this.animationOverride.scaleW() != newOverride.scaleW())) {
            this.animationOverride = newOverride;
            this.m_6210_();
        } else {
            this.animationOverride = newOverride;
        }
    }

    @Override
    public AnimationOverride getOverride() {
        return this.animationOverride;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(@NotNull CompoundTag compound) {
    }

    protected void m_7380_(@NotNull CompoundTag compound) {
    }

    @ApiStatus.Internal
    @AutoService(value={MultiPart.Factory.class})
    public static class ForgeMultiPartFactory
    implements MultiPart.Factory {
        @Override
        public <T extends Mob> MultiPart<T> create(T parent, HitboxData hitboxData) {
            return new ForgeMultiPart<T>(parent, hitboxData);
        }
    }
}

