/*
 * Decompiled with CFR 0.152.
 */
package com.github.darkpred.morehitboxes.internal;

import com.github.darkpred.morehitboxes.api.AnchorData;
import com.github.darkpred.morehitboxes.api.AttackBoxData;
import com.github.darkpred.morehitboxes.api.EntityHitboxData;
import com.github.darkpred.morehitboxes.api.HitboxData;
import com.github.darkpred.morehitboxes.api.MultiPart;
import com.github.darkpred.morehitboxes.api.MultiPartEntity;
import com.github.darkpred.morehitboxes.internal.AnchorDataInternal;
import com.github.darkpred.morehitboxes.internal.AttackBoxDataInternal;
import com.github.darkpred.morehitboxes.internal.HitboxDataLoader;
import com.github.darkpred.morehitboxes.platform.Services;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class EntityHitboxDataInternal<T extends Mob>
implements EntityHitboxData<T> {
    private final List<MultiPart<T>> parts = new ObjectArrayList();
    private final Map<String, MultiPart<T>> partsByRef = new Object2ObjectOpenHashMap();
    private final T entity;
    private final AttackBoxData attackBoxData;
    private final AnchorData anchorData;
    private final boolean fixPosOnRefresh;
    private final boolean usesAttackBounds;
    private AABB attackBounds = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private AABB cullingBounds = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private float headRadius;
    private float frustumWidthRadius;
    private float frustumHeight;

    public EntityHitboxDataInternal(T entity, boolean fixPosOnRefresh, boolean usesAttackBounds) {
        this.entity = entity;
        this.attackBoxData = new AttackBoxDataInternal<T>(entity);
        this.anchorData = new AnchorDataInternal<T>(entity);
        this.fixPosOnRefresh = fixPosOnRefresh;
        this.usesAttackBounds = usesAttackBounds;
        List<HitboxData> hitboxData = HitboxDataLoader.HITBOX_DATA.getHitboxes(EntityType.m_20613_((EntityType)entity.m_6095_()));
        if (hitboxData != null && !hitboxData.isEmpty()) {
            this.spawnHitBoxes(hitboxData);
        }
        this.makeAttackBounds();
        this.makeBoundingBoxForCulling();
    }

    private void spawnHitBoxes(List<HitboxData> hitboxesData) {
        float maxFrustumWidthRadius = 0.0f;
        float maxFrustumHeight = 0.0f;
        for (HitboxData hitboxData : hitboxesData) {
            float h;
            if (hitboxData.isAttackBox()) {
                this.attackBoxData.addAttackBox(hitboxData.ref(), hitboxData);
                continue;
            }
            if (hitboxData.isAnchor()) {
                this.anchorData.addAnchor(hitboxData.ref(), hitboxData);
                continue;
            }
            MultiPart<T> part = Services.MULTI_PART.create(this.entity, hitboxData);
            this.parts.add(part);
            if (!hitboxData.ref().isBlank()) {
                this.partsByRef.put(hitboxData.ref(), part);
            }
            float w = hitboxData.getFrustumWidthRadius();
            if (hitboxData.name().contains("head") && (this.headRadius == 0.0f || w > maxFrustumWidthRadius)) {
                this.headRadius = w;
            }
            if (w > maxFrustumWidthRadius) {
                maxFrustumWidthRadius = w;
            }
            if (!((h = hitboxData.getFrustumHeight()) > maxFrustumHeight)) continue;
            maxFrustumHeight = h;
        }
        this.frustumWidthRadius = maxFrustumWidthRadius;
        this.frustumHeight = maxFrustumHeight;
    }

    @Override
    public AttackBoxData getAttackBoxData() {
        return this.attackBoxData;
    }

    @Override
    public AnchorData getAnchorData() {
        return this.anchorData;
    }

    @Override
    public void makeBoundingBoxForCulling() {
        if (this.hasCustomParts()) {
            this.cullingBounds = ((MultiPartEntity)this.entity).makeBoundingBoxForCulling(this.frustumWidthRadius, this.frustumHeight);
        }
    }

    @Override
    public AABB getCullingBounds() {
        return this.cullingBounds;
    }

    @Override
    public void makeAttackBounds() {
        if (!this.usesAttackBounds) {
            return;
        }
        this.attackBounds = ((MultiPartEntity)this.entity).makeAttackBoundingBox(this.getHeadRadius() * this.entity.m_6134_());
    }

    @Override
    public AABB getAttackBounds() {
        return this.attackBounds;
    }

    @Override
    public float getHeadRadius() {
        return this.headRadius;
    }

    @Override
    public boolean hasCustomParts() {
        return !this.parts.isEmpty();
    }

    @Override
    public List<MultiPart<T>> getCustomParts() {
        return this.parts;
    }

    @Override
    @Nullable
    public MultiPart<T> getCustomPart(String ref) {
        return this.partsByRef.get(ref);
    }

    @Override
    public boolean fixPosOnRefresh() {
        return this.fixPosOnRefresh;
    }
}

