/*
 * Decompiled with CFR 0.152.
 */
package com.github.darkpred.morehitboxes.internal;

import com.github.darkpred.morehitboxes.api.AnchorData;
import com.github.darkpred.morehitboxes.api.HitboxData;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class AnchorDataInternal<T extends Mob>
implements AnchorData {
    private final Map<String, HitboxData> anchors = new Object2ObjectOpenHashMap();
    private final Set<String> anchorOverride = new ObjectArraySet();
    private final Map<HitboxData, Vec3> anchorPositions = new Object2ObjectOpenHashMap();
    private final Map<HitboxData, Vec3> anchorPositionBackup = new Object2ObjectOpenHashMap();
    private final T entity;

    public AnchorDataInternal(T entity) {
        this.entity = entity;
    }

    @Override
    public Optional<Vec3> getAnchorPos(String ref) {
        return Optional.ofNullable(this.anchorPositions.get(this.anchors.get(ref)));
    }

    @Override
    public boolean isAnchor(String ref) {
        return this.anchors.containsKey(ref);
    }

    @Override
    public void addAnchor(String ref, HitboxData hitboxData) {
        this.anchors.put(ref, hitboxData);
    }

    @Override
    public void updatePositions() {
        for (Map.Entry<String, HitboxData> entry : this.anchors.entrySet()) {
            if (this.anchorOverride.contains(entry.getKey())) {
                this.anchorOverride.remove(entry.getKey());
                continue;
            }
            Vec3 offset = entry.getValue().pos();
            Vec3 newPos = this.entity.m_20182_().m_82549_(new Vec3(offset.f_82479_, offset.f_82480_, offset.f_82481_).m_82524_(-((Mob)this.entity).f_20883_ * ((float)Math.PI / 180)).m_82490_((double)this.entity.m_6134_()));
            this.anchorPositions.put(entry.getValue(), newPos);
        }
    }

    @Override
    public void updatePosition(String ref, Vec3 localPos) {
        HitboxData hitbox = this.anchors.get(ref);
        Vec3 prevActual = this.anchorPositionBackup.get(hitbox);
        Vec3 pos = this.entity.m_20182_().m_82549_(localPos);
        this.anchorPositionBackup.put(hitbox, pos);
        if (prevActual != null) {
            pos = prevActual.m_82546_(this.anchorPositions.get(hitbox)).m_82553_() > 0.05 ? pos.m_82549_(pos.m_82546_(prevActual).m_82490_(0.5)) : pos.m_82549_(pos.m_82546_(prevActual));
        }
        this.anchorPositions.put(hitbox, pos);
        this.anchorOverride.add(ref);
    }
}

