/*
 * Decompiled with CFR 0.152.
 */
package com.github.darkpred.morehitboxes;

import com.github.darkpred.morehitboxes.ResourcePackRegistry;
import com.google.auto.service.AutoService;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.ApiStatus;

@Mod.EventBusSubscriber(modid="morehitboxes")
@ApiStatus.Internal
@AutoService(value={ResourcePackRegistry.class})
public class ForgeResourcePackRegistry
implements ResourcePackRegistry {
    private static final List<PreparableReloadListener> serverDataReloadListeners = Lists.newArrayList();

    @Override
    public void register(PackType type, PreparableReloadListener listener) {
        if (type == PackType.SERVER_DATA) {
            serverDataReloadListeners.add(listener);
        } else if (type == PackType.CLIENT_RESOURCES) {
            ForgeResourcePackRegistry.registerClient(listener);
        }
    }

    private static void registerClient(PreparableReloadListener listener) {
        if (Minecraft.m_91087_() != null) {
            ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_(listener);
        }
    }

    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        for (PreparableReloadListener listener : serverDataReloadListeners) {
            event.addListener(listener);
        }
    }
}

