/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.monobank;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.monobank.Registry;
import io.github.mortuusars.monobank.config.Configuration;
import io.github.mortuusars.monobank.event.ClientSetup;
import io.github.mortuusars.monobank.event.CommonEvents;
import io.github.mortuusars.monobank.world.VillageStructures;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="monobank")
public class Monobank {
    public static final String ID = "monobank";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final boolean IN_DEBUG = false;

    public Monobank() {
        Configuration.register();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modEventBus.addListener(ClientSetup::init);
            modEventBus.addListener(ClientSetup::registerRenderers);
            modEventBus.addListener(ClientSetup::registerTooltipComponents);
            modEventBus.addListener(ClientSetup::registerModels);
        });
        modEventBus.addListener(CommonEvents::onCommonSetup);
        modEventBus.addListener(CommonEvents::onCreativeTabsBuild);
        Registry.register(modEventBus);
        MinecraftForge.EVENT_BUS.addListener(VillageStructures::addVillageStructures);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static ResourceLocation resource(String path) {
        return new ResourceLocation(ID, path);
    }

    public static int getSlotCapacity() {
        return (Integer)Configuration.MONOBANK_CAPACITY.get();
    }
}

