/*
 * Decompiled with CFR 0.152.
 */
package dev.micle.loginprotection.proxy;

import dev.micle.loginprotection.LoginProtection;
import dev.micle.loginprotection.data.ProtectedPlayer;
import dev.micle.loginprotection.data.ProtectedPlayerManager;
import dev.micle.loginprotection.events.client.OnClientInputEventHandler;
import dev.micle.loginprotection.events.common.OnLivingSetAttackTargetEventHandler;
import dev.micle.loginprotection.events.common.OnPlayerDamageEventHandler;
import dev.micle.loginprotection.events.common.OnPlayerJoinEventHandler;
import dev.micle.loginprotection.events.common.OnPlayerLeaveEventHandler;
import dev.micle.loginprotection.network.NetworkManager;
import dev.micle.loginprotection.proxy.IProxy;
import dev.micle.loginprotection.setup.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class Proxy
implements IProxy {
    private static MinecraftServer server = null;

    public Proxy() {
        Config.init();
        NetworkManager.init();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(Proxy::setup);
        modEventBus.addListener(Proxy::imcEnqueue);
        modEventBus.addListener(Proxy::imcProcess);
        MinecraftForge.EVENT_BUS.addListener(Proxy::onAddReloadListeners);
        MinecraftForge.EVENT_BUS.addListener(Proxy::serverStarted);
        MinecraftForge.EVENT_BUS.addListener(Proxy::serverStopping);
        MinecraftForge.EVENT_BUS.register((Object)new OnLivingSetAttackTargetEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new OnPlayerDamageEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new OnPlayerJoinEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new OnPlayerLeaveEventHandler());
    }

    private static void setup(FMLCommonSetupEvent event) {
    }

    private static void imcEnqueue(InterModEnqueueEvent event) {
    }

    private static void imcProcess(InterModProcessEvent event) {
    }

    private static void onAddReloadListeners(AddReloadListenerEvent event) {
    }

    private static void serverStarted(ServerStartedEvent event) {
        ProtectedPlayerManager.init();
        server = event.getServer();
    }

    private static void serverStopping(ServerStoppingEvent event) {
        server = null;
    }

    @Override
    public MinecraftServer getServer() {
        return server;
    }

    @Override
    public Player getClientPlayer() {
        return null;
    }

    @Override
    public Level getClientWorld() {
        return null;
    }

    public static class Server
    extends Proxy {
        public Server() {
            IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
            modEventBus.addListener(Server::setup);
        }

        private static void setup(FMLDedicatedServerSetupEvent event) {
        }
    }

    public static class Client
    extends Proxy {
        private static ProtectedPlayer.State playerState;
        private static int lastInputTick;

        public Client() {
            IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
            modEventBus.addListener(Client::setup);
            modEventBus.addListener(Client::postSetup);
            MinecraftForge.EVENT_BUS.register((Object)new OnClientInputEventHandler());
        }

        private static void setup(FMLClientSetupEvent event) {
        }

        private static void postSetup(FMLLoadCompleteEvent event) {
        }

        public static ProtectedPlayer.State getPlayerState() {
            return playerState;
        }

        public static void setPlayerState(ProtectedPlayer.State newPlayerState) {
            playerState = newPlayerState;
        }

        public static int getLastInputTick() {
            return lastInputTick;
        }

        public static void updateLastInputTick() {
            lastInputTick = LoginProtection.getProxy().getClientPlayer().f_19797_;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Player getClientPlayer() {
            return Minecraft.m_91087_().f_91074_;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Level getClientWorld() {
            return Minecraft.m_91087_().f_91073_;
        }
    }
}

