/*
 * Decompiled with CFR 0.152.
 */
package dev.micle.loginprotection.network.client;

import dev.micle.loginprotection.data.ProtectedPlayer;
import dev.micle.loginprotection.data.ProtectedPlayerManager;
import dev.micle.loginprotection.proxy.Proxy;
import dev.micle.loginprotection.setup.Config;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class LastInputTickPacket {
    private final int lastInputTick;

    public LastInputTickPacket() {
        this(Proxy.Client.getLastInputTick());
    }

    public LastInputTickPacket(int lastInputTick) {
        this.lastInputTick = lastInputTick;
    }

    public static void encode(LastInputTickPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.lastInputTick);
    }

    public static LastInputTickPacket decode(FriendlyByteBuf buffer) {
        return new LastInputTickPacket(buffer.readInt());
    }

    public static void handle(LastInputTickPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            ProtectedPlayer protectedPlayer = ProtectedPlayerManager.getPlayer(sender.m_20148_());
            if (protectedPlayer == null) {
                return;
            }
            if (sender.f_19797_ - packet.lastInputTick >= (Integer)Config.Server.AFK_TIME_THRESHOLD.get() * 20) {
                ProtectedPlayerManager.updateState(sender.m_20148_());
            } else {
                ProtectedPlayerManager.startAfkTimer(sender.m_20148_(), (long)(((double)((Integer)Config.Server.AFK_TIME_THRESHOLD.get()).intValue() - (double)(sender.f_19797_ - packet.lastInputTick) / 20.0) * 1000.0));
            }
        });
        context.setPacketHandled(true);
    }
}

