/*
 * Decompiled with CFR 0.152.
 */
package dev.micle.loginprotection.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.micle.loginprotection.data.ProtectedPlayer;
import dev.micle.loginprotection.proxy.Proxy;
import dev.micle.loginprotection.setup.Config;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={ForgeGui.class})
public class GuiRenderTickMixin {
    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void onClientTick(GuiGraphics guiGraphics, float partialTick, CallbackInfo ci) {
        if (!((Boolean)Config.Client.GUI_SCREEN_TEXT_ENABLED.get()).booleanValue()) {
            return;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        float guiHalfWidth = (float)Minecraft.m_91087_().m_91268_().m_85445_() / 2.0f;
        float guiHalfHeight = (float)Minecraft.m_91087_().m_91268_().m_85446_() / 2.0f;
        int scale = (Integer)Config.Client.GUI_SCREEN_TEXT_SCALE.get();
        float heightPositionScale = 1.5f;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(guiHalfWidth, guiHalfHeight, 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        poseStack.m_85836_();
        poseStack.m_85841_((float)scale, (float)scale, (float)scale);
        if (Proxy.Client.getPlayerState() != null && !Proxy.Client.getPlayerState().equals((Object)ProtectedPlayer.State.ACTIVE)) {
            int textHalfWidth = font.m_92895_(Proxy.Client.getPlayerState().toString()) / 2;
            Objects.requireNonNull(font);
            int textHalfHeight = 9 / 2;
            int offsetX = -textHalfWidth;
            int offsetY = -(textHalfHeight + (int)(guiHalfHeight / heightPositionScale / (float)scale));
            int argb = -1;
            guiGraphics.m_280488_(font, Proxy.Client.getPlayerState().toString().replace("_", " "), offsetX, offsetY, argb);
        }
        poseStack.m_85849_();
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }
}

