/*
 * Decompiled with CFR 0.152.
 */
package dev.micle.loginprotection.events.client;

import dev.micle.loginprotection.data.ProtectedPlayer;
import dev.micle.loginprotection.network.NetworkManager;
import dev.micle.loginprotection.network.client.InputPacket;
import dev.micle.loginprotection.proxy.Proxy;
import dev.micle.loginprotection.setup.Config;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class OnClientInputEventHandler {
    private static boolean isPausePressed = false;
    private static boolean isDebugPressed = false;
    private static boolean isFullscreenPressed = false;
    private static boolean isTogglePerspectivePressed = false;
    private static boolean isSmoothCameraPressed = false;
    private static boolean isScreenshotPressed = false;
    private static boolean isSpectatorOutlinesPressed = false;
    private static boolean isAdvancementsPressed = false;
    private static boolean isPlayerListPressed = false;
    private static boolean isChatPressed = false;
    private static boolean isChatCommandPressed = false;
    private static boolean isChatEnterPressed = false;
    private static boolean isSocialInteractionsPressed = false;
    private static boolean isLoadHotbarActivatorPressed = false;
    private static boolean isSaveHotbarActivatorPressed = false;
    private static boolean isSwapOffhandPressed = false;
    private static boolean isInventoryPressed = false;
    private static boolean isDropItemPressed = false;
    private static boolean isUseItemPressed = false;
    private static boolean isPickBlockPressed = false;
    private static boolean isAttackPressed = false;
    private static boolean isMoveUpPressed = false;
    private static boolean isMoveRightPressed = false;
    private static boolean isMoveDownPressed = false;
    private static boolean isMoveLeftPressed = false;
    private static boolean isMoveSprintPressed = false;
    private static boolean isSneakPressed = false;
    private static boolean isJumpPressed = false;
    private static final Boolean[] isHotBarPressed = new Boolean[9];
    private static Screen previousScreen = null;

    public OnClientInputEventHandler() {
        Arrays.fill((Object[])isHotBarPressed, (Object)false);
    }

    @SubscribeEvent
    public void KeyInputEvent(InputEvent.Key event) {
        OnClientInputEventHandler.handle(event.getAction(), event.getKey());
    }

    @SubscribeEvent
    public void MouseInputEvent(InputEvent.MouseButton.Post event) {
        OnClientInputEventHandler.handle(event.getAction(), event.getButton());
    }

    private static void handle(int action, int key) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.m_91089_() == null && minecraft.m_91092_() == null || Proxy.Client.getPlayerState() == null) {
            return;
        }
        if (action == 1 || action == 0) {
            List allowedKeys;
            Options keyBinds = minecraft.f_91066_;
            boolean isPressed = action == 1;
            List list = allowedKeys = Proxy.Client.getPlayerState().equals((Object)ProtectedPlayer.State.JOINING) ? (List)Config.Server.LOGIN_KEY_ALLOW_LIST.get() : (List)Config.Server.AFK_KEY_ALLOW_LIST.get();
            if (key == 256) {
                isPausePressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.PAUSE.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == 292) {
                isDebugPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.DEBUG.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92105_.getKey().m_84873_()) {
                isFullscreenPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.FULLSCREEN.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92103_.getKey().m_84873_()) {
                isTogglePerspectivePressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.PERSPECTIVE.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92104_.getKey().m_84873_()) {
                isSmoothCameraPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.SMOOTH_CAMERA.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92102_.getKey().m_84873_()) {
                isScreenshotPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.SCREENSHOT.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92054_.getKey().m_84873_()) {
                isSpectatorOutlinesPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.SPECTATOR_OUTLINES.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92055_.getKey().m_84873_()) {
                isAdvancementsPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.ADVANCEMENTS.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92099_.getKey().m_84873_()) {
                isPlayerListPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.PLAYER_LIST.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92098_.getKey().m_84873_()) {
                isChatPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.CHAT.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92100_.getKey().m_84873_()) {
                isChatCommandPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.CHAT.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == 257) {
                isChatEnterPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.CHAT.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92101_.getKey().m_84873_()) {
                isSocialInteractionsPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.SOCIAL_INTERACTIONS.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92058_.getKey().m_84873_()) {
                isLoadHotbarActivatorPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.LOAD_HOTBAR_ACTIVATOR.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92057_.getKey().m_84873_()) {
                isSaveHotbarActivatorPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.SAVE_HOTBAR_ACTIVATOR.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92093_.getKey().m_84873_()) {
                isSwapOffhandPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.SWAP_ITEM.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92092_.getKey().m_84873_()) {
                isInventoryPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.INVENTORY.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92094_.getKey().m_84873_()) {
                isDropItemPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.DROP_ITEM.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92095_.getKey().m_84873_()) {
                isUseItemPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.USE_ITEM.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92097_.getKey().m_84873_()) {
                isPickBlockPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.PICK_BLOCK.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92096_.getKey().m_84873_()) {
                isAttackPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.ATTACK.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92085_.getKey().m_84873_()) {
                isMoveUpPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.MOVE.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92088_.getKey().m_84873_()) {
                isMoveRightPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.MOVE.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92087_.getKey().m_84873_()) {
                isMoveDownPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.MOVE.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92086_.getKey().m_84873_()) {
                isMoveLeftPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.MOVE.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92091_.getKey().m_84873_()) {
                isMoveSprintPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.MOVE.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92090_.getKey().m_84873_()) {
                isSneakPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.SNEAK.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else if (key == keyBinds.f_92089_.getKey().m_84873_()) {
                isJumpPressed = isPressed;
                if (!OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) && !allowedKeys.contains(Config.Server.KEYS.JUMP.toString())) {
                    OnClientInputEventHandler.updateAndNotify();
                }
            } else {
                for (int i = 0; i < isHotBarPressed.length; ++i) {
                    if (key != keyBinds.f_92056_[i].getKey().m_84873_()) continue;
                    OnClientInputEventHandler.isHotBarPressed[i] = isPressed;
                    if (OnClientInputEventHandler.checkIfScreenIsAllowed(allowedKeys, minecraft.f_91080_, !isPressed) || allowedKeys.contains(Config.Server.KEYS.HOTBAR.toString())) continue;
                    OnClientInputEventHandler.updateAndNotify();
                }
            }
        }
    }

    private static boolean checkIfScreenIsAllowed(List<String> allowedKeys, Screen screen, boolean isActionReleased) {
        boolean isAllowed;
        if (previousScreen instanceof PauseScreen || screen instanceof PauseScreen) {
            isAllowed = allowedKeys.contains(Config.Server.KEYS.PAUSE.toString());
        } else if (previousScreen instanceof InventoryScreen || screen instanceof InventoryScreen) {
            isAllowed = allowedKeys.contains(Config.Server.KEYS.INVENTORY.toString());
        } else if (previousScreen instanceof ChatScreen || screen instanceof ChatScreen) {
            isAllowed = allowedKeys.contains(Config.Server.KEYS.CHAT.toString());
        } else {
            boolean bl = isAllowed = screen != null;
        }
        if (isActionReleased) {
            previousScreen = screen;
        }
        return isAllowed;
    }

    private static void updateAndNotify() {
        Proxy.Client.updateLastInputTick();
        if (Proxy.Client.getPlayerState().equals((Object)ProtectedPlayer.State.JOINING) || Proxy.Client.getPlayerState().equals((Object)ProtectedPlayer.State.AFK)) {
            NetworkManager.getChannel().sendToServer((Object)new InputPacket());
        }
    }

    public static void checkIfInputIsAllowed() {
        List allowedKeys;
        List list = allowedKeys = Proxy.Client.getPlayerState().equals((Object)ProtectedPlayer.State.JOINING) ? (List)Config.Server.LOGIN_KEY_ALLOW_LIST.get() : (List)Config.Server.AFK_KEY_ALLOW_LIST.get();
        if (isPausePressed && !allowedKeys.contains(Config.Server.KEYS.PAUSE.toString()) || isDebugPressed && !allowedKeys.contains(Config.Server.KEYS.DEBUG.toString()) || isFullscreenPressed && !allowedKeys.contains(Config.Server.KEYS.FULLSCREEN.toString()) || isTogglePerspectivePressed && !allowedKeys.contains(Config.Server.KEYS.PERSPECTIVE.toString()) || isSmoothCameraPressed && !allowedKeys.contains(Config.Server.KEYS.SMOOTH_CAMERA.toString()) || isScreenshotPressed && !allowedKeys.contains(Config.Server.KEYS.SCREENSHOT.toString()) || isSpectatorOutlinesPressed && !allowedKeys.contains(Config.Server.KEYS.SPECTATOR_OUTLINES.toString()) || isAdvancementsPressed && !allowedKeys.contains(Config.Server.KEYS.ADVANCEMENTS.toString()) || isPlayerListPressed && !allowedKeys.contains(Config.Server.KEYS.PLAYER_LIST.toString()) || (isChatPressed || isChatCommandPressed || isChatEnterPressed) && !allowedKeys.contains(Config.Server.KEYS.CHAT.toString()) || isSocialInteractionsPressed && !allowedKeys.contains(Config.Server.KEYS.SOCIAL_INTERACTIONS.toString()) || isLoadHotbarActivatorPressed && !allowedKeys.contains(Config.Server.KEYS.LOAD_HOTBAR_ACTIVATOR.toString()) || isSaveHotbarActivatorPressed && !allowedKeys.contains(Config.Server.KEYS.SAVE_HOTBAR_ACTIVATOR.toString()) || isSwapOffhandPressed && !allowedKeys.contains(Config.Server.KEYS.SWAP_ITEM.toString()) || isInventoryPressed && !allowedKeys.contains(Config.Server.KEYS.INVENTORY.toString()) || isDropItemPressed && !allowedKeys.contains(Config.Server.KEYS.DROP_ITEM.toString()) || isUseItemPressed && !allowedKeys.contains(Config.Server.KEYS.USE_ITEM.toString()) || isPickBlockPressed && !allowedKeys.contains(Config.Server.KEYS.PICK_BLOCK.toString()) || isAttackPressed && !allowedKeys.contains(Config.Server.KEYS.ATTACK.toString()) || (isMoveUpPressed || isMoveRightPressed || isMoveDownPressed || isMoveLeftPressed || isMoveSprintPressed) && !allowedKeys.contains(Config.Server.KEYS.MOVE.toString()) || isSneakPressed && !allowedKeys.contains(Config.Server.KEYS.SNEAK.toString()) || isJumpPressed && !allowedKeys.contains(Config.Server.KEYS.JUMP.toString()) || Arrays.stream(isHotBarPressed).anyMatch(b -> b) && !allowedKeys.contains(Config.Server.KEYS.HOTBAR.toString())) {
            OnClientInputEventHandler.updateAndNotify();
        }
    }
}

