/*
 * Decompiled with CFR 0.152.
 */
package dev.micle.loginprotection.data;

import dev.micle.loginprotection.LoginProtection;
import dev.micle.loginprotection.data.ProtectedPlayer;
import dev.micle.loginprotection.network.NetworkManager;
import dev.micle.loginprotection.network.server.PlayerStatePacket;
import dev.micle.loginprotection.network.server.RequestLastInputTickPacket;
import dev.micle.loginprotection.setup.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraftforge.network.NetworkDirection;

public class ProtectedPlayerManager {
    private static final List<ProtectedPlayer> protectedPlayers = new ArrayList<ProtectedPlayer>();

    public static void init() {
        for (ProtectedPlayer protectedPlayer : protectedPlayers) {
            ProtectedPlayerManager.removePlayer(protectedPlayer.getPlayerUUID());
        }
    }

    public static void addPlayer(UUID playerUUID) {
        if (ProtectedPlayerManager.getPlayer(playerUUID) != null) {
            return;
        }
        try {
            protectedPlayers.add(new ProtectedPlayer(playerUUID, ProtectedPlayer.State.JOINING));
            NetworkManager.getChannel().sendTo((Object)new PlayerStatePacket(ProtectedPlayer.State.JOINING), LoginProtection.getProxy().getServer().m_6846_().m_11259_((UUID)playerUUID).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static ProtectedPlayer getPlayer(UUID playerUUID) {
        for (ProtectedPlayer protectedPlayer : protectedPlayers) {
            if (!protectedPlayer.getPlayerUUID().equals(playerUUID)) continue;
            return protectedPlayer;
        }
        return null;
    }

    public static void removePlayer(UUID playerUUID) {
        ProtectedPlayer player = ProtectedPlayerManager.getPlayer(playerUUID);
        if (player == null) {
            return;
        }
        player.getTimer().cancel();
        protectedPlayers.remove(player);
    }

    public static void updateState(UUID playerUUID) {
        ProtectedPlayer protectedPlayer = ProtectedPlayerManager.getPlayer(playerUUID);
        ServerPlayer player = LoginProtection.getProxy().getServer().m_6846_().m_11259_(playerUUID);
        if (player == null) {
            ProtectedPlayerManager.removePlayer(playerUUID);
            return;
        }
        if (protectedPlayer == null) {
            ProtectedPlayerManager.addPlayer(playerUUID);
        } else {
            ProtectedPlayer.State currentState = protectedPlayer.getState();
            if (currentState.equals((Object)ProtectedPlayer.State.JOINING)) {
                if (((Boolean)Config.Server.LOGIN_GRACE_ENABLED.get()).booleanValue()) {
                    protectedPlayer.setState(ProtectedPlayer.State.LOGIN_GRACE);
                    ProtectedPlayerManager.startGraceTimer(playerUUID, (Integer)Config.Server.LOGIN_GRACE_DURATION.get() * 1000);
                } else {
                    protectedPlayer.setState(ProtectedPlayer.State.ACTIVE);
                    if (((Boolean)Config.Server.LOGIN_APPLY_POST_EFFECTS.get()).booleanValue()) {
                        ProtectedPlayerManager.applyPostEffects(playerUUID);
                    }
                    if (((Boolean)Config.Server.AFK_PROTECTION_ENABLED.get()).booleanValue()) {
                        ProtectedPlayerManager.startAfkTimer(playerUUID, (Integer)Config.Server.AFK_TIME_THRESHOLD.get() * 1000);
                    } else {
                        ProtectedPlayerManager.removePlayer(playerUUID);
                    }
                }
            } else if (currentState.equals((Object)ProtectedPlayer.State.LOGIN_GRACE) || currentState.equals((Object)ProtectedPlayer.State.AFK_GRACE)) {
                protectedPlayer.setState(ProtectedPlayer.State.ACTIVE);
                if (currentState.equals((Object)ProtectedPlayer.State.LOGIN_GRACE) && ((Boolean)Config.Server.LOGIN_APPLY_POST_EFFECTS.get()).booleanValue() || currentState.equals((Object)ProtectedPlayer.State.AFK_GRACE) && ((Boolean)Config.Server.AFK_APPLY_POST_EFFECTS.get()).booleanValue()) {
                    ProtectedPlayerManager.applyPostEffects(playerUUID);
                }
                if (((Boolean)Config.Server.AFK_PROTECTION_ENABLED.get()).booleanValue()) {
                    ProtectedPlayerManager.startAfkTimer(playerUUID, (Integer)Config.Server.AFK_TIME_THRESHOLD.get() * 1000);
                } else {
                    ProtectedPlayerManager.removePlayer(playerUUID);
                }
            } else if (currentState.equals((Object)ProtectedPlayer.State.ACTIVE)) {
                protectedPlayer.setState(ProtectedPlayer.State.AFK);
            } else if (currentState.equals((Object)ProtectedPlayer.State.AFK)) {
                if (((Boolean)Config.Server.AFK_GRACE_ENABLED.get()).booleanValue()) {
                    protectedPlayer.setState(ProtectedPlayer.State.AFK_GRACE);
                    ProtectedPlayerManager.startGraceTimer(playerUUID, (Integer)Config.Server.AFK_GRACE_DURATION.get() * 1000);
                } else {
                    protectedPlayer.setState(ProtectedPlayer.State.ACTIVE);
                    if (((Boolean)Config.Server.AFK_APPLY_POST_EFFECTS.get()).booleanValue()) {
                        ProtectedPlayerManager.applyPostEffects(playerUUID);
                    }
                    if (((Boolean)Config.Server.AFK_PROTECTION_ENABLED.get()).booleanValue()) {
                        ProtectedPlayerManager.startAfkTimer(playerUUID, (Integer)Config.Server.AFK_TIME_THRESHOLD.get() * 1000);
                    } else {
                        ProtectedPlayerManager.removePlayer(playerUUID);
                    }
                }
            }
            NetworkManager.getChannel().sendTo((Object)new PlayerStatePacket(protectedPlayer.getState()), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static void startAfkTimer(final UUID playerUUID, long delay) {
        ProtectedPlayer player = ProtectedPlayerManager.getPlayer(playerUUID);
        if (player == null) {
            return;
        }
        player.setAfkTimerTask(new TimerTask(){

            @Override
            public void run() {
                try {
                    NetworkManager.getChannel().sendTo((Object)new RequestLastInputTickPacket(), LoginProtection.getProxy().getServer().m_6846_().m_11259_((UUID)playerUUID).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                }
                catch (NullPointerException e) {
                    ProtectedPlayerManager.removePlayer(playerUUID);
                }
            }
        }, delay);
    }

    private static void startGraceTimer(final UUID playerUUID, long delay) {
        ProtectedPlayer player = ProtectedPlayerManager.getPlayer(playerUUID);
        if (player == null) {
            return;
        }
        player.setGracePeriodTimerTask(new TimerTask(){

            @Override
            public void run() {
                ProtectedPlayerManager.updateState(playerUUID);
            }
        }, delay);
    }

    private static void applyPostEffects(UUID playerUUID) {
        ServerPlayer player = LoginProtection.getProxy().getServer().m_6846_().m_11259_(playerUUID);
        if (player == null) {
            ProtectedPlayerManager.removePlayer(playerUUID);
            return;
        }
        if (player.m_20069_()) {
            if (((Boolean)Config.Server.POST_REFILL_AIR_ENABLED.get()).booleanValue()) {
                player.m_20301_(player.m_6062_());
            }
            if (((Boolean)Config.Server.POST_WATER_ENABLED.get()).booleanValue()) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19608_, (Integer)Config.Server.POST_WATER_DURATION.get() * 20, 0));
            }
        }
        if (player.m_20077_() && ((Boolean)Config.Server.POST_LAVA_ENABLED.get()).booleanValue()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, (Integer)Config.Server.POST_LAVA_DURATION.get() * 20, 0));
        }
        if (player.m_6060_() && ((Boolean)Config.Server.POST_FIRE_ENABLED.get()).booleanValue()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, (Integer)Config.Server.POST_FIRE_DURATION.get() * 20, 0));
        }
    }
}

