/*
 * Decompiled with CFR 0.152.
 */
package dev.micle.loginprotection.data;

import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;

public class ProtectedPlayer {
    private final UUID playerUUID;
    private final Timer timer = new Timer();
    private TimerTask afkTimerTask;
    private TimerTask gracePeriodTimerTask;
    private State state;

    public ProtectedPlayer(UUID playerUUID, State state) {
        this.playerUUID = playerUUID;
        this.state = state;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setGracePeriodTimerTask(TimerTask gracePeriodTimerTask, long delay) {
        if (this.gracePeriodTimerTask != null) {
            this.gracePeriodTimerTask.cancel();
        }
        if (gracePeriodTimerTask != null) {
            this.gracePeriodTimerTask = gracePeriodTimerTask;
            this.timer.schedule(this.gracePeriodTimerTask, delay);
        }
    }

    public void setAfkTimerTask(TimerTask afkTimerTask, long delay) {
        if (this.afkTimerTask != null) {
            this.afkTimerTask.cancel();
        }
        if (afkTimerTask != null) {
            this.afkTimerTask = afkTimerTask;
            this.timer.schedule(this.afkTimerTask, delay);
        }
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public static enum State {
        JOINING,
        AFK,
        ACTIVE,
        LOGIN_GRACE,
        AFK_GRACE;

    }
}

