/*
 * Decompiled with CFR 0.152.
 */
package net.michanide.mekanismneutronactivator.common.tile.machine;

import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.GasToGasRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.OneInputCachedRecipe;
import mekanism.api.recipes.chemical.ChemicalToChemicalRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.value.CachedLongValue;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.ISingleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.tile.prefab.TileEntityRecipeMachine;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorController;
import net.michanide.mekanismneutronactivator.common.config.MNAConfig;
import net.michanide.mekanismneutronactivator.common.registries.MNABlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class TileEntityFusionNeutronActivator
extends TileEntityRecipeMachine<GasToGasRecipe>
implements IBoundingBlock,
ISingleRecipeLookupHandler.ChemicalRecipeLookupHandler<Gas, GasStack, GasToGasRecipe> {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    public static final CachedLongValue MAX_GAS_CONF = MNAConfig.general.fusionNeutronActivatorMaxTankSize;
    public static final CachedLongValue OUTPUT_RATE_CONF = MNAConfig.general.fusionNeutronActivatorOutputRate;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getInput", "getInputCapacity", "getInputNeeded", "getInputFilledPercentage"}, docPlaceholder="input tank")
    public IGasTank inputTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getOutput", "getOutputCapacity", "getOutputNeeded", "getOutputFilledPercentage"}, docPlaceholder="output tank")
    public IGasTank outputTank;
    @SyntheticComputerMethod(getter="getProductionRate")
    private float productionRate;
    private Long fuelBurned;
    private final IOutputHandler<@NotNull GasStack> outputHandler;
    private final IInputHandler<@NotNull GasStack> inputHandler;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"}, docPlaceholder="input slot")
    private GasInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"}, docPlaceholder="output slot")
    private GasInventorySlot outputSlot;

    public TileEntityFusionNeutronActivator(BlockPos pos, BlockState state) {
        super(MNABlocks.FUSION_NEUTRON_ACTIVATOR, pos, state, TRACKED_ERROR_TYPES);
        this.configComponent = new TileComponentConfig((TileEntityMekanism)this, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.GAS});
        this.configComponent.setupIOConfig(TransmissionType.ITEM, (Object)this.inputSlot, (Object)this.outputSlot, RelativeSide.FRONT);
        this.configComponent.setupIOConfig(TransmissionType.GAS, (Object)this.inputTank, (Object)this.outputTank, RelativeSide.FRONT, false, true).setEjecting(true);
        this.configComponent.addDisabledSides(new RelativeSide[]{RelativeSide.TOP});
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this, (LongSupplier)OUTPUT_RATE_CONF);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.GAS}).setCanTankEject(tank -> tank != this.inputTank);
        this.inputHandler = InputHelper.getInputHandler((IChemicalTank)this.inputTank, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        this.outputHandler = OutputHelper.getOutputHandler((IChemicalTank)this.outputTank, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
        this.fuelBurned = 0L;
    }

    @NotNull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks(IContentsListener listener, IContentsListener recipeCacheListener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideGasWithConfig(() -> ((TileEntityFusionNeutronActivator)this).getDirection(), () -> ((TileEntityFusionNeutronActivator)this).getConfig());
        this.inputTank = (IGasTank)ChemicalTankBuilder.GAS.create(MAX_GAS_CONF.get(), (type, automationType) -> automationType != AutomationType.EXTERNAL || this.outputTank.isEmpty() && type.has(GasAttributes.Radiation.class), ChemicalTankBuilder.GAS.alwaysTrueBi, arg_0 -> ((TileEntityFusionNeutronActivator)this).containsRecipe(arg_0), ChemicalAttributeValidator.ALWAYS_ALLOW, recipeCacheListener);
        builder.addTank((IChemicalTank)this.inputTank);
        this.outputTank = (IGasTank)ChemicalTankBuilder.GAS.output(MAX_GAS_CONF.get(), listener);
        builder.addTank((IChemicalTank)this.outputTank);
        return builder.build();
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener, IContentsListener recipeCacheListener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(() -> ((TileEntityFusionNeutronActivator)this).getDirection(), () -> ((TileEntityFusionNeutronActivator)this).getConfig());
        this.inputSlot = GasInventorySlot.fill((IGasTank)this.inputTank, (IContentsListener)listener, (int)5, (int)56);
        builder.addSlot((IInventorySlot)this.inputSlot);
        this.outputSlot = GasInventorySlot.drain((IGasTank)this.outputTank, (IContentsListener)listener, (int)155, (int)56);
        builder.addSlot((IInventorySlot)this.outputSlot);
        this.inputSlot.setSlotType(ContainerSlotType.INPUT);
        this.inputSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.outputSlot.setSlotType(ContainerSlotType.OUTPUT);
        this.outputSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    protected void onUpdateServer() {
        super.onUpdateServer();
        this.inputSlot.fillTank();
        this.outputSlot.drainTank();
        this.productionRate = this.recalculateProductionRate();
        this.recipeCacheLookupMonitor.updateAndProcess();
    }

    @NotNull
    public IMekanismRecipeTypeProvider<GasToGasRecipe, InputRecipeCache.SingleChemical<Gas, GasStack, GasToGasRecipe>> getRecipeType() {
        return MekanismRecipeType.ACTIVATING;
    }

    @Nullable
    public GasToGasRecipe getRecipe(int cacheIndex) {
        return (GasToGasRecipe)this.findFirstRecipe(this.inputHandler);
    }

    public Long getFuelBurned() {
        return this.fuelBurned;
    }

    public void setFuelBurned(Long value) {
        this.fuelBurned = value;
    }

    private boolean canFunction() {
        return MekanismUtils.canFunction((TileEntityMekanism)this);
    }

    private float recalculateProductionRate() {
        Level world = this.m_58904_();
        if (world == null || !this.canFunction()) {
            return 0.0f;
        }
        Long lastFuelBurned = 0L;
        BlockPos dstBlock = this.m_58899_().m_6630_(6);
        BlockEntity aboveEntity = WorldUtils.getTileEntity((BlockGetter)world, (BlockPos)dstBlock);
        if (aboveEntity != null && aboveEntity instanceof TileEntityFusionReactorController) {
            FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)((TileEntityFusionReactorController)aboveEntity).getMultiblock();
            lastFuelBurned = multiblock != null ? (multiblock.isBurning() ? this.getFuelBurned() : Long.valueOf(0L)) : Long.valueOf(0L);
        }
        float production = (float)MNAConfig.general.fusionNeutronActivatorMultiplier.get() * (float)lastFuelBurned.longValue();
        return production;
    }

    @NotNull
    public CachedRecipe<GasToGasRecipe> createNewCachedRecipe(@NotNull GasToGasRecipe recipe, int cacheIndex) {
        return OneInputCachedRecipe.chemicalToChemical((ChemicalToChemicalRecipe)recipe, (BooleanSupplier)this.recheckAllRecipeErrors, this.inputHandler, this.outputHandler).setErrorsChanged(x$0 -> this.onErrorsChanged((Set)x$0)).setCanHolderFunction(this::canFunction).setActive(arg_0 -> ((TileEntityFusionNeutronActivator)this).setActive(arg_0)).setOnFinish(() -> ((TileEntityFusionNeutronActivator)this).markForSave()).setRequiredTicks(() -> this.productionRate > 0.0f && this.productionRate < 1.0f ? (int)Math.ceil(1.0f / this.productionRate) : 1).setBaselineMaxOperations(() -> this.productionRate > 0.0f && this.productionRate < 1.0f ? 1 : (int)this.productionRate);
    }

    @Nonnull
    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_, this.f_58858_.m_7918_(1, 2, 1));
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.inputTank.getStored(), (long)this.inputTank.getCapacity());
    }

    protected boolean makesComparatorDirty(@Nullable SubstanceType type) {
        return type == SubstanceType.GAS;
    }
}

