/*
 * Decompiled with CFR 0.152.
 */
package net.michanide.mekanismneutronactivator.common.config;

import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedDoubleValue;
import mekanism.common.config.value.CachedLongValue;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class MNAGeneralConfig
extends BaseMekanismConfig {
    private final ForgeConfigSpec configSpec;
    public final CachedLongValue fusionNeutronActivatorMaxTankSize;
    public final CachedDoubleValue fusionNeutronActivatorMultiplier;
    public final CachedLongValue fusionNeutronActivatorOutputRate;
    public final CachedLongValue fissionNeutronActivatorMaxTankSize;
    public final CachedDoubleValue fissionNeutronActivatorProductionRate;
    public final CachedDoubleValue fissionNeutronActivatorPlutoniumMultiplier;
    public final CachedLongValue fissionNeutronActivatorOutputRate;

    MNAGeneralConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("MNA General Config. This config is synced from server to client.").push("MNA-general");
        this.fusionNeutronActivatorMaxTankSize = CachedLongValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Max tank size of fusion neutron activator.").defineInRange("fusionNeutronActivatorMaxTankSize", 100000L, 1L, Long.MAX_VALUE));
        this.fusionNeutronActivatorMultiplier = CachedDoubleValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Multiplier of fusion neutron activator's production rate. Actual producton rate is this value multiplied by fusion fuel burned.").defineInRange("fusionNeutronActivatorMultiplier", 3.0, 0.0, Double.MAX_VALUE));
        this.fusionNeutronActivatorOutputRate = CachedLongValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Output rate of fusion neutron activator.").defineInRange("fusionNeutronActivatorOutputRate", 4096L, 1L, Long.MAX_VALUE));
        this.fissionNeutronActivatorMaxTankSize = CachedLongValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Max tank size of fission neutron activator.").defineInRange("fissionNeutronActivatorMaxTankSize", 1000L, 1L, Long.MAX_VALUE));
        this.fissionNeutronActivatorProductionRate = CachedDoubleValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Production rate of fission neutron activator's operation. (Inverse of operating ticks)").defineInRange("fissionNeutronActivatorOperatingTicks", 0.0025, 0.0, Double.MAX_VALUE));
        this.fissionNeutronActivatorPlutoniumMultiplier = CachedDoubleValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Multiplier of fission neutron activator's production rate. When you use barrel containing plutonium, the production rate is multiplied by this value.").defineInRange("fissionNeutronActivatorPlutoniumMultiplier", 10.0, 0.0, Double.MAX_VALUE));
        this.fissionNeutronActivatorOutputRate = CachedLongValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Output rate of fission neutron activator.").defineInRange("fissionNeutronActivatorOutputRate", 4096L, 1L, Long.MAX_VALUE));
        builder.pop();
        this.configSpec = builder.build();
    }

    public String getFileName() {
        return "MNA-general";
    }

    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }

    public boolean addToContainer() {
        return false;
    }
}

