/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.mekanismcardboardtooltip.client;

import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.block.BlockCardboardBox;
import mekanism.common.item.block.ItemBlockCardboardBox;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="mekanismcardboardtooltip", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientForgeEvents {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        if (ModList.get().isLoaded("mekanism")) {
            Player player;
            Item item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)"mekanism:cardboard_box"));
            ItemStack stack = event.getItemStack();
            if (stack.m_41720_() == item && (player = event.getEntity()) != null && item instanceof ItemBlockCardboardBox) {
                ItemBlockCardboardBox cardboardBox = (ItemBlockCardboardBox)item;
                Level level = player.m_9236_();
                BlockCardboardBox.BlockData data = cardboardBox.getBlockData(level, stack);
                event.getToolTip().remove(MekanismLang.BLOCK_DATA.translateColored(EnumColor.INDIGO, new Object[]{BooleanStateDisplay.YesNo.of((data != null ? 1 : 0) != 0)}));
                if (stack.m_41782_()) {
                    if (data != null) {
                        CompoundTag tileTag;
                        event.getToolTip().add(MekanismLang.BLOCK_DATA.translateColored(EnumColor.INDIGO, new Object[]{BooleanStateDisplay.YesNo.of((boolean)true, (boolean)true)}));
                        Block block = data.blockState.m_60734_();
                        event.getToolTip().remove(MekanismLang.BLOCK.translate(new Object[]{block}));
                        event.getToolTip().add(TextComponentUtil.build((Object[])new Object[]{EnumColor.INDIGO, MekanismLang.BLOCK.translate(new Object[]{Component.m_237115_((String)block.m_7705_()).m_130940_(ChatFormatting.GRAY)})}));
                        if (block instanceof SpawnerBlock && (tileTag = data.tileTag) != null) {
                            ResourceLocation entityLocation;
                            EntityType type;
                            event.getToolTip().remove(MekanismLang.BLOCK_ENTITY.translate(new Object[]{tileTag.m_128461_("id")}));
                            event.getToolTip().add(MekanismLang.BLOCK_ENTITY.translateColored(EnumColor.INDIGO, new Object[]{Component.m_237115_((String)tileTag.m_128461_("id")).m_130940_(ChatFormatting.GRAY)}));
                            Tag tag = data.tileTag.m_128469_("SpawnData").m_128469_("entity").m_128423_("id");
                            if (tag != null && (type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.m_135820_((String)tag.toString().replace("\"", "")))) != null && (entityLocation = ForgeRegistries.ENTITY_TYPES.getKey((Object)type)) != null) {
                                event.getToolTip().add(TextComponentUtil.build((Object[])new Object[]{EnumColor.INDIGO, Component.m_237110_((String)"cardboard_box.mekanism.block_entity.spawn_type", (Object[])new Object[]{Component.m_237115_((String)ClientForgeEvents.capitaliseAllWords(entityLocation.m_214299_().replace("_", " "))).m_130940_(ChatFormatting.GRAY)})}));
                            }
                        }
                    }
                } else {
                    event.getToolTip().add(MekanismLang.BLOCK_DATA.translateColored(EnumColor.INDIGO, new Object[]{TextComponentUtil.build((Object[])new Object[]{EnumColor.RED, MekanismLang.NO})}));
                }
            }
        }
    }

    public static String capitaliseAllWords(String str) {
        if (str == null) {
            return null;
        }
        int sz = str.length();
        StringBuilder buffer = new StringBuilder(sz);
        boolean space = true;
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (Character.isWhitespace(ch)) {
                buffer.append(ch);
                space = true;
                continue;
            }
            if (space) {
                buffer.append(Character.toTitleCase(ch));
                space = false;
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }
}

