/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.common.menu;

import com.github.x3r.mekanism_weaponry.common.item.GunItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.GunAddonItem;
import com.github.x3r.mekanism_weaponry.common.registry.BlockRegistry;
import com.github.x3r.mekanism_weaponry.common.registry.MenuTypeRegistry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class WeaponWorkbenchMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final Container container;

    public WeaponWorkbenchMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public WeaponWorkbenchMenu(int containerId, Inventory playerInventory, ContainerLevelAccess access) {
        super((MenuType)MenuTypeRegistry.WEAPON_WORKBENCH.get(), containerId);
        int i;
        this.access = access;
        this.container = this.createContainer();
        this.m_38897_(new GunSlot(this.container, 0, 8, 16));
        this.m_38897_(new AddonSlot(this.container, 1, 152, 16, GunAddonItem.AddonType.CHIP));
        this.m_38897_(new AddonSlot(this.container, 2, 8, 35, GunAddonItem.AddonType.PAINT));
        this.m_38897_(new AddonSlot(this.container, 3, 152, 35, GunAddonItem.AddonType.CHIP));
        this.m_38897_(new AddonSlot(this.container, 4, 8, 54, GunAddonItem.AddonType.SCOPE));
        this.m_38897_(new AddonSlot(this.container, 5, 152, 54, GunAddonItem.AddonType.CHIP));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public void onItemSet(int index, ItemStack itemStack) {
        if (index == 0) {
            Item item = itemStack.m_41720_();
            if (item instanceof GunItem) {
                GunItem gunItem = (GunItem)item;
                for (int i = 1; i < 6; ++i) {
                    this.container.m_6836_(i, gunItem.getAddon(itemStack, i - 1));
                }
            } else {
                for (int i = 1; i < 6; ++i) {
                    this.container.m_6836_(i, ItemStack.f_41583_);
                }
            }
        } else {
            ItemStack gunStack = this.container.m_8020_(0);
            Item item = gunStack.m_41720_();
            if (item instanceof GunItem) {
                GunItem gunItem = (GunItem)item;
                gunItem.setAddon(gunStack, itemStack, index - 1);
            }
        }
    }

    private Container createContainer() {
        return new SimpleContainer(6){

            public void m_6596_() {
                super.m_6596_();
                WeaponWorkbenchMenu.this.m_6199_((Container)this);
            }

            public void m_6836_(int index, ItemStack stack) {
                super.m_6836_(index, stack);
                WeaponWorkbenchMenu.this.onItemSet(index, stack);
            }
        };
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.access.m_39292_((p_39796_, p_39797_) -> this.m_150411_(player, this.container));
    }

    protected void m_150411_(Player player, Container container) {
        ServerPlayer serverPlayer;
        if (!player.m_6084_() || player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).m_9232_()) {
            player.m_36176_(container.m_8016_(0), false);
        } else {
            Inventory inventory = player.m_150109_();
            if (inventory.f_35978_ instanceof ServerPlayer) {
                inventory.m_150079_(container.m_8016_(0));
            }
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < 6 ? !this.m_38903_(itemstack1, 6, 42, true) : !this.m_38903_(itemstack1, 0, 6, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return WeaponWorkbenchMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)BlockRegistry.WEAPON_WORKBENCH.get()));
    }

    private static class GunSlot
    extends Slot {
        public GunSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.m_41720_() instanceof GunItem;
        }
    }

    private static class AddonSlot
    extends Slot {
        private final GunAddonItem.AddonType addonType;

        public AddonSlot(Container container, int slot, int x, int y, GunAddonItem.AddonType addonType) {
            super(container, slot, x, y);
            this.addonType = addonType;
        }

        public boolean m_5857_(ItemStack stack) {
            GunItem gunItem;
            GunAddonItem gunAddonItem;
            Item item = stack.m_41720_();
            return item instanceof GunAddonItem && (gunAddonItem = (GunAddonItem)item).getAddonType().equals((Object)this.addonType) && !this.f_40218_.m_8020_(0).m_41619_() && (item = this.f_40218_.m_8020_(0).m_41720_()) instanceof GunItem && (gunItem = (GunItem)item).canInstallAddon(this.f_40218_.m_8020_(0), stack);
        }
    }
}

