/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.common.item;

import com.github.x3r.mekanism_weaponry.MekanismWeaponryConfig;
import com.github.x3r.mekanism_weaponry.client.renderer.TeslaMinigunRenderer;
import com.github.x3r.mekanism_weaponry.client.sound.TeslaMinigunSoundInstance;
import com.github.x3r.mekanism_weaponry.common.item.HeatGunItem;
import com.github.x3r.mekanism_weaponry.common.item.ItemEnergyCapability;
import com.github.x3r.mekanism_weaponry.common.item.addon.EnergyUsageChipItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.FireRateChipItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.PaintBucketItem;
import com.github.x3r.mekanism_weaponry.common.packet.ActivateGunClientPacket;
import com.github.x3r.mekanism_weaponry.common.packet.MekanismWeaponryPacketHandler;
import com.github.x3r.mekanism_weaponry.common.registry.DamageTypeRegistry;
import com.github.x3r.mekanism_weaponry.common.registry.SoundRegistry;
import com.github.x3r.mekanism_weaponry.common.scheduler.Scheduler;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.EnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TeslaMinigunItem
extends HeatGunItem
implements GeoItem {
    private static final RawAnimation IDLE = RawAnimation.begin().then("idle", Animation.LoopType.HOLD_ON_LAST_FRAME);
    private static final RawAnimation RELOAD = RawAnimation.begin().then("overheat", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation SHOOT = RawAnimation.begin().then("fire", Animation.LoopType.PLAY_ONCE);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public TeslaMinigunItem(Item.Properties pProperties) {
        super(pProperties, MekanismWeaponryConfig.CONFIG.getTeslaMinigunCooldown(), MekanismWeaponryConfig.CONFIG.getTeslaMinigunEnergyUsage(), MekanismWeaponryConfig.CONFIG.getTeslaMinigunReloadTime(), MekanismWeaponryConfig.CONFIG.getTeslaMinigunHeatPerShot());
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ItemEnergyCapability(stack, new EnergyStorage(MekanismWeaponryConfig.CONFIG.getTeslaMinigunEnergyCapacity(), MekanismWeaponryConfig.CONFIG.getTeslaMinigunEnergyTransfer()));
    }

    @Override
    public void serverShoot(ItemStack stack, ServerPlayer player) {
        Level level = player.m_9236_();
        if (this.isReady(stack, player, level)) {
            this.setShooting(stack, true);
            this.setLastShotTick(stack, level.m_46467_());
            MekanismWeaponryPacketHandler.sendToClient(new ActivateGunClientPacket(), player);
            this.getEnergyStorage(stack).extractEnergy(this.getEnergyUsage(stack), false);
            this.setHeat(stack, this.getHeat(stack) + this.getHeatPerShot(stack));
            HashSet entitiesToHurt = new HashSet();
            for (int i = 0; i <= 3; ++i) {
                Vec3 hurtVolumeCenter = player.m_20182_().m_82549_(player.m_20154_().m_82541_().m_82490_((double)(2 * i)));
                AABB hurtBox = AABB.m_165882_((Vec3)hurtVolumeCenter, (double)2.0, (double)3.0, (double)2.0);
                entitiesToHurt.addAll(level.m_45933_((Entity)player, hurtBox));
            }
            entitiesToHurt.forEach(entity -> {
                if (entity instanceof LivingEntity) {
                    entity.m_6469_(new DamageTypeRegistry(player.m_9236_().m_9598_()).electricity((Entity)player), (float)MekanismWeaponryConfig.CONFIG.getTeslaMinigunDamage());
                }
            });
        } else {
            if (!this.hasSufficientEnergy(stack)) {
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundRegistry.GUN_OUT_OF_ENERGY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (this.isOverheated(stack)) {
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12374_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            this.setShooting(stack, false);
        }
    }

    @Override
    public void clientShoot(ItemStack stack, Player player) {
        TeslaMinigunSoundInstance.playSound(player);
    }

    @Override
    public void serverReload(ItemStack stack, ServerPlayer player) {
        player.m_36335_().m_41524_(stack.m_41720_(), this.getReloadTime(stack));
        int i = 0;
        while ((float)i < this.getHeat(stack)) {
            Scheduler.schedule(() -> {
                if (player.m_150109_().m_36063_(stack)) {
                    this.setHeat(stack, Math.max(0.0f, this.getHeat(stack) - 2.0f));
                }
            }, 40 + i);
            ++i;
        }
        Scheduler.schedule(() -> {
            if (player.m_150109_().m_36063_(stack)) {
                player.m_284548_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11937_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }, 40);
    }

    @Override
    public void clientReload(ItemStack stack, Player player) {
        this.triggerAnim((Entity)player, GeoItem.getId((ItemStack)stack), "controller", "reload");
    }

    @Override
    public boolean canInstallAddon(ItemStack gunStack, ItemStack addonStack) {
        if (addonStack.m_41720_().getClass().equals(EnergyUsageChipItem.class)) {
            return true;
        }
        if (addonStack.m_41720_().getClass().equals(FireRateChipItem.class)) {
            return true;
        }
        if (addonStack.m_41720_().getClass().equals(PaintBucketItem.class)) {
            return true;
        }
        return super.canInstallAddon(gunStack, addonStack);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private static final HumanoidModel.ArmPose MINIGUN_POSE = HumanoidModel.ArmPose.create((String)"minigun", (boolean)true, (model, livingEntity, humanoidArm) -> {
                float torsoAngle;
                model.f_102810_.f_104204_ = torsoAngle = 0.6f;
                model.f_102811_.f_104204_ = torsoAngle;
                model.f_102811_.f_104200_ *= Mth.m_14089_((float)torsoAngle);
                model.f_102811_.f_104202_ = (model.f_102811_.f_104202_ + 5.0f) * Mth.m_14031_((float)torsoAngle) - 1.0f;
                model.f_102812_.f_104204_ = torsoAngle;
                model.f_102812_.f_104200_ *= Mth.m_14089_((float)torsoAngle);
                model.f_102812_.f_104202_ = (model.f_102812_.f_104202_ - 5.0f) * Mth.m_14031_((float)torsoAngle);
                model.f_102811_.f_104203_ = -0.5f;
                model.f_102811_.f_104204_ -= 0.5f;
                model.f_102812_.f_104203_ = -1.0f;
                model.f_102812_.f_104205_ = 0.1f;
            });
            private TeslaMinigunRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new TeslaMinigunRenderer();
                }
                return this.renderer;
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
             @NotNull HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                return MINIGUN_POSE;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 1, state -> {
            if (!state.getController().isPlayingTriggeredAnimation()) {
                state.setAnimation(IDLE);
            }
            if (((ItemDisplayContext)state.getData(DataTickets.ITEM_RENDER_PERSPECTIVE)).m_269069_()) {
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }).receiveTriggeredAnimations().triggerableAnim("reload", RELOAD).triggerableAnim("shoot", SHOOT)});
    }

    public boolean isPerspectiveAware() {
        return true;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

