/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_weaponry.common.item;

import com.github.x3r.mekanism_weaponry.MekanismWeaponryConfig;
import com.github.x3r.mekanism_weaponry.client.ClientSetup;
import com.github.x3r.mekanism_weaponry.client.renderer.RailgunRenderer;
import com.github.x3r.mekanism_weaponry.common.datagen.MWItemTagsProvider;
import com.github.x3r.mekanism_weaponry.common.entity.RodEntity;
import com.github.x3r.mekanism_weaponry.common.item.AmmoGunItem;
import com.github.x3r.mekanism_weaponry.common.item.ItemEnergyCapability;
import com.github.x3r.mekanism_weaponry.common.item.addon.EnergyUsageChipItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.FireRateChipItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.PaintBucketItem;
import com.github.x3r.mekanism_weaponry.common.item.addon.ScopeAddonItem;
import com.github.x3r.mekanism_weaponry.common.packet.ActivateGunClientPacket;
import com.github.x3r.mekanism_weaponry.common.packet.MekanismWeaponryPacketHandler;
import com.github.x3r.mekanism_weaponry.common.registry.SoundRegistry;
import com.github.x3r.mekanism_weaponry.common.scheduler.Scheduler;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.EnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RailgunItem
extends AmmoGunItem
implements GeoItem {
    private static final RawAnimation DEFAULT_MODE = RawAnimation.begin().then("default_mode", Animation.LoopType.HOLD_ON_LAST_FRAME);
    private static final RawAnimation SECOND_MODE = RawAnimation.begin().then("second_mode", Animation.LoopType.HOLD_ON_LAST_FRAME);
    private static final RawAnimation SWITCH_TO_DEFAULT = RawAnimation.begin().then("switch_to_default", Animation.LoopType.HOLD_ON_LAST_FRAME);
    private static final RawAnimation SWITCH_TO_SECOND = RawAnimation.begin().then("switch_to_second", Animation.LoopType.HOLD_ON_LAST_FRAME);
    private static final RawAnimation SHOT_DEFAULT = RawAnimation.begin().then("shot_default", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation SHOT_SECOND = RawAnimation.begin().then("shot_second", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation RELOAD = RawAnimation.begin().then("reload", Animation.LoopType.PLAY_ONCE);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public RailgunItem(Item.Properties pProperties) {
        super(pProperties, MekanismWeaponryConfig.CONFIG.getRailgunCooldown(), MekanismWeaponryConfig.CONFIG.getRailgunEnergyUsage(), MekanismWeaponryConfig.CONFIG.getRailgunReloadTime(), MekanismWeaponryConfig.CONFIG.getRailgunMaxAmmo());
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ItemEnergyCapability(stack, new EnergyStorage(MekanismWeaponryConfig.CONFIG.getRailgunEnergyCapacity(), MekanismWeaponryConfig.CONFIG.getRailgunEnergyTransfer()));
    }

    @Override
    public Predicate<ItemStack> isValidAmmo(ItemStack gunStack) {
        return stack -> stack.m_204117_(MWItemTagsProvider.STEEL_ROD);
    }

    @Override
    public void serverShoot(ItemStack stack, ServerPlayer player) {
        Level level = player.m_9236_();
        Vec3 lookAngle = player.m_20154_();
        Vec3 pos = player.m_146892_().m_82549_(lookAngle.m_82541_().m_82490_(0.1));
        if (this.isReady(stack, player, level)) {
            this.setLastShotTick(stack, level.m_46467_());
            MekanismWeaponryPacketHandler.sendToClient(new ActivateGunClientPacket(), player);
            double dmg = MekanismWeaponryConfig.CONFIG.getRailgunDamage() * this.getScale(stack);
            RodEntity rod = new RodEntity(player, pos, dmg, this.isSecondMode(stack));
            rod.m_20256_(lookAngle.m_82520_(0.0, 0.015, 0.0).m_82541_().m_82490_(3.5 * this.getScale(stack)));
            level.m_7967_((Entity)rod);
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundRegistry.RAILGUN_SHOOT.get(), SoundSource.PLAYERS, 3.0f, 1.0f);
            this.setLoadedAmmo(stack, this.getLoadedAmmo(stack).m_255036_(this.getLoadedAmmo(stack).m_41613_() - 1));
            this.getEnergyStorage(stack).extractEnergy((int)((double)this.getEnergyUsage(stack) * this.getScale(stack)), false);
            if (this.isSecondMode(stack)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 4));
            }
        } else {
            if (!this.hasSufficientEnergy(stack)) {
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundRegistry.GUN_OUT_OF_ENERGY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (!this.hasAmmo(stack)) {
                this.tryStartReload(stack, player);
            }
            this.setShooting(stack, false);
        }
    }

    private double getScale(ItemStack stack) {
        return this.isSecondMode(stack) ? MekanismWeaponryConfig.CONFIG.getRailgunSecondModeScale() : 1.0;
    }

    @Override
    public void clientShoot(ItemStack stack, Player player) {
        if (this.isSecondMode(stack)) {
            this.triggerAnim((Entity)player, GeoItem.getId((ItemStack)stack), "controller", "shot_second");
            Vec3 v = player.m_20154_().m_82490_(-0.75);
            player.m_5997_(v.f_82479_, v.f_82480_, v.f_82481_);
        } else {
            this.triggerAnim((Entity)player, GeoItem.getId((ItemStack)stack), "controller", "shot_default");
        }
        ClientSetup.addRecoil(10);
    }

    @Override
    public void serverReload(ItemStack stack, ServerPlayer player) {
        player.m_36335_().m_41524_(stack.m_41720_(), this.getReloadTime(stack));
        player.m_284548_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundRegistry.RAILGUN_RELOAD.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        Scheduler.schedule(() -> {
            if (player.m_150109_().m_36063_(stack)) {
                this.loadAmmo(stack, player);
            }
        }, 35);
    }

    @Override
    public void clientReload(ItemStack stack, Player player) {
        this.triggerAnim((Entity)player, GeoItem.getId((ItemStack)stack), "controller", "reload");
    }

    @Override
    public boolean canInstallAddon(ItemStack gunStack, ItemStack addonStack) {
        if (addonStack.m_41720_().getClass().equals(EnergyUsageChipItem.class)) {
            return true;
        }
        if (addonStack.m_41720_().getClass().equals(FireRateChipItem.class)) {
            return true;
        }
        if (addonStack.m_41720_().getClass().equals(PaintBucketItem.class)) {
            return true;
        }
        return addonStack.m_41720_().getClass().equals(ScopeAddonItem.class);
    }

    public boolean isSecondMode(ItemStack stack) {
        if (stack.m_41784_().m_128441_("railgun_secondary_mode")) {
            return stack.m_41784_().m_128471_("railgun_secondary_mode");
        }
        this.setSecondMode(stack, false);
        return this.isSecondMode(stack);
    }

    public void setSecondMode(ItemStack stack, boolean secondMode) {
        stack.m_41784_().m_128379_("railgun_secondary_mode", secondMode);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (player.m_6047_()) {
            boolean secondMode = this.isSecondMode(stack);
            if (!secondMode) {
                this.triggerAnim((Entity)player, GeoItem.getId((ItemStack)stack), "controller", "switch_to_second");
                this.setSecondMode(stack, true);
            } else {
                this.triggerAnim((Entity)player, GeoItem.getId((ItemStack)stack), "controller", "switch_to_default");
                this.setSecondMode(stack, false);
            }
            player.m_36335_().m_41524_(stack.m_41720_(), 20);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
        }
        return super.m_7203_(level, player, usedHand);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private RailgunRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new RailgunRenderer();
                }
                return this.renderer;
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
             @NotNull HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        });
    }

    @Override
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"mekanism_weaponry.tooltip.railgun_mode_label").m_130948_(Style.f_131099_.m_178520_(7798566)).m_7220_((Component)Component.m_237115_((String)(this.isSecondMode(pStack) ? "mekanism_weaponry.tooltip.railgun_second_mode" : "mekanism_weaponry.tooltip.railgun_first_mode")).m_130948_(Style.f_131099_.m_178520_(0xFFFFFF)).m_7220_((Component)Component.m_237113_((String)" [SHIFT + RMB]").m_130948_(Style.f_131099_.m_178520_(0x5C5C5C)))));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 1, state -> {
            if (!state.getController().isPlayingTriggeredAnimation()) {
                if (!this.isSecondMode((ItemStack)state.getData(DataTickets.ITEMSTACK))) {
                    state.setAnimation(DEFAULT_MODE);
                } else {
                    state.setAnimation(SECOND_MODE);
                }
            }
            if (((ItemDisplayContext)state.getData(DataTickets.ITEM_RENDER_PERSPECTIVE)).m_269069_()) {
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }).receiveTriggeredAnimations().triggerableAnim("switch_to_default", SWITCH_TO_DEFAULT).triggerableAnim("switch_to_second", SWITCH_TO_SECOND).triggerableAnim("shot_default", SHOT_DEFAULT).triggerableAnim("shot_second", SHOT_SECOND).triggerableAnim("reload", RELOAD)});
    }

    public boolean isPerspectiveAware() {
        return true;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

